/*
 * Decompiled with CFR 0.152.
 */
package dev.clojurephant.plugin.clojure;

import dev.clojurephant.plugin.clojure.ClojureBasePlugin;
import dev.clojurephant.plugin.clojure.ClojureBuild;
import dev.clojurephant.plugin.clojure.ClojureExtension;
import dev.clojurephant.plugin.clojure.tasks.ClojureSourceSet;
import dev.clojurephant.plugin.common.internal.ClojureCommonPlugin;
import java.util.stream.Collectors;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.tasks.SourceSetContainer;

public class ClojurePlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPlugins().apply(ClojureBasePlugin.class);
        project.getPlugins().apply(ClojureCommonPlugin.class);
        ClojureExtension extension = (ClojureExtension)project.getExtensions().getByType(ClojureExtension.class);
        this.configureBuilds(project, extension);
        SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
        ClojureCommonPlugin.configureDevSource(sourceSets, sourceSet -> {
            ClojureSourceSet src = (ClojureSourceSet)new DslObject(sourceSet).getConvention().getPlugins().get("clojure");
            return src.getClojure();
        });
    }

    private void configureBuilds(Project project, ClojureExtension extension) {
        ClojureBuild main = (ClojureBuild)extension.getBuilds().getByName("main");
        main.checkAll();
        extension.getBuilds().matching(build -> build.getName().toLowerCase().contains("test")).all(ClojureBuild::aotAll);
        ClojureBuild dev = (ClojureBuild)extension.getBuilds().getByName("dev");
        dev.getCheckNamespaces().set(dev.getAllNamespaces().map(nses -> nses.stream().filter("user"::equals).collect(Collectors.toSet())));
    }
}

