/*
 * Decompiled with CFR 0.152.
 */
package dev.clojurephant.plugin.clojure;

import dev.clojurephant.plugin.clojure.ClojureBuild;
import dev.clojurephant.plugin.clojure.ClojureExtension;
import dev.clojurephant.plugin.clojure.internal.DefaultClojureSourceSet;
import dev.clojurephant.plugin.clojure.tasks.ClojureCheck;
import dev.clojurephant.plugin.clojure.tasks.ClojureCompile;
import dev.clojurephant.plugin.clojure.tasks.ClojureSourceSet;
import dev.clojurephant.plugin.common.internal.ClojureCommonBasePlugin;
import dev.clojurephant.plugin.common.internal.Namespaces;
import java.io.File;
import java.util.Collections;
import javax.inject.Inject;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.tasks.DefaultSourceSetOutput;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskContainer;

public class ClojureBasePlugin
implements Plugin<Project> {
    private final ObjectFactory objects;

    @Inject
    public ClojureBasePlugin(ObjectFactory objects) {
        this.objects = objects;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(ClojureCommonBasePlugin.class);
        ClojureExtension extension = (ClojureExtension)project.getExtensions().create("clojure", ClojureExtension.class, new Object[0]);
        this.configureSourceSetDefaults(project, extension);
        this.configureBuildDefaults(project, extension);
        this.configureCheckDefaults(project.getTasks());
    }

    private void configureSourceSetDefaults(Project project, ClojureExtension extension) {
        ((SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class)).all(sourceSet -> {
            DefaultClojureSourceSet clojureSourceSet = new DefaultClojureSourceSet("clojure", this.objects);
            new DslObject(sourceSet).getConvention().getPlugins().put("clojure", clojureSourceSet);
            clojureSourceSet.getClojure().srcDir((Object)String.format("src/%s/clojure", sourceSet.getName()));
            clojureSourceSet.getClojure().getFilter().include(Namespaces.CLOJURE_PATTERNS);
            sourceSet.getResources().getFilter().exclude(element -> clojureSourceSet.getClojure().contains(element.getFile()));
            sourceSet.getAllSource().source(clojureSourceSet.getClojure());
            ClojureBuild build = (ClojureBuild)extension.getBuilds().create(sourceSet.getName());
            ClojureSourceSet clojure = (ClojureSourceSet)new DslObject(sourceSet).getConvention().getPlugins().get("clojure");
            build.getSourceRoots().from(new Object[]{clojure.getClojure().getSourceDirectories()});
            build.getClasspath().from(new Object[]{build.getSourceRoots()}).from(new Object[]{project.provider(() -> sourceSet.getCompileClasspath())}).from(new Object[]{project.getTasks().named(sourceSet.getCompileJavaTaskName())}).from(new Object[]{project.getTasks().named(sourceSet.getProcessResourcesTaskName())});
            project.getTasks().named(sourceSet.getClassesTaskName(), task -> {
                task.dependsOn(new Object[]{build.getTaskName("compile")});
                task.dependsOn(new Object[]{build.getTaskName("check")});
            });
            Provider output = project.provider(() -> {
                if (build.isCompilerConfigured()) {
                    return project.files(new Object[]{build.getOutputDir()});
                }
                return clojureSourceSet.getClojure().getSourceDirectories();
            });
            ((DefaultSourceSetOutput)sourceSet.getOutput()).getClassesDirs().from(new Object[]{output});
            project.getTasks().getByName(sourceSet.getClassesTaskName()).dependsOn(new Object[]{build.getTaskName("compile")});
            project.getTasks().getByName(sourceSet.getClassesTaskName()).dependsOn(new Object[]{build.getTaskName("check")});
        });
    }

    private void configureBuildDefaults(Project project, ClojureExtension extension) {
        extension.getRootOutputDir().set(project.getLayout().getBuildDirectory().dir("clojure"));
        extension.getBuilds().configureEach(build -> {
            build.getOutputDir().convention(extension.getRootOutputDir().dir(build.getName()));
            build.getReflection().convention((Object)"silent");
            build.getCompiler().getDirectLinking().convention((Object)false);
            build.getCompiler().getDisableLocalsClearing().convention((Object)false);
            build.getCompiler().getElideMeta().convention(Collections.emptyList());
            String checkTaskName = build.getTaskName("check");
            project.getTasks().register(checkTaskName, ClojureCheck.class, task -> {
                task.setDescription(String.format("Checks the Clojure source for the %s build.", build.getName()));
                task.setSource(build.getSourceTree());
                task.getClasspath().from(new Object[]{build.getClasspath()});
                task.getReflection().set(build.getReflection());
                task.getNamespaces().set(build.getCheckNamespaces());
            });
            String compileTaskName = build.getTaskName("compile");
            project.getTasks().register(compileTaskName, ClojureCompile.class, task -> {
                task.setDescription(String.format("Compiles the Clojure source for the %s build.", build.getName()));
                task.getDestinationDir().set((Provider)build.getOutputDir());
                task.setSource(build.getSourceTree());
                task.getClasspath().from(new Object[]{build.getClasspath()});
                task.getOptions().set((Object)build.getCompiler());
                task.getNamespaces().set(build.getAotNamespaces());
            });
        });
    }

    private void configureCheckDefaults(TaskContainer tasks) {
        tasks.withType(ClojureCheck.class, task -> task.getInternalOutputFile().set(new File(task.getTemporaryDir(), "internal.txt")));
    }
}

