/*
 * Decompiled with CFR 0.152.
 */
package dev.clojurephant.plugin.clojure;

import dev.clojurephant.plugin.clojure.tasks.ClojureCompileOptions;
import dev.clojurephant.plugin.clojure.tasks.ClojureSourceSet;
import dev.clojurephant.plugin.common.internal.Namespaces;
import java.util.Set;
import org.apache.commons.text.WordUtils;
import org.gradle.api.Action;
import org.gradle.api.Named;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.SourceSet;

public abstract class ClojureBuild
implements Named {
    public abstract DirectoryProperty getOutputDir();

    public abstract Property<SourceSet> getSourceSet();

    Provider<FileCollection> getSourceRoots() {
        return this.getSourceSet().map(sourceSet -> {
            ClojureSourceSet clojure = (ClojureSourceSet)new DslObject(sourceSet).getConvention().getPlugins().get("clojure");
            return clojure.getClojure().getSourceDirectories();
        });
    }

    Provider<Set<String>> getAllNamespaces() {
        return this.getSourceRoots().map(roots -> Namespaces.findNamespaces(roots, Namespaces.CLOJURE_EXTENSIONS));
    }

    public abstract SetProperty<String> getCheckNamespaces();

    public void checkAll() {
        this.getCheckNamespaces().set(this.getAllNamespaces());
    }

    public abstract Property<String> getReflection();

    boolean isCompilerConfigured() {
        return (Boolean)this.getAotNamespaces().map(set -> !set.isEmpty()).getOrElse((Object)false);
    }

    public abstract SetProperty<String> getAotNamespaces();

    public void aotAll() {
        this.getAotNamespaces().set(this.getAllNamespaces());
    }

    @Nested
    public abstract ClojureCompileOptions getCompiler();

    public void compiler(Action<? super ClojureCompileOptions> configureAction) {
        configureAction.execute((Object)this.getCompiler());
    }

    String getTaskName(String task) {
        if ("main".equals(this.getName())) {
            return String.format("%sClojure", task);
        }
        return String.format("%s%sClojure", task, WordUtils.capitalize((String)this.getName()));
    }
}

