/*
 * Decompiled with CFR 0.152.
 */
package dev.clojurephant.plugin.clojurescript.tasks;

import dev.clojurephant.plugin.clojurescript.tasks.ClojureScriptCompileOptions;
import dev.clojurephant.plugin.common.internal.ClojureException;
import dev.clojurephant.plugin.common.internal.Edn;
import dev.clojurephant.plugin.common.internal.Namespaces;
import dev.clojurephant.plugin.common.internal.Prepl;
import dev.clojurephant.plugin.common.internal.PreplClient;
import dev.clojurephant.plugin.common.internal.PreplSpec;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.compile.ForkOptions;
import org.gradle.process.JavaForkOptions;
import us.bpsm.edn.Symbol;

public class ClojureScriptCompile
extends DefaultTask {
    private final Prepl prepl = new Prepl(this.getProject());
    private ConfigurableFileCollection sourceRoots;
    private final DirectoryProperty destinationDir = this.getProject().getObjects().directoryProperty();
    private final ConfigurableFileCollection classpath;
    private ClojureScriptCompileOptions options;
    private final ForkOptions forkOptions;

    public ClojureScriptCompile() {
        this.sourceRoots = this.getProject().files(new Object[0]);
        this.classpath = this.getProject().files(new Object[0]);
        this.options = new ClojureScriptCompileOptions(this.getProject(), this.destinationDir);
        this.forkOptions = new ForkOptions();
    }

    @InputFiles
    @SkipWhenEmpty
    public FileCollection getSource() {
        return Namespaces.getSources((FileCollection)this.sourceRoots, Namespaces.CLOJURESCRIPT_EXTENSIONS);
    }

    @Internal
    public ConfigurableFileCollection getSourceRoots() {
        return this.sourceRoots;
    }

    @OutputDirectory
    public DirectoryProperty getDestinationDir() {
        return this.destinationDir;
    }

    @Classpath
    public ConfigurableFileCollection getClasspath() {
        return this.classpath;
    }

    @Nested
    public ClojureScriptCompileOptions getOptions() {
        return this.options;
    }

    public void setOptions(ClojureScriptCompileOptions options) {
        this.options = options;
    }

    @Nested
    public ForkOptions getForkOptions() {
        return this.forkOptions;
    }

    public void forkOptions(Action<? super ForkOptions> configureAction) {
        configureAction.execute((Object)this.forkOptions);
    }

    @TaskAction
    public void compile() {
        File outputDir = ((Directory)this.getDestinationDir().get()).getAsFile();
        if (!this.getProject().delete(new Object[]{outputDir})) {
            throw new GradleException("Cannot clean destination directory: " + outputDir.getAbsolutePath());
        }
        if (!outputDir.mkdirs()) {
            throw new GradleException("Cannot create destination directory: " + outputDir.getAbsolutePath());
        }
        FileCollection classpath = this.getClasspath().plus((FileCollection)this.getSourceRoots());
        PreplClient preplClient = this.prepl.start((Action<PreplSpec>)((Action)spec -> {
            spec.setClasspath(classpath);
            spec.setPort(0);
            spec.forkOptions((Action<JavaForkOptions>)((Action)fork -> {
                fork.setJvmArgs(this.forkOptions.getJvmArgs());
                fork.setMinHeapSize(this.forkOptions.getMemoryInitialSize());
                fork.setMaxHeapSize(this.forkOptions.getMemoryMaximumSize());
                fork.setDefaultCharacterEncoding(StandardCharsets.UTF_8.name());
            }));
        }));
        boolean failures = false;
        try {
            preplClient.evalEdn("(require '[cljs.build.api :as api])");
            List<Object> form = Edn.list(Symbol.newSymbol((String)"api", (String)"build"), Edn.list(Symbol.newSymbol((String)"apply"), Symbol.newSymbol((String)"api", (String)"inputs"), this.getSourceRoots()), this.getOptions());
            preplClient.evalData(form);
            preplClient.evalEdn("(.flush *err*)");
        }
        catch (ClojureException e) {
            System.err.println(e.getMessage());
            failures = true;
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
        preplClient.close();
        preplClient.pollOutput().forEach(System.out::println);
        if (failures) {
            throw new GradleException("Compilation failed. See output above.");
        }
    }
}

