/*
 * Decompiled with CFR 0.152.
 */
package dev.clojurephant.plugin.clojure.tasks;

import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.compile.ForkOptions;
import org.gradle.api.tasks.options.Option;
import org.gradle.process.JavaExecSpec;

public class ClojureNRepl
extends DefaultTask {
    private ForkOptions forkOptions = new ForkOptions();
    private FileCollection classpath;
    private final Property<String> bind;
    private int port = 0;
    private int ackPort = 0;
    private final Property<String> handler;
    private final ListProperty<String> userMiddleware;
    private final ListProperty<String> defaultMiddleware;
    private final Property<String> transport;

    @Inject
    public ClojureNRepl(ObjectFactory objects) {
        this.bind = objects.property(String.class);
        this.handler = objects.property(String.class);
        this.userMiddleware = objects.listProperty(String.class);
        this.defaultMiddleware = objects.listProperty(String.class);
        this.transport = objects.property(String.class);
        this.getOutputs().upToDateWhen(t -> false);
    }

    @TaskAction
    public void run() {
        if (!this.getProject().delete(new Object[]{this.getTemporaryDir()})) {
            throw new GradleException("Cannot clean temporary directory: " + this.getTemporaryDir().getAbsolutePath());
        }
        ConfigurableFileCollection cp = this.getProject().files(new Object[]{this.getTemporaryDir(), this.getClasspath()});
        List middleware = Stream.of((List)this.defaultMiddleware.getOrElse(Collections.emptyList()), (List)this.userMiddleware.getOrElse(Collections.emptyList())).flatMap(Collection::stream).collect(Collectors.toList());
        this.getProject().javaexec(arg_0 -> this.lambda$run$1((FileCollection)cp, middleware, arg_0)).assertNormalExitValue();
        System.out.println("nREPL server stopped");
    }

    @Nested
    public ForkOptions getForkOptions() {
        return this.forkOptions;
    }

    public ClojureNRepl forkOptions(Action<? super ForkOptions> configureAction) {
        configureAction.execute((Object)this.forkOptions);
        return this;
    }

    @Classpath
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void setClasspath(FileCollection classpath) {
        this.classpath = classpath;
    }

    @Input
    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Option(option="port", description="Port the nREPL server should listen on.")
    public void setPort(String port) {
        this.setPort(Integer.parseInt(port));
    }

    @Input
    public int getAckPort() {
        return this.ackPort;
    }

    public void setAckPort(int ackPort) {
        this.ackPort = ackPort;
    }

    @Option(option="ackPort", description="Acknowledge the port of this server to another nREPL server.")
    public void setAckPort(String ackPort) {
        this.setAckPort(Integer.parseInt(ackPort));
    }

    @Optional
    @Input
    public Property<String> getHandler() {
        return this.handler;
    }

    @Option(option="handler", description="Qualified name of nREPL handler function.")
    public void setHandler(String handler) {
        this.handler.set((Object)handler);
    }

    @Optional
    @Input
    public ListProperty<String> getMiddleware() {
        return this.userMiddleware;
    }

    @Option(option="middleware", description="Qualified names of nREPL middleware functions.")
    public void setMiddleware(List<String> middleware) {
        if (middleware != null) {
            this.userMiddleware.set(middleware);
        }
    }

    @Optional
    @Input
    public ListProperty<String> getDefaultMiddleware() {
        return this.defaultMiddleware;
    }

    private /* synthetic */ void lambda$run$1(FileCollection cp, List middleware, JavaExecSpec spec) {
        spec.setClasspath(cp);
        spec.setMain("clojure.main");
        spec.args(new Object[]{"-m", "nrepl.cmdline"});
        if (this.bind.isPresent()) {
            spec.args(new Object[]{"--bind", this.bind.get()});
        }
        if (this.port > 0) {
            spec.args(new Object[]{"--port", this.port});
        }
        if (this.ackPort > 0) {
            spec.args(new Object[]{"--ack", this.ackPort});
        }
        if (this.handler.isPresent()) {
            spec.args(new Object[]{"--handler", this.handler.get()});
        }
        if (!middleware.isEmpty()) {
            spec.args(new Object[]{"--middleware", "[" + String.join((CharSequence)" ", middleware) + "]"});
        }
        if (this.transport.isPresent()) {
            spec.args(new Object[]{"--transport", this.transport.get()});
        }
        spec.setJvmArgs(this.getForkOptions().getJvmArgs());
        spec.setMinHeapSize(this.getForkOptions().getMemoryInitialSize());
        spec.setMaxHeapSize(this.getForkOptions().getMemoryMaximumSize());
        spec.setDefaultCharacterEncoding(StandardCharsets.UTF_8.name());
    }
}

