/*
 * Decompiled with CFR 0.152.
 */
package dev.clojurephant.plugin.clojure.tasks;

import dev.clojurephant.plugin.clojure.tasks.ClojureCompile;
import dev.clojurephant.plugin.clojure.tasks.ClojureReflection;
import dev.clojurephant.plugin.common.internal.ClojureException;
import dev.clojurephant.plugin.common.internal.Edn;
import dev.clojurephant.plugin.common.internal.Namespaces;
import dev.clojurephant.plugin.common.internal.Prepl;
import dev.clojurephant.plugin.common.internal.PreplClient;
import dev.clojurephant.plugin.common.internal.PreplSpec;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.compile.ForkOptions;
import org.gradle.process.JavaForkOptions;
import us.bpsm.edn.Symbol;

public class ClojureCheck
extends DefaultTask {
    private static final Logger logger = Logging.getLogger(ClojureCompile.class);
    private static final Pattern REFLECTION_WARNING = Pattern.compile("Reflection warning, (.+?):.*");
    private final Prepl prepl = new Prepl(this.getProject());
    private final ConfigurableFileCollection sourceRoots = this.getProject().files(new Object[0]);
    private final ConfigurableFileCollection classpath = this.getProject().files(new Object[0]);
    private final RegularFileProperty outputFile = this.getProject().getObjects().fileProperty();
    private final Property<ClojureReflection> reflection = this.getProject().getObjects().property(ClojureReflection.class);
    private final ForkOptions forkOptions = new ForkOptions();
    private final SetProperty<String> namespaces = this.getProject().getObjects().setProperty(String.class);

    public ClojureCheck() {
        this.outputFile.set(new File(this.getTemporaryDir(), "internal.txt"));
        this.onlyIf(task -> !((Set)this.getNamespaces().getOrElse(Collections.emptySet())).isEmpty());
    }

    @InputFiles
    @SkipWhenEmpty
    public FileCollection getSource() {
        return Namespaces.getSources((FileCollection)this.sourceRoots, Namespaces.CLOJURE_EXTENSIONS);
    }

    @Internal
    public ConfigurableFileCollection getSourceRoots() {
        return this.sourceRoots;
    }

    @Classpath
    public ConfigurableFileCollection getClasspath() {
        return this.classpath;
    }

    @OutputFile
    public RegularFileProperty getInternalOutputFile() {
        return this.outputFile;
    }

    @Input
    public Property<ClojureReflection> getReflection() {
        return this.reflection;
    }

    @Nested
    public ForkOptions getForkOptions() {
        return this.forkOptions;
    }

    public void forkOptions(Action<? super ForkOptions> configureAction) {
        configureAction.execute((Object)this.forkOptions);
    }

    @Input
    public SetProperty<String> getNamespaces() {
        return this.namespaces;
    }

    @TaskAction
    public void check() {
        if (!this.getProject().delete(new Object[]{this.getTemporaryDir()})) {
            throw new GradleException("Cannot clean temporary directory: " + this.getTemporaryDir().getAbsolutePath());
        }
        Set namespaces = (Set)this.getNamespaces().getOrElse(Collections.emptySet());
        logger.info("Checking {}", (Object)String.join((CharSequence)", ", namespaces));
        FileCollection classpath = this.getClasspath().plus((FileCollection)this.getSourceRoots()).plus((FileCollection)this.getProject().files(new Object[]{this.getTemporaryDir()}));
        PreplClient preplClient = this.prepl.start((Action<PreplSpec>)((Action)spec -> {
            spec.setClasspath(classpath);
            spec.setPort(0);
            spec.forkOptions((Action<JavaForkOptions>)((Action)fork -> {
                fork.setJvmArgs(this.forkOptions.getJvmArgs());
                fork.setMinHeapSize(this.forkOptions.getMemoryInitialSize());
                fork.setMaxHeapSize(this.forkOptions.getMemoryMaximumSize());
                fork.setDefaultCharacterEncoding(StandardCharsets.UTF_8.name());
            }));
        }));
        boolean failures = false;
        boolean projectReflectionWarnings = false;
        try {
            preplClient.evalData(Edn.list(Symbol.newSymbol((String)"set!"), Symbol.newSymbol((String)"clojure.core", (String)"*warn-on-reflection*"), ClojureReflection.silent != this.getReflection().get()));
            for (String namespace : namespaces) {
                String nsFilePath = namespace.replace('-', '_').replace('.', '/');
                try {
                    preplClient.evalData(Edn.list(Symbol.newSymbol((String)"load"), nsFilePath));
                    preplClient.evalEdn("(.flush *err*)");
                }
                catch (ClojureException e) {
                    failures = true;
                    System.err.println(e.getMessage());
                }
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
        preplClient.close();
        for (String out : preplClient.pollOutput()) {
            System.out.println(out);
            Matcher m = REFLECTION_WARNING.matcher(out);
            if (!m.find()) continue;
            String sourceFile = m.group(1);
            boolean isProjectFile = this.getSourceRoots().getFiles().stream().map(sourceRoot -> new File((File)sourceRoot, sourceFile)).filter(File::exists).findAny().isPresent();
            projectReflectionWarnings = projectReflectionWarnings || isProjectFile;
        }
        if (ClojureReflection.fail == this.getReflection().get() && projectReflectionWarnings) {
            throw new GradleException("Reflection warnings found. See output above.");
        }
        if (failures) {
            throw new GradleException("Compilation failed. See output above.");
        }
        Path output = ((RegularFile)this.getInternalOutputFile().get()).getAsFile().toPath();
        try {
            Files.write(output, Arrays.asList(Instant.now().toString()), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

