/*
 * Decompiled with CFR 0.152.
 */
package dev.clojurephant.plugin.common.internal;

import dev.clojurephant.plugin.common.internal.PreplClient;
import dev.clojurephant.plugin.common.internal.PreplSpec;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import org.gradle.api.Action;
import org.gradle.api.Project;

public class Prepl {
    private final Project project;

    public Prepl(Project project) {
        this.project = project;
    }

    public PreplClient start(Action<PreplSpec> action) {
        PreplSpec spec = new PreplSpec();
        action.execute((Object)spec);
        return this.start(spec);
    }

    public PreplClient start(PreplSpec preplSpec) {
        int port;
        block15: {
            if (preplSpec.getPort() == 0) {
                try (ServerSocket socket = new ServerSocket(0);){
                    port = socket.getLocalPort();
                    break block15;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            port = preplSpec.getPort();
        }
        new Thread(() -> this.project.javaexec(spec -> {
            spec.setMain("clojure.main");
            spec.systemProperty("clojure.server.clojurephant", (Object)String.format("{:port %d :accept clojure.core.server/io-prepl :client-daemon false}", port));
            spec.args(new Object[]{"-e", "(do (ns dev.clojurephant.prepl) (def connected (promise)) @connected nil)"});
            spec.setClasspath(preplSpec.getClasspath());
            preplSpec.getConfigureFork().forEach(forkAction -> forkAction.execute(spec));
        })).start();
        return PreplClient.socketConnect(InetAddress.getLoopbackAddress(), port);
    }
}

