(ns bilus.pocketbase.records
  "Promise-based wrapper for PocketBase Records API.

   This namespace wraps synchronous functions from bilus.pocketbase.sync.records to return promises,
   making the API consistent between Clojure and ClojureScript."
  (:require [bilus.pocketbase.sync.records :as records]
            [bilus.pocketbase.util :refer [promisify]]))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Public
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(promisify records/paginated)
(promisify records/all)
(promisify records/find-first)
(promisify records/one)
(promisify records/create!)
(promisify records/update!)
(promisify records/delete!)
