(ns bilus.pocketbase.collections
  "Promise-based wrapper for PocketBase Collections API.

   This namespace wraps synchronous functions from bilus.pocketbase.sync.collections to return promises,
   making the API consistent between Clojure and ClojureScript."
  (:require [bilus.pocketbase.sync.collections :as collections]
            [bilus.pocketbase.util :refer [promisify reexport]]))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Public
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(promisify collections/paginated)
(promisify collections/all)
(promisify collections/find-first)
(promisify collections/one)
(promisify collections/create!)
(promisify collections/update!)
(promisify collections/delete!)
(promisify collections/truncate!)

(reexport collections/text-field)
(reexport collections/number-field)
(reexport collections/bool-field)
(reexport collections/email-field)
(reexport collections/url-field)
(reexport collections/date-field)
(reexport collections/select-field)
(reexport collections/json-field)
(reexport collections/file-field)
(reexport collections/relation-field)
(reexport collections/editor-field)
