(ns bilus.pocketbase.util
  (:require [promesa.core]))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Public
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defmacro promisify
  "Turns a synchronous function into one that returns a promise to make Clojure
   PocketBase functions behave like their ClojureScript counterparts."
  [qualified-fn]
  `(defn ~(symbol (name qualified-fn)) [& args#]
     (promesa.core/future (apply ~qualified-fn args#))))

(defmacro reexport
  "Simply re-exports a var, typically a function, from another namespace."
  [qualified-fn]
  `(def ~(symbol (name qualified-fn)) ~qualified-fn))

(defn <p!
  "Dereferences a promise, blocking until it is resolved.
   Used in .cljc tests to emulate cljs.async.interop/<p! in Clojure."
  [promise]
  @promise)
