(ns bilus.pocketbase.core
  "Promise-based wrapper for PocketBase core functions.

   This namespace wraps synchronous functions from bilus.pocketbase.sync.core to return promises,
   making the API consistent between Clojure and ClojureScript."
  (:require [bilus.pocketbase.sync.core :as pb]
            [bilus.pocketbase.util :refer [promisify reexport]]
            [promesa.core]))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Public
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(reexport pb/create-client)
(reexport pb/collection)
(reexport pb/auth-valid?)
(reexport pb/auth-token)
(reexport pb/auth-record)
(reexport pb/clear-auth!)
(reexport pb/get-file-url)

(promisify pb/auth-with-password)
(promisify pb/auth-with-oauth2-code)
(promisify pb/request-otp)
(promisify pb/auth-with-otp)
(promisify pb/auth-refresh)
(promisify pb/list-auth-methods)
(promisify pb/request-verification)
(promisify pb/confirm-verification)
(promisify pb/request-password-reset)
(promisify pb/confirm-password-reset)
(promisify pb/request-email-change)
(promisify pb/confirm-email-change)
(promisify pb/impersonate)

(defmacro with-debug
  "Executes body with debug logging enabled."
  [& body]
  `(bilus.pocketbase.sync.core/with-debug ~@body))
