(ns clj-hyphenate.patterns.sr-cyrl
  "This pattern is imported from Hyphenator.js. Original comment follows:

   For questions about the serbian cyrillic hyphenation patterns ask Milan Gurjanov (milan dot gurjanov at enterits dot rs) "
  (:require [clj-hyphenate.patterns :as pat]))

(def rules'
{:leftmin 2,
 :rightmin 2,
 :specialChars "ђћчшжаблијнцервктугпозсдфмхљњџ",
 :patterns
 {7
  "_и3с4ме_бе2з3в3х2тети3г2незд_у3з4рн_у3з4рњ_а2б3ју3г2нежђ_бе2з3б_а2б3ла_а2б3лу_бе2з3л_бе2з3и_бе2з3г_и3з4ун_бе2з3д_о3б4рђ_о3б4рч_о3б4рш_из3г2н_на2д3л_на2д3љ_а2нарт_о3д4рл_о3д4рљ_о3д4рн_бе2з3м_бе2з3н_о3д4рп_о3д4рт_и3с4уш_и3с4ук_и3с4ус_за3г2н_и3с4ут_бе2з3њ_бе2з3о_бе2з3р3б2дјет_и3с4рк3б2дјењ_о2б3уж_бе2з3у_о2б3уд3т2маст3х2тјев3х2тјењ_о2б3уз_изд2на_на2д3в_о2д3же_о2д3жи_о2д3жв_а2неор_на2ј3а_о3б4рк_о3б4рл_бе2ш3ћ_ра2ш3ћ_ра2ш3ч_ра2ж3ђ_ра2с3ц_у3г2ми_ра2с3к_ра2с3п_ра2с3т_о3б4рљ_у3с4ко_ра2з3б_ра2з3д_бе2з3љ_ра2з3е_ра2з3г_ра2з3и_ра2з3л_ра2з3љ_ра2з3м_ра2з3н_ра2з3њ_о3б4рн_на2ј3е_на2ј3и_на2ј3о_на2ј3у_изд2но_бе2ш3ч_о3б4рс_изд2ну_ра2з3р_и3з4иђ_о2д3ок_и3з4ид_и2н3ед_бе2с3т_бе2с3п_а4е2ро_су2б3а_у3с4рђ_у3с4рж_у3с4ра_у3с4рд_у3с4ре_бе2с3к_у3с4рк_у3с4рљ_у3с4рн_у3с4рп_бе2с3ц_су2б3л3х2тјел_ра2з3в_о2д3уч_од3г2н_од3м2н_о2д3ук_о2д3ул_о2д3ум_по3г2н_по3м2н_по3м2њ_по3р2ђ_о3д4рж_и2н3ег_по2д3ј",
  4
  "2к1з2жбж2ш1с2ш1р2ш1ј2ш1х2ш1г2ш1ф2ш1џ2ш1д2ш1б2ш1ж2ш1ш2ш1ђ2чв_2ч1з2ч1т2ч1с2ч1р2ч1н2ч1м2ч1љ2ч1к2ч1ј2ч1х2ч1г2ч1ф2ч1џ2ч1д2ч1ц2ч1б2ч1ж2ч1ш2ч1ч2ч1ћ2ч1ђ2звз2звв2звс2звп2звн2звм2звк2звх2звг2звф2звџ2звд2звц2звб2звж2звш2звч2звћ2звђ2зв_2зр_2ћ1з2ћ1с2ћ1р2ћ1н2зњ_2зн_2змз2ћ1м2змв2змс2ћ1љ2змп2ћ1к2ћ1х2ћ1г2ћ1ф2ћ1џ2ћ1д2ћ1ц2ћ1б2ћ1ж2ћ1ш2ћ1ч2змн2змм2змк2змх2змг2змф2змџ2змд2змц2змб2змж2змш2змч2змћ2змђ2зм_2зљ_2зл_2зј_2згз2згс2згп2згн2згм2згк2згх2згг2згф2згџ2згд2згц2згб2згж2згч2згћ2згђ2зг_2здз2здс2здп2здн2здм2здк2здх2здг2здф2здџ2здд2здц2здб2здш2здч2здћ2здђ2зд_2збз2збв2збс2збп2збн2збм2збк2збх2збг2збф2збџ2збд2збц2збб2збж2збш2збч2збћ2збђ2зб_2з1з2з1с2з1п2з1к2з1х2з1ф2з1џ2з1ц2з1ж2з1ш2з1ч2з1ћ2з1ђ2вр_2вљ_2вл_2вј_2в1з2в1в2в1т2в1с2в1п2в1н2в1м2в1к2в1х2в1г2в1ф2в1џ2в1д2в1ц2в1б2в1ж2в1ш2в1ч2в1ћ2в1ђ2тв_2тр_2тљ_2тл_2тј_2т1з2т1т2т1с2т1п2т1н2т1м2т1к2т1х2т1г2т1ф2ћ1ћ2т1џ2т1д2т1ц2т1б2т1ж2т1ш2т1ч2т1ћ2т1ђ2свз2свв2свт2свс2свп2свн2свм2свк2свх2свг2свф2свџ2свд2свц2свб2свж2свш2свч2свћ2свђ2св_2стз2стт2стс2стп2стн2стм2стк2стх2стг2стф2стџ2стд2стц2стб2стж2стш2стч2стћ2стђ2ст_2ср_2спз2спв2спт2спс2спп2ћ1ђ2спн2спм2спк2спх2спг2спф2спџ2спд2спц2спб2спж2спш2спч2спћ2спђ2сп_2сњ_2сн_2смз2смт2смс2смн2смм2смк2смх2смг2смф2смџ2смд2смц2смб2смж2смш2смч2смћ2смђ2см_2сљ_2сл_2скз2скт2скс2скн2скм2скк2скх2скг2скф2скџ2скд2скц2скб2скж2скш2скч2скћ2скђ2ск_2сј_2сцз2сцт2сцс2сцр2сцн2сцм2сцљ2сцк2сцх2сцг2сцф2сцџ2сцд2сцц2сцб2сцж2сцш2сцч2сцћ2сцђ2сц_2с1з2с1с2с1х2с1г2с1ф2с1џ2с1д2ђ1з2ђ1с2с1б2с1ж2с1ш2с1ч2с1ћ2с1ђ2р1з2р1т2р1с2р1р2р1н2ђ1р2р1м2р1љ2р1к2р1ј2р1х2р1г2р1ф2р1џ2р1д2р1ц2р1б2р1ж2р1ш2р1ч2р1ћ2р1ђ2пр_2пљ_2пл_2ђ1н2пј_2н1з2н1т2н1с2ђ1м2н1р2н1н2н1м2н1љ2н1к2н1х2н1г2н1ф2н1џ2н1д2н1ц2н1б2ђ1љ2ђ1к2н1ж2н1ш2н1ч2н1ћ2н1ђ2мр_2ђ1х2мљ_2мл_2мј_2м1з2м1т2м1с2ђ1г2м1н2м1м2м1к2м1х2м1г2м1ф2м1џ2м1д2м1ц2м1б2м1ж2м1ш2м1ч2м1ћ2м1ђ2љ1з2љ1т2љ1с2љ1р2љ1н2љ1м2љ1љ2љ1к2љ1ј2љ1х2љ1г2љ1ф2љ1џ2љ1д2љ1ц2љ1б2љ1ж2љ1ш2љ1ч2љ1ћ2љ1ђ2кв_2кр_2кљ_2кл_2кј_2ш1з2к1т2к1с2к1н2к1м2к1к2к1х2к1г2к1ф2к1џ2к1д2к1ц2к1б2к1ж2к1ш2к1ч2к1ћ2к1ђ2ј1з2ј1т2ј1с2ј1р2ј1н2ј1м2ј1љ2ј1к2ј1ј2ј1х2ј1г2ј1ф2ј1џ2ј1д2ј1ц2ј1б2ј1ж2ј1ш2ј1ч2ј1ћ2ј1ђ2хвз2хвт2хвс2хвн2хвм2хвк2хвх2хвг2хвф2хвџ2хвд2хвц2хвб2хвж2хвш2хвч2хвђ2хв_2хр_2хљ_2хл_2хј_2х1з2х1т2х1с2х1н2х1м2х1к2х1х2х1г2х1ф2х1џ2х1д2х1ц2х1б2х1ж2х1ш2х1ч2х1ћ2х1ђ2гв_2гр_2гљ_2гл_2гј_2г1з2г1т2г1с2г1н2г1м2г1к2г1х2г1г2г1ф2г1џ2г1д2г1ц2г1б2г1ж2г1ш2г1ч2г1ћ2г1ђ2фр_2фљ_2фл_2фј_2ф1з2ф1т2ф1с2ф1н2ф1м2ф1к2ф1х2ф1г2ф1ф2ф1џ2ф1д2ф1ц2ф1б2ф1ж2ф1ш2ф1ч2ф1ћ2ф1ђ2дв_2др_2дљ_2дл_2дј_2џ1з2џ1т2џ1с2џ1р2џ1н2џ1м2џ1љ2џ1к2џ1ј2џ1х2џ1г2џ1ф2џ1џ2џ1д2џ1ц2џ1б2џ1ж2џ1ш2џ1ч2џ1ћ2џ1ђ2д1з2д1т2д1с2д1н2д1м2д1к2д1х2д1г2д1ф2д1џ2д1д2д1ц2д1б2д1ш2д1ч2д1ћ2д1ђ2цв_2цр_2цј_2ц1з2ц1т2ц1с2ц1н2ц1м2ц1љ2ц1к2ц1х2ц1г2ц1ф2ц1џ2ц1д2ц1ц2ц1б2ц1ж2ц1ш2ц1ч2ц1ћ2ц1ђ2бр_2бљ_2бл_2бј_2б1з2б1т2б1с2б1н2б1м2б1к2б1х2б1г2б1ф2б1џ2б1д2б1ц2б1б2б1ж2б1ш2б1ч2б1ћ2б1ђ2жвз2жвт2жвс2жвн2жвм2жвк2жвх2жвг2жвф2жвџ2жвд2жвц2жвб2жвж2жвш2жвч2жвђ2жњ_2жн_2жмз2жмт2жмс2жмн2жмм2жмк2жмх2жмг2жмф2жмџ2жмд2жмц2жмб2жмж2жмш2жмч2жмђ2жм_2жљ_2жл_2жгз2жгт2жгс2жгн2жгм2жгк2жгх2жгг2жгф2жгџ2жгд2жгц2жгб2жгж2жгш2жгч2жг_2ждз2ждт2ждс2ждн2ждм2ждк2ждх2ждг2ждф2ждџ2ждд2ждц2ждб2ждш2ждч2жд_2жбз2жбт2жбс2жбн2жбм2жбк2жбх2жбг2жбф2жбџ2жбд2жбц2жбб2ђ1ф2жбш2жбч2жбђ2жб_2жђ_2ж1з2ж1т2ж1с2ж1р2ж1к2ж1ј2ж1х2ж1ф2ж1џ2ж1ц2ж1ж2ж1ш2ж1ч2ж1ћ2швз2швт2швс2швн2швм2швк2швх2швг2швф2швџ2швд2швц2швб2швж2швш2швч2швђ2шв_2штз2штт2штс2штн2штм2штк2ђ1џ2ђ1д2ђ1ц2ђ1б2ђ1ж2штх2штг2штф2штџ2штд2штц2штб2штж2штш2штч2штђ2шт_2шпз2шпт2шпс2шпн2шпм2шпк2шпх2шпг2шпф2шпџ2ђ1ш2ђ1ч2ђ1ћ2ђ1ђ2шпд2шпц2шпб2шћ_2шч_2шчћ2шчч2шпж2шпш2шпч2шпђ2шп_2шчш2шн_2шчж2шчб2шмз2шмт2шмс2шмн2шмм2шмк2шмх2шмг2шмф2шмџ2шмд2шмц2шмб2шмж2шмш2шмч2шмђ2шм_2шљ_2шкз2шкт2шкс2шкн2шкм2шкк2шкх2шкг2шкф2шкџ2шкд2шкц2шкб2шкж2шкш2шкч2шкћ2шкђ2шк_2шцз2шцт2шцс2шцр2шцн2шцм2шцљ2шцк2шцх2шцг2шцф2шцџ2шцд2шцц2шцб2шцж2шцш2шцч2шцћ2шц_2шчз2шчт2шчс2шчр2шчн2шчм2шчљ2шчк2шчј2шчх2шчг2шчф2шчџ2шчд2шчц",
  13 "_пре2д3убијеђ_бе2з3алкохол",
  6
  "3б2дењ_у3г2н_у2з3р_у2з3њ_у2з3н_у2з3м_у2з3љ_у2з3л_у2з3и_у2з3г_у2з3д_у2з3б_у2с3п_у2с3к_у2с3ц_у2ш3ч_у2ш3ћ_а2д3ј_о2д3в_о2д3р_о2д3љ_о2д3л_о2б3р_о2б3љ_о2б3ј_наг2њ_наг2н_изр2к_ист2к_и2з3в_и2з3у_и2з3р_и2з3о_и2з3њ_и2з3н_и2з3м_и2з3љ_и2з3л_и2з3и_и2з3г_и2з3д_и2з3б_и2с3т_и2с3п_и2с3к_и2с3ц3ч2лан3ч2лањ_у2з3в3б2дет3ц2мач3ц2мак3ц2миз3ц2мок3г2мил3г2миљ_и2ж3ђ_и2ш3ч_и2ш3ћ3г2миз3г2нај3г2нев3г2њав3г2њеч3г2њес3г2њет3г2њев3г2њил3г2њиљ3г2њио3г2њит3г2њур3г2ној3г2нос3г2ноз3х2тел3х2тењ3х2тев3к2неж3к2нез3к2њиж3к2њиг3м2наж3м2нож3м2ног3п2сич3п2сик3п2сов3п2суј3с2фер3т2мул3т2муљ3т2муо3т2мур4р3је_4р3јем_о2д3ј",
  3
  "_ђ2з2в_ч2_ш2_ж2з2рз2нз2мз2љз2лз2јз2гз2дз2бв2рв2љв2лу3уу3оу3иу3еу3ат2вт2лт2јс2вс2рс2пс2нс2мс2љс2лс2кс2цп2рп2љп2лп2јо3уо3оо3ио3ео3ам2рм2љм2лл2јк2вк2рк2љк2ли3уи3ои3ии3еи3ах2вх2рх2љх2лг2вг2рг2љг2лф2рф2љф2лф2је3уе3ое3ие3ее3ад2вд2рд2љд2лд2јд2жц2вц2рц2јб2рб2љб2лб2ја3уа3оа3иа3еа3аж2вж2нж2мж2љж2лж2гж2дж2бж2ђш2вш2тш2пш2нш2мш2љш2лш2чч2в2у12о12и12е12џ_2а1_з2_с2_б2_р2_ћ2_н2_м2_љ2_к2_х2_г2_ф2_џ2_д2_ц2",
  12
  "_инте3р4огат_из3ва2н3евр_и3з4бичкава_бе2з3атомск_проти2в3отр_бе3с4покојн_проти2в3акц_у2з3обијест_из3бе2з3обр_бе3с4покоја_бе3с4крупул_пре2д3увјер_и3з4блеушан_пре2д3убјеђ_по2д3ра2з3д_пре2д3увјет",
  11
  "_ра3с4клопа_пре2д3усло_пре2д3угов_пре2д3удар_и3з4виискр_по2д3лијет_пре2д3убеђ_пре2д3увер_по2д3лијеп_ва2н3устав_пре3д4вест_пре3д4воја_пре3д4воје_пре3д4воји_по2д3лијег_по2д3лијеж_проти2в3оф_по2д3лијећ_проти2в3уд_проти2в3ус_тран3с4кри_бе3с4трана_пре2д3осје_бе3з4бједа_пре2д3окус_пре2д3одре_бе3з4бједн_бе3з4истен_бе3з4начај_пре2д3истр_пре2д3исто_пре2д3испи_бес4тселер_по2ст3опер_ди2с3парит_инте3р4ежџ_по2ст3инду_по2д3лакат_пре2д3упис_ра3с4клопи_ра3с4клопљ_ра3с4полож_супе3р4иор_ра3з4башур_и3с4кариот_по2д3вариј_из3бе2з3ум_инте3р4егн_инте3р4еса_инте3р4ије_инте3р4есу_инте3р4есо_а2н3а4е2ро_инте3р4есн_обе3с4тран_инте3р4еси_инте3р4есе_бе3з4истан",
  9
  "_из4оглос_а2б3алиј_а2б3анац_по2д3рас_по2д3рањ_по2д3ран_по2д3рам_по2д3рад_а2б3ерац_по2д3окн_по2д3реп_по2д3рес_по2д3рез_по2д3луп_по2д3луж_по2д3луч_по2д3лом_по2д3лок_по2д3љут_по2д3лиз_а2б3ерир_а2б3евак_а2б3ирит_ва2н3евр_уза3т2ка_а2б3ориг_по2д3лет_по2д3леп_по2д3лег_по2д3леж_по2д3лећ_а2б3реак_у4с5котр_по2д3изв_по2д3игр_по2д3адм_по2д3рик_по2д3рит_а2б3узус_обе3з4уб_а2д3ерац_у4с5коси_у4с5кора_у4с5копа_а2д3верб_а2н3афиј_по2д3рож_по2д3рон_по2д3ров_у4с5колу_а2н3акуз_у4с5коле_по2д3руб_по2д3рук_а2н3алфа_по2д3усм_по2д3усн_у4с5коко_по2д3веч_по2д3веж_по2д3вез_по2д3вик_по2д3вил_по2д3вир_о3т2каст_о3т2касм_а2н3андр_у3з4вију_по2д3вођ_по2д3вож_о3д4викн_а2н3апто_по2д3вод_о3д4вест_о3д4весн_о3д4веса_по2д3воз_по2д3врћ_о3д4рвењ_о3д4рвен_о3д4рвеч_по2д3врж_у3з4вијо_а2н3егер_по2д3врг_у3з4вије_по2д3врс_по2д3вућ_а2н3екумни3г2дје__у3з4вијане3г2дје__у3з4року_по3д2нев_по3д4јеч_по3д4јен_по3т2ках_о3д4рапљ_о3д4рапи_о3д4рапа_о3д4рану_о3д4рано_о3д4рани_о3д4ране_о3д4рана_по3т2кам_о3д4рачи_по3т2кат_по3т2кав_пре2д3же_пре2д3жи_о3д4лака_пре2д3ид_а2н3елек_а2н3енер_у3з4роко_у3з4рока_а2н3ерит_а2н3есте_а2н3ирид_а2н3изог_а2н3изом_о3б4ровц_о3б4рова_а2н3изур_у3з4неве_а2н3опис_а2н3овар_у3с4пори_а2надипл_у3с4пора_а2нафила_у3с4пјев_у3с4пјет_о3б4ретн_о3б4рети_у3с4пјем_у3с4пјел_у3с4пјех_у3с4пјеш_у3с4пије_у3с4пија_у3с4пент_о3б4разу_о3б4разо_о3б4разн_о3б4рази_о3б4разд_о3б4раза_у3с4пало_у3с4клад_у3с4клађ_о3б4рамб_о3б4раже_о3б4рашн_о3б4рашч_у2з3угар_а2накрон_у2з3орав_у2з3орат_у2з3искр_о3б4јеси_у2з3инат_у2с3тврд_у2с3тврђ_пред3м2н_пред3м2њ_про3т2ка_про3т2ки_у2с3трес_у2с3треп_у2с3треб_у2с3трал_у2с3трај_у2с3тара_а2наспаз_ра2з3оба_о2д3исти_ра2з3обл_ра2з3обр_а2настиг_а2настом_бе3с4тид_бе3с4тиљ_ра2з3орт_ра2з3ору_ра2з3уда_ра2з3удб_о2б3убож_ра2з3уди_бе3з4бол_ра2з3умр_ра2з3уве_о2б3лока_о2б3лизи_бе3з4јач_бе3з4јак_ра2з3узд_о2б3лист_тран2с3в_тран2с3у_ди2с3кре_ди2с3кри_ра2з3узе_ра2з3узи_ра3ш4ћењ_ди2с3кур_ра3ш4чић_ра3с4как_о2б3ласк_тран2с3т_о2б3лакш_ра3с4кин_ди2с3пон_ди2с3поз3г2нијезд3г2нијежђ_ну2з3рје_ди2с3тон_ну2з3љуб_ну2з3биљ_ну2з3бел_ну2с3про_ну2с3пос_и2н3адек3г2дјекак_на3т2кам_на3т2ках_на3ј4ури3г2дјекад_на3ј4езн_на3ј4езд_на3ј4етк_тран2с3п_на3ј4едр_на3ј4едн_на3ј4еди_на3ј4еда_тран2с3о_на3ј4ежу_на3ј4ежи_на3ј4еже_на3ј4ази_на3ј4ављ_на3ј4ави_на3ј4аве_на3ј4ава_на3ј4аук_на3ј4ати_на3ј4арм_на3ј4ари_на3ј4арц_на3ј4амн_на3ј4амл_на3ј4ами_на3ј4ало_на3ј4ако_на3ј4ака3г2дегод__на3ј4ади_на3ј4аде_на3ј4ада_на3ј4ажи_и2н3афек_на3д4вор_и2н3акце_на3д4вла_на3д4вит_на3д4виј_и2н3акур_и2н3амор_на3д4вал_на3д4леж_на3д4леш_на3д4лан_на3д2ниц_на3д2нич_на3д2нев_и2н3аниц_и2н3апст_ра3с4кош_на2д3рук_на2д3руг_на2д3руч_на2д3реп_тран2с3н_и2н3аура_на2д3ран_и2н3ефек_на2д3рач_на2д3осо_тран2с3м_на2д3осе_на2д3ора_на2д3офи_тран2с3л_на2д3јун_на2д3јез_на2д3јек_на2д3јеч_на2д3јах_на2д3јач_на2д3иск_на2д3ина_на2д3инж_на2д3игр_на2д3жуп_ра3с4пај_на2д3жив_на2д3жир_ра3с4пав_на2д3ждр_на2д3жањ_јури2с3п_јури2с3к_и2н3елиг_тран2с3к_и2н3евид_тран2с3е_тран2с3ц_ра3с4пињ_и2н3јуст_тран2с3а_и2н3офиц_из4остаз_из4оскоп_из4оскел_из4осист_из4осинт_ра3с4пон_ра3с4пор_из4опсеф_и2н3окуп_и2н3опер_ра3с4тај_ра3с4тан_ра3с4тат_ра3с4тав_из4оморф_из4ометр_ра3с4тењ_из4олукс_из4олекс_и2н3опор_из4оклин_ра3с4тил_ра3с4тињ_ра3с4тир_из4охипс_ра3с4тис_ра3с4тит_ра3с4тој_и2н3опсе_и2н3умбр_из4ограф_и2н3унда_и2н3утил_ра3с4трт_ра3с4тућ_ра3с4туп_ра3с4тур_супе2р3у_ра3з4бад_ра3з4бан_из4оброн_ра3з4бар_из4оаном_из4оанем_супе2р3о_супе2р3и_супе2р3е_и2з3анал_и2з3бија_и2з3бива_супе2р3а_и2з3ведб_и2з3веде_и2з3веди_и2з3ведн_су2б3рог_су2б3реп_инте2р3у_инте2р3о_су2б3орд_инте2р3и_инте2р3е_инте2р3а_ра3з4бау_и3з4војц_ра3з4бој_и3с4кита_и3з4вјед_су2б3окс_ра3з4бор_ра3з4гађ_ра3з4грт_и3с4крам_и3з4вија_и3с4крат_и3з4вижд_и3з4валу_и3з4ваљи_и3з4вали_и3з4вале_и3з4вала_ра3з4лаг_и3з4раиљ_и3з4раел_и3з4рачи_и3з4олов_и3з4олир_и3з4олат_и3з4олац_ра3з4лаз_ра3з4лич_ра3з4лик_и3с4крен_ра3з4лож_ра3з4лог_и3з4јежљ_ра3з4лоз_ра3з4мећ_ра3з4мет_и3з4гред_и3с4крењ_и3з4драв_и3з4бојк_и3с4крич_и3с4криш_и3с4криц_и3с4крит_ра3з4нат_и3с4труг_и3с4триц_и3с4триж_и3с4трић_и3с4трав_и3с4тран_и3с4трад_и3с4тори_ра3з4ред_и3с4точњ_и3с4точн_и3с4точа_ра3з4роч_ра3з4рок_и3с4крој_ра3з4вал_и3с4тављ_и3с4тави_и3с4крса_и3с4крсн_ра3з4вић_и3с4такн_и3с4квас_и3с4кврч_су2б3инв_и3с4пупч_раза3г2н_раз3д2ни_ра3з4врт_ра3з4врћ_ра3з4вон_и3с4мије_ра3з4вој_ра3з4вит_и3с4пира_и3с4плит_и3с4плић",
  5
  "2з3гј2з3дв2з3дљ2с3вљ2с3тл2с3кљ2с3кј2з3дл2з3бљ2ш3тљ2ш3тл2к3вљ2ц3вљ2ц3вл2к3вл2к3вј2ш3тј2ш3пљ2ш3пл2ш3пј2г3вр2г3вљ2г3вл2г3вј_ге4о2ш3мљ_бе4о3р2ђа_би4о2ш3мл2т3вљ2т3вл2т3вј2ш3мј2ш3цв2ш3цј2ш3чв2ч3вљ2ч3вл2ч3вј2ж3вљ2ж3вл2ж3мр2ж3мљ2ж3мл2ж3мј2ж3гв2ж3гр2ж3гљ2ж3гл2ж3гј2ж3дв2ж3дљ2ж3дл2ж3дј2ж3бр2ж3бљ2ж3бл2ж3бј2ш3вљ2ш3вл2х3вр2д3вр2д3вљ2д3вл2х3вљ2х3вл2х3вј2з3вљ2з3вл2з3мр2з3мл2з3гљ",
  10
  "_и3с4покој_по2д3разу_и3с4паљив_ра3з4вију_и3с4порав_и3с4права_и3с4прави_ра3з4враћ_ра3з4врат_и3с4правк_ра4с5турч_и3с4прављ_и3с4лијед_и3с4лијеђ_и3с4правн_раза3т2ка_ра3з4вије_су2б3јунк_ра3з4вија_ра3з4виго_и3с4купља_ра3з4вест_ра3з4веде_и3с4тифан_ра3з4мрск_по2д3равњ_по2д3равн_и3з4бојак_и3з4гомет_и3з4лопаћ_по2д3лист_и3з4вијен_и3с4конск_и3з4витоп_и3з4војац_инте2р3је_по2д3лакт_обе3з4виј_обе3з4нањ_бе3с4пора_обе3з4нан_обе3з4нач_обе3с4тиј_обе3с4тан_а2н3афрод_по2д3руча_по2д3ручи_по2д3ручн_по2д3упла_а2н3амерт_по2д3влаш_по2д3разр_по2д3влас_ра3с4трој_ра3с4трет_ра3с4трел_из4околон_ра3с4прем_ра3с4прав_о3д4викав_ра3с4плињ_ра3с4плин_ра3с4пику_ра3с4пето_ра3с4пети_ра3с4пете_ра3с4пета_ра3с4кроп_на2д3осје_на2д3рашћ_на2д3раст_и2н3аугур_на2д3реал_на2д3удар_и2н3аплик_по2д3враћ_на3д4веси_на3д4вест_на3д4воје_по2д3врат_по2д3врис_ра3с4клон_на3ј4ести3г2дјегод__на3ј4урен_на3т2касм_на3т2каст_и2н3абруп_по2ст3егз_по2ст3лим_ди2с3трак_ра3с4клап_ди2с3проп_ра3с4клањ_ра3с4клад_о2б3истин_о2б3истињ_по2ст3онк_ди2с3ориј_ра3с4канд_ди2с3квал_о2б3леден_о2б3лијеж_о2б3лијег_ди2с3корд_ди2с3конт_ди2с3јунк_ди2с3акор_пре2д3игр_бе3з4вучн_бе3з4вуча_о2б3лијеп_о2б3лијет_бе3з4рачн_тран3с4еп_бе3з4рача_пре2д3изб_бе3з4лобн_бе3з4лоба_о2б3лизат_о2б3лизав_пре2д3обј_и3с4полин_ра2з3улар_у3з4ријев_пре2д3осе_бе3з4бели_бе3з4бедн_бе3з4беда_бе3с4твар_бе3с4трас_у3з4ријет_бе3с4тилу_ра2з3орав_бе3с4тија_ра2з3орат_у3з4невје_тран3с4уд_о2д3и2з3д_о2д3и2з3в_тран3с4ум_ра2з3анал_у2с3талас_пре2д3осв_бе3с4порн_пре2д3рач_проти2в3р_у3з4лудоб_у3с4ријед_пре2д3рад_пре3т2кат_пре3т2кам_пре3т2ках_пре3д4вос_у2з3обест_у3с4преми_пре3д4вор_у3с4према_у3с4пособ_пре2д3рат_у3с4порењ_пре3д4вар_пре3д4вај_пре3д4јен_у3с4порен_пре2д3руч_у3с4пијуш_у3с4пикуш_у3с4пореч",
  8
  "_и3с4пав_за3т2ка_а2б3лег_а2б3леп_а2б3лок_у4с5ков_а2б3рог_а2д3лат_а2д3рен_а2д3рог_у4с5ком_а2н3аго_а2н3алд_а2н3алг_у4с5кош_у3з4вој_а2н3ант_а2н3арх_а2н3еклни3г2де__у3з4виж_у3з4ват_у3з4ван_у3з4рујне3г2де__а2н3епи_а2н3ерг_у3з4роч_а2н3идр_а2н3јон_у3з4рев_у3з4рет_у3з4ној_у3з4ниц_у3з4нич_а2н3офт_а2н3окс_у3з4нак_у3з4нач_а2н3орг_у3з4лов_у3з4лит_у3з4лим_у3з4лиц_у3з4лић_у3з4лат_у3з4лан_у3з4диц_у3з4бор_а2н3орх_а2набап_а2набат_а2набаз_а2набио_а2набол_а2надем_а2надоз_а2нафаз_у3с4пон_а2нафон_а2нафор_а2наген_а2нагно_а2награ_а2нахор_а2нахро_а2накал_а2накам_а2накат_у3с4пев_у3с4пет_а2накеф_у3с4пем_у3с4пел_у3с4пех_у3с4пеш_а2накла_у3с4куп_а2накли_а2накој_у3с4как_а2накол_а2накру_а2налеп_у2з3охо_а2налис_а2налит_а2нализ_а2намне_у2з3игр_а2нанео_а2напла_у2с3тур_у2с3тум_у2с3тућ_у2с3трп_у2с3трн_у2с3трк_у2с3трг_а2напле_а2напне_а2напно_а2напро_а2напти_у2с3трч_у2с3трћ_у2с3тов_у2с3тер_у2с3тег_у2с3тећ_а2насар_а2насеи_а2наста_а2натим_а2натоц3х2тјети_бе3з4уб_бе3з4уп_ди2с3ло3г2декак3г2декад_и2н3арт_и2н3екс_и2н3екв_и2н3епц_и2н3јек_и2н3јур_и2н3обл_и2н3унк_и2ноген_и2нокор_и2з3аба_и2з3ака_и2з3дај_су3б4аш_и3с4как_и3с4кат_и3с4кин_и3с4коч_и3с4лаб_и3с4лам_и3с4леђ_и3с4лед_раз3г2н_и3с4лик_и3с4лин_и3с4љеђ_и3с4љед_и3с4лов_и3с4луш_и3с4луж_и3с4мје_а3г2ноз_и3с4пон_и3с4пур_и3с4ред_и3с4таћ_и3с4там_и3с4тар_и3с4тас_и3с4тиц_и3с4тин_и3с4тир_и3с4ток_и3с4туп_и3з4бав_и3з4грн_и3з4грт_и3з4ими_и3з4лож_и3з4лог_и3з4лоз_и3з4ним_и3з4ној_и3з4упч_ра3з4из_ра3з4ир_ра3з4ин_ра3з4иј_ра3з4ид_ра3з4ић_ра3з4иђ_и3з4вин_и3з4вињ_ра3з4ев_и3з4вир_а2натом_и3з4вор_из4обат_из4одим_из4один_из4одоз_из4офон_из4офот_из4огам_из4огео_из4огон_из4охал_из4охаз_из4охел_из4охиј_из4охим_из4охит_из4охор_из4охро_из4омер_из4онеф_из4оном_из4опат_из4опер_ра3с4ре_ра3с4рд_ра3с4рђ_из4опле_из4опол_из4орах_из4осеи_из4осте_ра3с4пн_из4отах_из4отал_из4отер_из4отон_из4отоп_из4отро_иза3г2н_иза3т2к_на2д3же_на2д3жњ_на2д3оч_на2д3уч_на2д3ум_на3ј4аш_на3ј4ах_на3ј4ец_ну2з3ре_ну2з3уж_о2б3игр_о2б3лај_о2б3лам_о2б3лећ_о2б3леж_о2б3лег_о2б3леп_о2б3лет_о2б3лив_а2натре_о2б3луч_о2б3лук_о2б3ору_о2б3уме_о2б3уми_ра2з3от_о2б3умр_о2д3жал_о2д3жаљ_о2д3арг_ра2з3од_о2д3игр_о2д3иск_а3г2нос_о2д3онд_о2д3онл_о2д3оно_о2д3ону_о2д3озд_о2д3озг_о2д3уве_о2д3уви_о2д3узд_о2д3узе_про3г2н_о2д3узи_о2д3узл_о3б4јеш_о3б4јек_о3б4јер_о3б4јет_о3б4љан_о3б4љут_о3б4љуз_о3б4раћ_о3б4ран_о3б4рањ_о3б4рат_о3б4ређ_пре2д3в_о3б4реч_о3б4реж_о3б4рец_о3б4ред_о3б4рем_о3б4рес_о3б4рич_о3б4риц_о3б4риј_о3б4рис_о3б4рит_о3б4рив_о3б4роћ_о3б4роч_о3б4рок_о3б4рон_о3б4руч_о3б4руш_о3б4рук_о3б4рун_пре2д3ј_о3б4рус_о3д4јећ_о3д4јен_о3д4јев_о3д4лаж_о3д4лаг_о3д4лаз_о3д4луч_о3д4лук_о3д4раћ_о3д4раж_о3д4раз_о3д4ређ_о3д4ред_о3д4рем_о3д4рен_о3д4рич_о3д4риш_о3д4риб_о3д4риц_о3д4рин_о3д4рињ_о3д4рон_о3д4роњ_о3д4руж_о3д4руг_а2натри_о3д4важ_о3д4вај_о3д4вић_о3д4вис_о3д4вој_о3т2ках_о3т2кам_обе2ш3ћ_обе2ш3ч_обе2с3ц_обе2с3к_обе2с3п_обе2с3т_обе2з3б_обе2з3д_обе2з3г_обе2з3ј_обе2з3л_обе2з3љ_а2натро_обе2з3м_обе2з3н_обе2з3о_обе2з3р_обе2з3у_обе2з3в_ода3д2н_ода3г2н_по2д3оч_по2д3ош_по2д3оф_у3с4пав"},
 :patternChars "_абвгдежзиклмнопрстуфхцчшђјљњћџ"}
)

(def rules
  (-> rules'
      (assoc :trie (pat/build-trie rules'))
      (dissoc :patterns)))
