(ns clj-hyphenate.patterns.or
  "This pattern is imported from Hyphenator.js. Original comment follows:

   For questions about the Oriya hyphenation patterns
   ask Santhosh Thottingal (santhosh dot thottingal at gmail dot com) "
  (:require [clj-hyphenate.patterns :as pat]))

(def rules'
{:leftmin 2,
 :rightmin 2,
 :specialChars
 "ଆଅଇଈଉଊଋଏଐଔକଗଖଘଙଚଛଜଝଞଟଠଡଢଣତଥଦଧନପଫବଭମଯରଲଵଶଷସହଳିୀାୁୂୃୋୋୈୌୗ୍ଃଂ‍",
 :patterns
 {2
  "ଅ1ଆ1ଇ1ଈ1ଉ1ଊ1ଋ1ଏ1ଐ1ଔ1ି1ା1ୀ1ୁ1ୂ1ୃ1େ1ୋ1ୌ1ୗ1୍2ଃ1ଂ11କ1ଖ1ଘ1ଙ1ଚ1ଛ1ଜ1ଝ1ଞ1ଟ1ଠ1ଡ1ଢ1ଣ1ତ1ଥ1ଦ1ଧ1ନ1ପ1ଫ1ବ1ଭ1ମ1ଯ1ର1ଲ1ଵ1ଶ1ଷ1ସ1ହ1ଳ",
  3 "1ଗ1",
  4 "2ନ୍‍2ର୍‍2ଲ୍‍2ଳ୍‍2ଣ୍‍"},
 :patternChars
 "ଂଃଅଆଇଈଉଊଋଏଐଔକଖଗଘଙଚଛଜଝଞଟଠଡଢଣତଥଦଧନପଫବଭମଯରଲଳଵଶଷସହାିୀୁୂୃେୋୌ୍ୗ‍"}
)

(def rules
  (-> rules'
      (assoc :trie (pat/build-trie rules'))
      (dissoc :patterns)))
