(ns clj-hyphenate.patterns.nb-no
  "This pattern is imported from Hyphenator.js. Original comment follows:

   The norwegian hyphenation patterns were retrieved from 
   http://www.ctan.org/language/hyph-utf8/tex/generic/hyph-utf8/patterns/tex/hyph-no.tex
   and adapted to hyphenator.js format by Erik Erik Seierstad (erik dot seierstad at gmail dot com).
   % This file is part of hyph-utf8 package and resulted from
   % semi-manual conversions of hyphenation patterns into UTF-8 in June 2008.
   %
   % Source: nohyphbx.tex (2007-02-07)
   % Author:
   %
   % The above mentioned file should become obsolete,
   % and the author of the original file should preferaby modify this file instead.
   %
   % Modificatios were needed in order to support native UTF-8 engines,
   % but functionality (hopefully) didn't change in any way, at least not intentionally.
   % This file is no longer stand-alone; at least for 8-bit engines
   % you probably want to use loadhyph-foo.tex (which will load this file) instead.
   %
   % Modifications were done by Jonathan Kew, Mojca Miklavec & Arthur Reutenauer
   % with help & support from:
   % - Karl Berry, who gave us free hands and all resources
   % - Taco Hoekwater, with useful macros
   % - Hans Hagen, who did the unicodifisation of patterns already long before
   %               and helped with testing, suggestions and bug reports
   % - Norbert Preining, who tested & integrated patterns into TeX Live
   %
   % However, the "copyright/copyleft" owner of patterns remains the original author.
   %
   % The copyright statement of this file is thus:
   %
   %    Do with this file whatever needs to be done in future for the sake of
   %    "a better world" as long as you respect the copyright of original file.
   %    If you're the original author of patterns or taking over a new revolution,
   %    plese remove all of the TUG comments & credits that we added here -
   %    you are the Queen / the King, we are only the servants.
   %
   % If you want to change this file, rather than uploading directly to CTAN,
   % we would be grateful if you could send it to us (http://tug.org/tex-hyphen)
   % or ask for credentials for SVN repository and commit it yourself;
   % we will then upload the whole "package" to CTAN.
   %
   % Before a new "pattern-revolution" starts,
   % please try to follow some guidelines if possible:
   %
   % - \lccode is *forbidden*, and I really mean it
   % - all the patterns should be in UTF-8
   % - the only "allowed" TeX commands in this file are: \patterns, \hyphenation,
   %   and if you really cannot do without, also \input and \message
   % - in particular, please no \catcode or \lccode changes,
   %   they belong to loadhyph-foo.tex,
   %   and no \lefthyphenmin and \righthyphenmin,
   %   they have no influence here and belong elsewhere
   % - \begingroup and/or \endinput is not needed
   % - feel free to do whatever you want inside comments
   %
   % We know that TeX is extremely powerful, but give a stupid parser
   % at least a chance to read your patterns.
   %
   % For more unformation see
   %
   %    http://tug.org/tex-hyphen
   %
   %------------------------------------------------------------------------------
   %
   % TeX hyphenation patterns for Norwegian
   % 
   % version of 2007-02-07.
   % Patterns of January 25, 2005, with later additions and changes
   %
   % Copyright (C) 2004, 2005 Rune Kleveland, Ole Michael Selberg.
   % Copying and distribution of this file, with or without modification,
   % are permitted in any medium without royalty provided the copyright
   % notice and this notice are preserved.
   % 
   % Please send bugs or suggestions to tex-live (at) tug.org.
   % 
   % Originally generated by a script written by Rune Kleveland
   % from dictionaries available from 
   % http://folk.uio.no/runekl/dictionary.html.
   %
   % Adjusted manually by Ole Michael Selberg to prevent
   % numerous wrong hyphenations, especially in compounds.
   %
   % Changes from the former version of 2005-06-29:
   % 388 new patterns. Some old patterns have been deleted or changed.
   %
   % In Kleveland's nohyphb.tex there are 26017 patterns.
   % This version of the revised nohyphbx.tex contains 27149 patterns 
   % --- plus 45 exceptions in the \hyphenation-list
   % (which you may change to suit your personal needs).
   %
   % To load these hyphenation patterns the parameters 
   % of TeX must have the following minimum values:
   %   trie_size = 33385 
   %   trie_op_size = 815
   % (The corresponding values for nohyphb.tex are
   %   trie_size = 31900    trie_op_size = 636)
   % If you want to load more than one set of hyphenation 
   % patterns the parameters have to be set to a value 
   % larger than or equal to the sum of all required values
   % for each set.
   %
   % Notes on other Norwegian hyphenation pattern files, from Dag Langmyhr,
   % tex-live mail of 29 Jun 2005 11:26:21 +0200.
   % nohyph.tex -- manually created by Ivar Aavatsmark and others;
   %   hyphenate according to pre-1973 rules; no longer recommended for use.
   %   (Sometimes also known as nohyph1.tex.)
   % nohyph2.tex -- created by Dag and a student; the present file,
   %   nohyphbx.tex, is more extensive and is recommended. "
  (:require [clj-hyphenate.patterns :as pat]))

(def rules'
{:leftmin 2,
 :rightmin 2,
 :specialChars "æøå",
 :patterns
 {7
  "_ab6s5t_ac6tin_adel4s_ad8la__ad6le__af5f6u_ag6na__ag6ne__ak6ka__ak6ke__ak6ne__ak8sa__ak4se__ak4te__akte4r_al4ge__al6ka__al4ke__al4kom_al4la__al4le__al5leg_all5s6_al4ma__al8me__al6s7k_al4ta__al5tar_al4te__al6ve__am6ma__am4me__an4da__an4de__an4d5ø_an4ga__an4ge__ange4s_an4ja__an4ka__an4ke__an4la__an4na__an7nal_an4ne__an4sa__an4se__an4ta__an4te__an5tem_an5tep_an4ti__an6tin_an4tis_an4tiv_ap8lan_ar6de__are4o7_ar4ge__ar5ges_ar8ka__arlan9_ar4me__ar7mea_ar4na__ar4ne__ar5nes_ar6ra__ar6r7u_ar6ta__ar4te__ar6va__ar4ve__ar4ved_ar4ver_as4ke__as4le__as6pa__ast5ru_at4le__at4na__au4ka__au8le__au6sa__au6se__av7i6d_av4la__av4le__ba6la__ba4le__ba4ne__ba4re__ba4ri__ba8te__be4de__bede4n_be8di__be3e4d_be6ke__be4la__be9nar_be4ne__be6ra__be6re__be4res_be8ri__be7ska_be4ta__be6te__be5t4v_bi6de__bi4le__bilet5_bi6t3r_ble4k3_bling5_bo8de__bo4na__bor6t5_bort6e_bort9r_bu6da__bu3d6r_bus6sy_by6de__by8ta__bø6k5a_bø8nen_bø8ner_ca4en__car4s5_da4ge__da4le__dags6e_da4ne__deka9r_deko7d_de4le__del5s6_de4mi__demo7e_den5sl_de4re__de4ri__de6s5m_de4sto_devi5s_di5e4l_di4et__di9f6t_di4ne__di8s3t_do6re__drau4m_du4en__du4ge__du4se__dy4re__dø6la__dø7r4a_dø7r4e_dø4ve__då5ren_då7ret_ed4le__efta5s_ef6ter_eg8de__eg6ga__eg4ge__eg4gel_eg8la__eg4le__eg6na__eg4ne__ego7t8_eg8se__ei5den_ei4ga__ei7ger_ei4ke__ei8ma__ei8me__ein7as_ei9rar_ei5res_ek4le__ek6ne__ek8sa__ek8se__eks6pi_eks3t4_ek4te__el8da__el4de__el4g5r_eli5ne_els4kl_el6ta__el6te__el6veg_em4ma__em8me__em6na__en4da__en4de__en4ga__en6gav_en4ge__en6g5r_en4ke__en5og5_en4se__en6te__ent8re_er4g5r_er4la__er4le__er6ma__er4me__er4mek_er4na__er6ta__er4te__es9ast_es8ka__es4ke__es8la__es8le__es6pa__es8sa__es4se__es6te__es7tet_et8la__et8le__et4ne__et8sa__et5s4e_et6se__et1te4_et6ter_ev4je__ev4ne__fag3s4_fa4ne__feil5i_fel4ta_fer8ro_fe8st5_fi4le__fo4bi__form5s_fu6ge__fu8se__fø8rel_ga4le__ga8li__ga4ne__gas5ta_ga4ve__ga9vee_ge6ni5_gift5s_gi8v3a_glø9se_gnå7la_go5des_grei4e_grus5s_gu4de__gud3v4_gu4lat_gu4tu__gås4e5_hai5s6_ha6ka__ha8ma__he4er__hen3i2_hes4s5_het6s5_he5t6e_hi6re__ho4re__ho5ren_ho7ret_ho8ta__ho8va__hy6ra__hy4re__hø4ve__hå8en__ifø5re_ig8la__ig4le__ik8te__il6d3r_il6de__il6je__il6ke__il4le__il4te__in8ga__in4ge__in6gri_in6ka__in4ne__in5n6e_in4n3i_in7tes_io4nom_ir8ra__ir6re__is6lam_is4le__is4let_is4me__is8na__is8ne__is6sa__is4se__is8te__i5sted_i5stem_i6s7tj_i6s7tr_is8ut__i4var__i4ver__i4vere_iv8ra__iv6re__ja4de__ja8se__ja4va__jo8en__jo4se__ju4li3_jø4dep_ka6la__ka6li__ka4ne__ka4p3r_ka4ra__ka6re__ka5rin_ka4te__ka5t6h_ka6va__ka4ve__ki4se__ki8va__ki6ve__kjek7l_kjønn4_kli5ne_klo9va_kly7sa_kna7se_ko6da__ko8le__ko6pe__ko4se__ko6ta__ko4te__ko6ve__ku5f4l_ku8ra__ku4re__ku8ta__ku8te__kve9ka_kve5ke_ky8la__ky4le__ky6te__la4da__la4de__la4ge__la5ger_la4ma__la6ta__la4te__la4ve__le4da__le4de__le4ge__le4gel_le8gi__lei4ve_le4ke__le4k5r_le4ne__le7s6a_le4se__le4sek_le4ses_le4s5p_le4va__le4ve__le4ves_li4de__li5ene_lik5k6_li4re__li4se__li4ta__li4te__li4ve__lo6ge__lo8gi__lo6g5r_lo8sa__lo4se__lo4ve__lu4pe__lu6ra__lu4re__lu6se__lu4ta__lu9tas_ly4de__ly4se__ly5s6e_lys5s6_ly8str_ly4te__ly4ve__lø8de__lø6en__lø8ne__lø6pa__lø4pe__lå6re__lå4te__ma4ge__ma4ke__makt5s_ma4le__ma4li__ma4na__ma4ne__ma4ni__ma4ra__ma4re__ma4ri__ma4sa__ma6t8h_me6d4i_me6d5r_mei5et_me6la__me4l5ø_me4ne__mes5ti_me4tri_mi4le__mi4me__mi4ni__mi4nik_min4k3_mo4na__mo8ne__mon4st_mo4re__mo4se__mo4tek_mo4ter_mu8ge__mu6le__mul5es_mu5r8e_my4ke__mø4re__mø5res_må6la__na6ge__na8ke__na4sa__nat6tr_ne4de__ne4den_ne4d5i_ne4d3r_ned3s4_ne8pa__ne6pe__ni4na__ni4pa__ni6pe__ni6se__no6de__no4me__no8mi__no8si__no4va__ny8sa__ny6se__ny4te__næ4re__nø4re__nå4de__nå6le__od4da__od4de__od8la__od8le__offsi6_of4te__of5teb_ok8ka__ok4se__ol4ga__ol8le__om4ar__om6bo__om4e6n_om4gå__on4de__on5des_on8ne__opp7el_opp5s6_or4de__or4del_ord5s4_or6ka__or4ke__or6me__or4re__os4te__ot7t8a_ot4ta__ot4te__ot4tes_ot4to__pa8la__pa4le__pa5n6e_pa5n6i_pa6re__pe4ke__pel4sj_pe4ne__pe8sa__pese5t_pi6le__plø7se_po8la__po4le__po4log_po2p2e_po3p2u_po6re__po4res_po8ta__po6tek_pøn9s6_ra6da__ra4ga__ra4ge__ra4ja__ra4ne__ra6pa__ra6pe__ra4re__ra6sa__ra6va__ra4ve__re6da__re4de__rege4l_re4gi__rei7de_re4ins_re6ka__re4ke__re8kle_re4kli_re8le__re4ma__re4na__re4ne__ren6sk_re4ve__re4ves_rie5ne_ri6ka__ri4me__ri4pa__ri4pe__ri4p5o_ri4sa__ri4se__ris5ko_ri4s3ø_ri4ta__ri6te__ri6va__ri4ve__ro4de__ro8ke__ro4ma__ro9par_ro4pe__ro9sar_ro4se__ro4sed_ro4ta__ro4te__ro8ve__ru8ga__ru4ge__rug9le_ru4na__ru4ne__runes6_ru4se__ru8va__ru4ve__rye7ne_ry6ke__rød7s4_rø8le__rø4re__rø8va__rø4ve__rå8da__rå4de__rå8er__rå6ka__rå4ke__rå3k4l_rå6na__rå8sa__sa4ge__sa4la__sa4le__sa4me__sa4mer_san6d7_se4k5l_sel4v5_se6na__se4ne__se4ra__se4te__si6ga__si4ge__si8la__si4le__si4ne__si4ra__si5str_si4ve__ska7ka_ska5ke_skei5d_skog5u_sku6m5_skå5ra_slu9ka_slø5se_smas5k_små7k6_små5t4_småt5t_somma4_sop4pa_sor4t5_so4ta__spa5ra_spi9la_sta9ka_sta5li_stat4s_sted4s_stem4m_sti7me_sto5ne_sto6ra_stu9va_sva5la_sva5re_svar5s_sver8n_sy5d6e_sy6na__sy4ne__sy5ter_sø4ke__søl6v5_søy6en_så5pen_ta8ke__tak5sk_ta4la__ta4le__ta4les_tal4li_tan5de_ta4p5r_ta4ra__ta4re__tei9er_te8ke__te4ma__te8ne__te4se__te4sta_te4str_tid6s3_ti4de__ti4g3r_ti4med_ti4na__ti4ne__ti4p5l_to5arm_to6en__to4er__to6et__to6le__to6na__to4ra__to4re__to6reb_to5rye_to4str_to8te__to4ve__tre3sp_tu4en__tu4ne__tu6ra__tu4re__tu8ve__ty6da__ty4de__ty8re__tyr8s9_ty5ter_tæ4re__tø6ve__tø9ver_tø5vet_tå5ker_tå4le__tå5ren_tå7ret_u6berg_ug6la__ulen4d_u8lene_ul4ke__ul4la__ul8le__ul8ma__ul4me__ul4ne__ul4v5i_un4ge__un4se__u6rane_u4ret__u6rets_ur4ne__ur4te__ur6tet_u7stek_u5stel_ut5age_u4ten__ut5esk_ut4ne__ut3o6v_ut6rer_ut6rov_ut6se__ut4si__va4da__va4de__va4ke__va6les_valg5s_va4ne__van4n5_vari4e_var5sk_ve8en__ve4ga__ve6ge__ve4g3i_veg3s4_vei3g4_vei4ta_ve4l3e_ve4ne__ve4net_ve4ra__ve4ras_ve6re__vermo9_vers4t_ve8te__ve4ve__vi4da__vi6de__vi4ka__vi6ma__vi8me__ving7s_vi4sa__vi4se__vi4ta__vi4te__vok4s3_vo6ta__vye5ne_væ4re__yn8da__yn4de__yn6ge__yn8ka__yn6ke__yp8pa__yp4pe__yr8ja__yr8je__yr4ke__yrkes5_yt9ren_yt6te__ære4st_æt4te__øg4le__øk4te__øm4me__øres8t_ør8na__ør4ne__ør6ski_ørt9an_ør8te__øve4r5_øv4re__øy6de__øy5ene_øy8rer_øy4str_ål8ut__ån8da__ån4de__ånd6s5_åt4te_abe4leiabel5t4abe9na_abes9kaab9lara5aborteade5i6sa4d5elvaderle7adi4eneadva5reaes8ke_a6f5innafo7ra_afo7r8eaga6ve_a7gelen3a4gentage4r3aage6rekag6lesaag4sambags4angag3s4eiags4kulags3t2vagå8ve_ai4n5o4aka4t5rake5l4iake4rekakk6andak4k5isak6k5riakra8saakregi4ak7s6idak5stolakt5allak6tansak5temealag8raal3a4mealan5gra5laren3a4larmal3a4sialeie6na9l8eikal5e4mua4l3enhale4posa4lereda4le5roa4le3teali5na_a4l3inda4l3insalj5endalj5ø6val9keraalla4gaall5artal5len_alle3s4al4lest5alli5ealli9neal4lo3mall4senall4stial6løs_al4løseal8løstalo6rital9skapals6teral7temaal4t3opa4l5u4kalul8laalu8re_alv5aksal5v6eral9ves_alvi8se3a4matøamen4s3ame4rama4meret3a4meri4amerinamis4kuam4leseam6lestam4pareamp7innam4p4ream7s6kuam4s3tram4s5veamti5daanda5taand4sela4n5elvan4g9raan4gre_an6gresan4gretan4g3ryangst5yang5svaang6søyan4kanaan6k5å6anland6anlø9paann5ansan6nemean4ninnann4seiann4sidann5staann4s3uano6debanri7keans5aftansa7kaan4sentans5indans5insans4k3lans6kunan4s3pi6anstarans4te46ans6tianta8laan4tansant5emi5antennan4teslanti7klant5ordant5rabant7romant5rygantus4taon8de_api7r6ea5p6las3ap3par4appar_6appareapp7eskap5plasa3p8ølsa4ranora4r5assara5te_arbo8daar6deliard5staareba4ra6r5ektar7eleka4r6elia5remo_a6r5enga6rerelares8kaa7reta_ar7e6vaarg5stjaria7nearins9karise4aa4ristoar4ke5sark6steark4strark7vegarla4gaar4mediar6metrar4minfarmå6laaro8de_a4r1o4rarp5retar7reskarri8e7arrå6daarsa6kaars5ansars5kamar5skarars5kesars7krears4veiarta4laar7tele8artetsart4ha_art4hasar4tika6ar4timar6trinart6s5tar6vetearvi8saarø8ve_arå8de_a6seneta6sjettas5ketias6kuleask9u8ta5s4lagasla8gaass5aldass5altas4servas6sifras5singas7sos_as4stanass5trua4statuast5renast5ø4va5taeneata8ka_ata8la_ata9rara6t7arvate5k8ea5tene_a6terata8tereka4terila4t3ettatik6kaati5neaati4repati8sta5atlantats6kul4at5te_at5tensatt5iseatt7o6pat4trafat4t3reat6trinatt3s6katt5s8lat2t3ø2at5å4seau6e5taau5keli1auk7s6aum5s6kaum7s4tausti6saus6tonau6striau2s5ø4au3t4rea4v3anda4v5anla2ve3d2a5vede_a5velegave7rasa6vereia4v5intavi5sa_3a6viseavlø5seavsko7gavta9kaa6v7å6lay7ane_ba5den_ba7densba5kan7bakars9ba9ket_bak9ettbak5strbal4lagbal4lanbal4ledbal4legbal4leibal4levbal4ligbal6lovball5s6ban6kapban4korban2k3ubaret5tbar5skrba4serubas6sakbas4sanbassis5bass6trb4b5arbbbel6t3bbelte4b9bene_b4b5erfb7beskab6betenb4b5innbedi9e8bed5redbedy9rabefa5rebehers7bek6kelbekke5rbek4kesbe4l3abbela9gabel5eiebel5eigbel5einbeli9nabel5letbel5s4pbel7s4tbel4tagbel4t3øbelæ5rebelå7nebe4nestben5s4iben5skj8berestbere5teber5gesber4g3åberi5keberu9sabes6k5nbes6selbes6tesbeto5nebe6trarbe6tre_be4t3ribeva5rebilet5rbil5legbi4nansbin4golbi7ris_bir4kenbi5s4labis4p5ibi5s6tabis4tilbis5trublan9dablan5keb8lararblei5erble4k3able5kesble7r6ablæ5re_blå5se_bob5by_bob9byebo4k3etbo6k5ribol5eiebol5s4pbom4belbon5atobo4retebor6teibor4tesbort5s6bred5spbret7tebre4vinbruk4s3bru7na_bru5nesbru7renbrå5te_bud5d6hbund4s3bun8ge_bus4h5ebus6sekbus4selbus6setbæ6rar_bæ5rer_bæ5rerebæ5res_bæ5ret_bæ4r5isbøn6nesbør4s5kbøy4enebå4s3tebå6s7tica6priscar4te_cel4lescel4levce5nes_ck5e4t3clai4r5co4la5rco6n5os6d5adeldak4se_4daktig7d6al5jdame5t6dan5nebdan4seldard3s4dar5os_dar4ta_dar6va_dar8ve_4dasjef4da4taldaud7s8dba8le_dba4ne_dbe8ta_dbe6te_dbling7dbo6en_d4d5armdde4lapdde4l5oddel5svdd4saladd4skapdds5tabdd3s4te5debon_6d6e5ge5dehavsdei4enedei8ge_5deigendei4g5rdek4kandek4kelde6k6kv2de5k6rdeks7tideks6tr6delagede6lansdel5eie4de4lekde5lele4d5elemde4lest6delinjdel5intdel4lapdel6leidel4lekdel6ligdelses7del4spodem8na_demo5noden4sin4dentif4dentitdent5s8de6rantde4rarede4rarkdera5te6deresider5est4derettde4rinæde5rose6de7rotder5s6ndes5ers4des4le5deste_des6tem4destråde4s3tå6detekk4di5enddig8la_dig6le_4digrendig5retdil4les4d5ingkdin8g9ådis6kamdis6k7ldi4sk6odis5ko_dis7koedis7tikdit4tetdjer5vedju8la_6djupardka8ra_dku4le_dla6te_d7legardlem4std4lenetdly8se_dlø8pa_dme6la_dmø4re_dmå6la_dno8de_dog6med4dokinedok6kan4dolinjdom6s5idom4s3kdors7ke6do7s6ldra5gendra6kes5d6rangd6rarardra6retd9ra8sadrau7ma5dreassd5rede_d5rederdre7d6r9drege_drei5end7religdretts55drevetdri8ka_drik7s6drit7trdro6pa_dro8ta_drø6re_drå4de_dsa8la_d4s3alfd4s3engds5e4stdse4te_d4s3jend4s3kands5kjendsmå6lad7somstd4s3tald3s8tard5s4tatd8s9te_ds9teikd3s4tigd3s4tikdstu8nad5stundd6s7uskd3s4vetdta6la_dta4le_dte4ma_dterle7dte4se_d5t4ragdun7stadva6la_dva6leldva4ne_dve8ve_dynk6s5dy5rebadøv8le_eak6se_eal8le_e6a5netear6ka_ear8ma_ear4ta_e5a4telea4t3eteau6ge_eau8ra_eau8se_eav8le_eba4ne_ebesku5ebu5ernedag4s5ed7delaed5e6geed5eg4nede8le_e8d5engede4s5pe6d5ettedi4eneedi4s5ke5drev_e6d5ryged3s4lae3d6ø1reer4me_ees6ke_eev4ne_efal6s7efar6s5e5f4ilmefi7renefo8bi_ega4ve_ege4leteg8g9ute3g6lade3g4ledeg7lesae5g4lite9g8nagegrans5egå4ve_e4h5ereehy6re_ei3d8arei6kerieil5eggei4me5seim9ettei4n3alei4nansein5antei7nare4e3indu6ei6nite5inkareinsi9dein4s3le4inspiein7stoei2n1u4ei3s4haei6s3kjei3s4peei4teraei4tereei6t7utejo8en_ekalie6ekam6s5eka6ra_ek5e4tae5k6hovekke7leekk9iste8klanee3k4nokekords8eko6te_e3k4rede5kretse5k4revek3s4akek4stil5ek3tepek6testek4t3raeku4le_ek6var_e4k5vikeky6te_e6l5argel7artiela4te_elbo8daeld4rereld5sleele7gereleg8nae5lemat5elemene5lemete4l5enhe4lentuele8ra_e7lerete6l7erge6lesku5e8lev_ele4vak6e5levnel5gelee4l3indelin5ese4linspeli6o5seli8ta_eli4tet6e5littel6k5alel4ke5sel4keteel5l6arell5eieel3le4sel6leteel4lisjell5s4lel5l4urelo6ka_e4l5ovnels5eieel4skalels4tenel4teroel4t3opelt5rope4lu4heelu8pe_el4ve3del6vereely8et_elæ5rese4l3ø4re6l3øynema4ge_ema4ke_em5aktiema6le_5e4maljema4ni_em7ar8me6masku5emballembe6r5eme5triemi5erte4minoremo5nole2m3o4vem6periem4s5juemta8laemå9lane6n7ange4n3antenbe9naen5demien4deslen4d3roendør5eeneg8gaene7venen4gerieng4leseng3s4eengs4tie4nierken4keraen4keriennes6tenn5stae6n5orden4seli5ensemben4ses4ensle7gens6levens4terens7unden9timaen4to4rent5orient5rabent5renen4t3råeod8de_eon8de_eori5e6epi6ka_ep5leneeple9s6ep4ses4ep6s5lue4r3abbera8da_era6na_e5ra7neer7anlier5ape_er5aperer5appee5rasare4rasjee4r3asse4ratekera7torerbi9tierbo8daerden8serd4skjerd4stoere6ke_e4r3eksere4lite6rellie4r3else4r3enge4r5enhe3re4o7e4r3erfe4r3etaeretts5e4r3evn5erfarierg5elverg5reterg5skoeri4kate5riorie5rist_e7ristae5risteer7jes_er4kesaer4keseer4kete4er5k4oer5nedeer4neroer4neste7ro6pae5ropene7ro4saerrie9nersa8kaers4ka_ers5korers6leders5terer7stever4s5årer4tareerti4moert5role4r3ungervele8erye7nee9r4æree5r6ønner7øyskerå8de_er3å4seer7åta9esa6la_esa9mete4s3antes5arabes3ei4des5eie_esel5s4e4s3erkese5tasese4te_esh9ar_es4h5ere7s8hopesi5erte4s3inse4skinge6skjønesku5etes7let_es7letse4s5lokes4makeesnæ5ree4s3oriespa9rae4s4pedes5permes4p5lees4setees4s3jaess4letes4stoless5toress9tuaess5tuees7taktes9talae8stanee5stanses5tante5startes5tatoe4s3taue7stav_est5avse6s5te_est5eieest5eige5stelles5telse4stemae6stemee4stemoes5tempe7stenges5tenkeste3s4es4testes4tienes4tikkes3t6one3s4toles6toneest5ordest5ories5trakest5reres5tribe5strykest7åseesva5ree5s4veke5svikteta4la_4e5talletal4s7eta4nen3etappe4e5tatiete4ma_e5teranetning4et5oppde5t4rade7t6rake4t3riset9sar_ett5altet4tanket6teltet4tenket4tennettera45etterk5etterrett5eskettian8ett4skiett4stieun4ge_eur6ne_ev5aktievann4se4varare4v5arkeve5d6aeve5delevei6s55eventyevi5ereevi5ertevi4se_evn5a4kevta8laeyr4ke_eør6na_évo8re_è4renerfag5eti6f5agrofakse9tfal6kesfal4k3lfan4tryfar4gelfar4gesfar6skjfar4velfa4serufa3t6refba4ne_fe3d4rifei5er_feig4defeil5esfei7terfek6tesfekt5evfeli7e6felles5fel9ta_fel4tekfel4trafem4tidfer4damfe7rer_fer5ersfers7kefes9t6ifes8t3rfes9tumfe6st9øfett7s6f2f3a2gf6ferdiffe4rerffla8gafibi6enfi7e6refikali7fik6k5nfil6lelfil4lesfilt6refil4trifin5artfinn5ei6finnsafi9renefi5res_fiser6sfis7kalfis4k3l6fiskolfjer5neflit9t8flo6r5oflos6klfol6k5vfol9lerfo3n4idfor7drofor5d6ufor7e6nfor5entfor5essfo4r9inforlo7vformo9rfor3s4mfor9stefor5t6efor7t6ifor3t4vfor3u4lfra4m5efranko5fran7sefra5se_fra7sepfrasi8efra7v6rfreds5tfre8s9v6f5ridifri4erffris6kafri5s4pf2s3tabf6s5tanfta8la_f4t3enhf4terinf4t5ettf2t5i4sfts5altfts5ersfts5ervft2skafft2s1ø4ftta8kafug9le_ful9larful9le_ful4lenful4lerful7lesfyr8ke_fø5des_fø7resvfø8retefør6tingak8ta_gal4les6gandengan4g5jga6r5akgar4dekgar6ta_gar8te_gas8ka_gas8ke_gas6selgas5sengas7sergas9triga5tensgat6tapgau5la_6ga4veiga4verigba4ne_g4de5regeak8tagea7ren9gedom_7gedoma9gedome6gedomsgei8s7pgei6st5gei4t3r4g3elemge5len_ge5lensgel5ett6geligggelsk7lge7n6amgends6tgen5erfgen5etigen8ga_ge4ni6ngen6sungeomet4ge6rene6gerese4gerettger4i5dgeri8ka6gerikegerle9g4gerom_4geromm6gerop_4gerope5gesen_5gesens4ge5sjage5spra5geste_ges8ti_geså5re6getat_6getate2ge7v8agevi6sagev6ne_g6gereigge4ring6ge5svg4g5i4mggra6dag4g5u4rght5ene4gimessgi4metrgi3s4pagi5s4prgist5ragi5strégjen5s8gje4s3pgla8ge_g5last_gleg8gag9lene_g9lenesgle6se_g4le5skg6le7smgli4delgli7e6n5g6lomegloria7glo5stegly4se_gmu8le_gna5lemgne8se_gnings5g6ni5skgnist9rgok4se_gol6vargore8a7gori5e6graf5t6gran5togrant4rgra9se_gra9setgra8te_grati4sgra7visgravta84g5redsgreie5n6g3reisgrep4s36g5rest6g5rytmgrø5de_grå5te_g5salg_g5salgeg3s6ankgse9la_gsel4stg5siderg5skallg4skapag5skapeg4skapig5skiltg7s6kjæg5skrengsla6gags6lerigsl9ut_gs5pileg5stanggs4tasjg7s4tatg5ste4egs4tellgs5temag7stemtgs4tereg5s4ti_g3s4tieg3s4tigg5stol_g7stolag5stolegs5tollgs4trapg5straugst5reagst5reigs6tretg5s6trågs4vanegta8ka_gta8ke_gta6la_gta4le_gte6ke_gte6ma_gti8de_gtu8en_4g5u4båguid5argul8ke_gur6ne_gut4takgut4tesgva4ke_gvedli6ha7keraha4ke5shald4s7hal6leihal4s3khal4s3than6d5rhan6nelhan5nenhar5trehar4trihas6p7lhau5ke_hau4t5rha5van5hba4ne_hef7teshek4sekhel4se7helses4hel5stehel4teshem3s8khera9daher6reiher6rether5un4hes5pelhes5penhes9perhes4teshet4s5phev9na_hi6n7anhin4neshins9kehjorte5hju7l8eho5der_hog6strhove5rehun6deshu4s3edhus4trehu6s5u6hvi5l6ihvor5i6hye5ne_hye9neshyg5gelhyldes7hyr4deshøy7rariak8se_ial5einial5etiian5aldi5a4ne_iard5s4i7arskaiaty6raiba4ne_ibi5er_ib4le5siby9ar_ick7eteiddel5uid5e4geiden5svi6derapi7dereni9deres4i3drevid4s5tui7e6limielø8paien4s5vien4t3rif4tereig3e4taigje9vaig5s4kaig3s4krig3s4paig5stekig7stelig5stemigs4traig5s4vaiho7le_ihu5le_i5kabeli4kareii9kelegi5kere_ike4r5oi2ke1s2ik6kanaikk5arvikk5attik4keruik8keskik4kestik4kjøpikk5lagikk5ord4ik2ku2ikk5undiko5na_i5k6ordik5robeik5speliku6le_i6k7u6tilas5t6il4dekoil4deteild3s4tile8areile4ge_i4l3egni4le5skile6triilet5teilfø5reili5ersi4l3indi4l3i4ril5jeseilk4o6sillei9eil6leskilli9gail4lo5mills5kåilm5e4vi4l1o4rilta9lai6m5akkimor8da5imperiims4k5lim5s4meimta8laina4leti4n5assind5s4tine8areine8pe_i7nere_i5nereni9neresine4rikines8kaines4stin5gebj5ingeniin5geriin4geruing5jening5reping7risings5omini9ar_i4nises5initiain4keroin4k3lainla8gain4nerøin4nesiinnes6tinnfa9s5innhalin4n5ominn9seninn9steinn7svein4n5u4in5skatinske4tins6korins4k3vinsle7gin3s2løin5s4main5s4pl5instalin4stinin5stra5instruinta8la5in7tegint5essinti5meintran4int4rerin5tresi8n9ul8in9u8teio4dereiol7jenio4nansio4narrio4r5inipa4ti_ip4peliipp6lanipp4s3ti9r6andire6r5airi8ka_ir5instir5ker_irke3s6ir4kestir4mastiru7sa_i4s3angi4s3ansise5erni4sektei6s7eldis4e5liisensi6iset8jeisha7neis4h5inishø9veisi6enei4s3indisk5elsiske5s4is6k5leis7kogri5skulaisl9øy_is6s7kjis9s4ærista9leis5tanei4s5tarist5avbist7aviist5ektistel5lis5ten_is5teneis5ter_is5ternis6terøis5tilbi5streri4stresi6stretita4l3aite8ke_i6t7elgiter6s5i4te5ruite6se_itet6s5iti6er_i4tikami4ti3kvi4tiseni4tiskoi4ti3spiti5stritnes4sitri8mait7ro6sit4s3eiitta9lait6tannit4t5atit4tenkitte5s4itt5ettitt5skri4v3aksiva6la_i4v5ankivar5s6i4v5assiv5eg6nive5rasi6vereti4vestiiyr8ke_iåt4te_jak4keljakk5s4ja6r5apjarn3s4jar5te_jau4ere6je4dekje4f3etjef5lagje4f3rejef6s5ijef3t4rjeg6lesjek4tanjek6tesjekt5evjek4t3rjekts4tje6legrje7lelejel6lagjel5lenjel7va_jem4stije7ne8sjen5gedjeng5s4je2n1y4jer4dep6jerennje6rinæjer4kesjer6k5ljern5sljes4kiljes4teaje6stimje4t3agjeta6kaje9tar_je7taraje9tareje4t3rujett5s6je7varkjev7na_jok9kerjokk9o8jon6stijon4strjor6dekjor4d3ojords4ljor5tetjo5steiju4e5rejuk9sarju8l9eijul7innju6p5å6jæ9res_jøl6verjør4keljør4teljø6t7avjøt5eta5ka4an46kadaleka6del_ka4deri6k5aksjka6lantkal7s6vkal4ves4kameri4kammelkam4p3ikan6da_kan6t9r5kapellkap4s3t4karbei6k3arki6k5arktkar5peska5se4ikas6sadkas4sak4k3assi8kas5tokas2t3r1ka7t6aka4t5op4ka1t4rkat4telkatte5skat4tilkat4trikav8l9u5kedan_9kedant7kedes_ke3l4akke6lanskel5eigkel7eik6keleiskel3e4l4k5elem4keleng4ke5lep7k6eletkeli8e8keli9en4kelign4kelinjkel5intke4lise6kelov_4kelovekelsva9kel9ukakel5ukeke4l3ur6ke5l4åkelå7re4kend5r6kenett4ke5niv4k5enseken5t6r4k3entuker5antkerei4d4kereir6kereis4ke5rem6kerene4kerenn4keress4kerest4keresu5keret_5kereta7kerets6kerik_4kerike6keriktke4rineke4rinæ4ke3rosker3t4v9kesam_4k5eskekes8ke_kes5ped5kespot5ke4spu4ke3sta5keste_kes6tem4kestrike4s5unketa6ka5ketalsket8teskev4je_kev6ne_kevæ8rakhjul8skikk8s9kin9andki4narkki5nas_kin5ingkinn4spki5stavkjap5pe6k7jarnkje7f6r5kjemaskje6t5rkju5le_kju5lenk8kand_k4k5angk4k7artkke6leikkel3t4kke4lukkkel5unkke6nank4kereik4kerelk4kerigk4keritk5kesaukke3s4lk5ketetkk5jentkko6ligkk3s4eikks5takkks7tepkk8s7vakk5s4å7k2k1u6t4k5lagtkla9ke_kla4melkleby7t3k4leddkle4debkle4des5k6lem_7k4lenok6lerikkle5snokle5stikles7s81k2lim23k4lini3k4lyngklæ5reskne4b3lkne8se_knippe6kog9ger4komisbko4misekon6s7vkon6tonko5perskop5perkor6da_kor4d3okor4salkor4s5lkor6strkor5teskor6topkor4t5rkort5s4ko6rume5kosele2ko1s2pkost7askots5trkotts5tkover7e1kov4s3kre4kli4k3renn4k3ress6k7retnkrig6s5krik6ka3k6rinsk4roforkro4nomkro9t8ekroten9krutt5ik4s3antk6s3arkkse5levksen5tok5serolk4ses6kk4se3smkses4spkses4stkse6te_k4s3insk6s3kalksko7naksko5nek8s7lugkslø8vak5s4makks5tantk7s8vakkste4dakst6rank6strenk6strerk5s4vinksy8s7mksø4ke_k4t3akskta6la_k4t3anakta9na_k4t3annk4t3arrk4t3artk6t7atlk6t3avlkt5e4gek4t3enhkter5s6kt5eskekt5estik4t3inskt7i6tekt5ord_kt4s5erkts5krakt5sprekts6tonkts5topktu9er_kue4r5akun4ge_ku7r6opkuro8pakur4s3tkur4v3ikus5a6kku4s5elku7s6pe4ku5te_5k6vartkvei9se4k3verdkverns8kvi4enekyr8ke_kys4telkøy7ar_2l3abonladi9e8lag5san4l3anallan6daslan6deblan6gellan4gemlang3s46l5ansilap5senlap5s4i6l7arab4l7areal6aren_4larena4l3arkilar6ta_lar7vetlas6saklas6samlas6satlas6sellat5angla4tenolate5s4lat7ra_lat9ranlat5rarlat4trala4v5allav5innlba5ke_lba4ne_lbe8re_lda6t5olda6t5yl4derekl6derikl6destrl8d5oksld7regnld5rer_l8dres_lds6leglds4letld5s4omle4gerale4gerole4geta2le1g2l6lehamr6lehavel6ei8etlei4gerlei4getleig4h5leig6naleig8nelei6r7u4l3ekso4l3elsklelø6palem9pedlem5peslem4s5ølen9dan6lendenl6endre4lendrilen4g5r4lensemlen5seslen4stalen4tamle8pla_4leraba4lereso4leresule6rieile7rina4l5ernæ6lerope4le3rotle7singles5innle7skaple4s3kj6leskol6lespal9lesta_7lestalle5stedle5stegle5stelle4stim4lestrø4lestyrle5s6vileta8kal5e4tas6letenk6le7teple5ter_l5e4tikle5t4rilet6tealett3s4le6valu6levern4le4vevl6f3nullga8le_l4g5altl4g3analga4ve_lge4raplger5unl6ge7splgsle9glg5s4trlgå8ve_lha8ka_lhav6s5libe5roli5ers_li4g3anlig9artli8gas_li4g3relig3s4ilig3s4plig5strli5kesålil5letli6mate4lina6l5l4indrlind3s4l5indusli3ne6alin4g3j4l5injulin5keslin5klelin5net4l3instli6n5ø6lion5splion5svlipp4s3lis7tanli6s8trlist7røli4st5yli4ti3aliti5stlit5rerlitt5s6li4v3akljar5s6l5jete_l5kedall5kelegl4k5ersl4ke3rul6k5ninlk5ri6kl4k3s2hlku4le_l4l5anoll5anskllau6relle8da_lle4d3rlle5gevl4l5eigl4lendrl6lendtl5l8ensl4lentull5eplel4leroblles5prlle5støll5evenlle7vevlli5e4nl4l3indl9lint_lli6senllmu9erl4l3offllom5s6lls5endlls6karlls5laglls6tigl8l7ukal4l3ukelly4se_llø6pa_lløy6erll5øy6nl4markil4m3elslm5e4pol4m5erflme7stilme5t4rlmi8le_lmin7nelmu4le_lmå6la_lob5by_lob5byelo4d3rilod3s4mlod7stelod7s6vlog8reslo6g5rolok6kul2lo1k4l2lok7s4lok8se_lo4m5inlom4mellomst9rlon4g3rlon7skjlor6da_lor4g5llos4kle4lottetlov7aldlo9vandlo7vanel6over_love5rel5overnl5pelegl4pelinlpi5ne_lradi4ulra6ne_lre8ke_lri4ve_lro8de_lro6pa_lro8sa_lro4se_lrø6re_lrå8da_lrå4de_l4s5anol4s3ansl4s3elel4s3elvlses5kulses5palse4te_l6s5illl4s3innls5jakkls5kabil4s5kanls5karilsk5artlskinn6ls1kjedlskå6palsla4gal7slagnl5s4lukl6s5løslsmå6lals7o6sel5spredl4s3takl4s3tall6stankl3ste4ils5terrls5trenl6s5veklsve7rels6vindlta4la_l4t3alblta6levlta8teslta4t3olte6ma_l4t5enhl4terasl6trekol6t5rell6t7reml4trensl4t5ritltro8pal4t5rødltur5e6ltur5s6ltur5å6ltva8laluid6erlun5d4rlun4gellur8ne_lus4sidlus4s3tlus2t3rlut4tallut4tapl4vaktil4v5asslve3d4alve5i6slve9raul7v6et_lve5strlvi8enelvi6ka_lvo8re_ly4n5illyst9raly4teril5y4tinlær4armlæ4re3slæ5res_6l7øv8d6l5øys_løy5terlås7tenlås5termada5memak5ronmak4tal4m3aktimakts4tma6lengman4domman4donman5g4aman4nemmanns5l5ma9ren4markitma4ro6pmar3s4hmas4seemas6setma5stem4ma5str7mater_6matera6m7atfe7matil_ma4t3rem4beregmbo4endmbo5er_mbo5erembu7ar_mbue7reme6dretme5d4us2me5k8r5melanemel2s3jmel5s4t4m5engamen5splmen6tekmen4tomme4ra5l4meress4me5ribmeri5kemerle7gmer5und4me5s4h5meste_6me7stome5stro6mestrø4mestrå4me9tapme4t3ramet5renmet7rermet5resmet5rik7m4eu3smfar8tam6f3essmfu6se_mgå8ve_miche6l4mi3ele5migrafmik5ro_mik5ronmil7etimil6s5v4m3innh4m3innsmi3s4lamis4s5kmis4s7pmista9k5mis7temis4tramku6le_mle6se_mle4ve_mly6se_mlø6pe_mma8le_mmando5mmar7inm2me3k2mme4runm4metrammå8la_m4nestamo7le6smom4s5ømo4nisamon4stemo7rar_mor5d6emor6d5rmor4skjmor7sky6mostabmote7klmo5ter_motsva5m4pelotmpe5resmpes6tempe4stim4pinjem3p4lanm6p5linm4poetampro8pamro8sa_mro6se_mru7te_m4s3engms5e4plm5s6etnmsk5ingms6legam4s3talm8s7te_ms5tilbm4s5topmst5ordmst5redms5trefmst5renms5trikmsu7tenmsva9ramsva5rem3s4vetmsø4ke_m6te7kvm6testum6tien_mull6s7mul6tivmun6ge_6m5univmunn5s6mun4t3rmu4ses4mus5tanmut7t6rmveg5s4mvi6se_myk4kesmytt6s5mø8nest6m5ønskmør4k5rmø4teremå9nesenak8se_nak6ta_na6lare6nalarvna4l3einal5eponal6ge_nal6lagnal4løpna3lå5rna7mere4n5angrnan6ke_6n5anlen4n5ansnan4sinnan4skjnan4s5t4na5rek4narkiv6n5armé6n5armenar8ma_nar8stenar6ta_na2s5t4nat6taknat6teanav4lesnba9sern4d5alln6d3artnda5taln5d4e5lnde4le_n4delikndel4skndel4stn6denern2de5o2n4derabn4derasn4derein4derimn4d3intnd4lesend4lestn6d5okkn4d3ramndre4rand5rettnds5elvnds7kulnd3s4tends9tegnd5stryne7a6lenea9ren5negatinei8dannek5rinn7ekser6nelegg4n3elem4neliganel4lovnelø8panem5ne_nem7nelnen5at_4neneslnen5etanen4ga_4n3enhe6nenhetnent5ei4nerent4neress4neresu4nerfar4ne3ribne4ri9vne1r4ovner5s4i4ne3rul5nesetsnes5evanes5indne5skam4ne5skones6samnes4stu4nestasnes9te_nes5tor4ne3strneså5re4netaksnet5s4pnett3a4net6telnevi8sanfalls5nfø5desnføy8edng5and_n4g5armng5art_n5gartanga4ve_n4g3engn4geretnge5runngjen5gn8g7o8mng7o6pen5grad_ng5randn4grendng5restngs5elvngs7legng5sløyngs7tepngs9tørngu5ru_ngå8ve_ni7dele7ni3e2n4n3i4frni6n7alning6s5ningse4ni9pet_ni9petsnir7kel4ni3skjnis4k3oniso5ne4nistas6nistatnis5tik4nistilnitt4s3nitt6sknitær6eniv5ei8n5jede_n4k5enhnker4stn4ke1s4n7k4lisnkol4lanku4le_nkurie8nland9anle8ma_nli4en_nly6de_nly4se_nlø6pa_nma4le_nmo6se_nmå6la_n4n5ankn5nebarnnebe8rnne6natnne4n3on4nereln4ne3stn5n6et_n2n1o4rnnsa9kanns5andnnsei8gnn4s3emnn4s3esnnsi7dann4s3innns5kannns5talnns4tennns5tepnns7tinnns5topnns5tronn4s5ulnn6s5vonnsy8nann3så5rnnto9ganok6se_nor4d5rnord3s4norges5n3o4rienor6klanor6klenostra4n6renemnro6de_n5sa4kr6n5aktin6s5alpn5s6annn5sansens5ansinse9a8lns5eie_n4s3elvn5sene_n4senern9senesn4senetn4se3skn4ses4pnsi5de_nsi4entnsi6er_n3s4ingn4sintens7kelens4ketens5kjennskog6snsku9etns5kulin5s6ky_n5s4kyen5skyssn5slangns6lerin5s4narnso5risnspa9rans5pelsn6sprosns5taken4stanknst5artn3s6tedn3s4teins5tenkn5s4tikns5tildns7tilfns7trøyns5vangnsva9rans5verdns5vernns4vindnså7pennta4lannta5na_n4t5andnta5siant5eininte5insn4teksen9telegn5telignte4ma_nte4misn4te7nan5tene_n4t3enhn5teorin7terekn4teselnt5e4van4tikapnti5klin9time_n7timesn4t3indnti6netn5to5rent5resin4t3rinnt5s6lan2t1u2nn4t5urontva8lanun4ge_nus4k5lnut5erinverle9nvi4ka_ny3k4lenyn8da_nyn4de_nær9andnød5stonøy8a9nnån6de_oar6d7eobakk8sober5etock5ersod4destoderle7o4d3iglod3s4pooen2g7roes8ke_oev6ne_o4fe3stoff9andoge7na_og4gerao6gista5o4g5nio5g6noso4g3rego4g3reiog7rettog4s5tjog5stre5o4g5åto1i2d9ioi2n1o4ok5els5ok4kandok6keraok4ke5sokna8sao4k3omsokse5krokse9teoksi7daok6s5vioku8le_ola6dedo6larbeol4destol5drevo5leakso7lene_o9leneso4leneto6leredole5staole5stroli9e6noli7ertolke3s4ol4keseol4keskol4kestol6linjol4mesto6l7os_o6l5osfols5vikol6t7raolt5re_olt5rerolt5reto4l3ungoma4nifomar7ø8o7menesome4takome7tarom3in5som4metromsko9do4n3ango4n3argo4n3arvo2n1a4vonder6eon4d5riong9roso2n3i2do6n7innons5undo4pa3reo7parenopel6løo4penet6o3per_ope6raroping9sopp5ropopp5undo6r7addo4r5algoral4stor6alt_orda9taordy9raorear8aorear8eo5rebraore6na_ore4nedore4netores6teor9et8norfi7ne1or3g4aorha9le5orientorla7teorm5angor4m3unorne6droror9daors5altor4serkorse9taors5karors8k9lorso9naorso9neors4tenor4t3akorta9peor4t5avorto9neort5oriort5resort5rådor4t3årorva9rao9r4æreo5seleioses4skoses6sposes4stosfa9taosi5ereosi5erto2s1ingoskei6eosk9larosk5lenos5sensos4s5kooss7troost5adrosta5leost5eggos6tonsost5ranost5rupota4l5aotal7evota4lovo8t9armote5intote4kleot5elemote5levotel4liotel8løo4teramo4tereto6terevote5r8uote5stéotet3s6oti7ertot7i6koot6nerooto6en_oto4ralo6t5romot4s3kiotsopp6ots5tabot6tankot5tegnot6tenkot5teseott4s3kotts5pootts4tioun6ge_ovanfø8o5vendeove6nyaove7ra_ove9raso6verdr3o6verfo5verksovers4povveg7ipak4kaspakke4spang5s69panne_4parenapar5esspar6k7lpar8ra_par6tidpar4tigpar4tinpase6r5pas5sabpas4tarpa4tistpat6takpba4ne_pde4le_pe4a3repedi9e8peg8ge_pei4legpek4tropel5s6epel5s4ipe4n3arpen4gelpen7s8apensa7kpen4s5lpen3s6mpen5s6open9stapen7stepen7tagpep5ar_4pe4rab4perate4peresp4perest4peresu4pe5rikperi3s4per6lesper6reiper4tropervi6kpes8ka_pes4ke_5peste_pes5tilpeta6kape4t5rupev6ne_3p6fenn7pi3anepig6g9upil4lagpillba6pil6ledpil4legping5skpis4t5rpla8de_plan7de4plane_ple5n4aple6r5uple8se_pne6se_pom6p9upor6s7vpor4torpor4tråpos5taspo5statpotek5lpo5t6hapover6np2p3a4lpp5angrp4p3anlp2pe5i4ppel5s6p4pendrppe9nesp7pere_p4perklppes8tip4p5innpp5lastpp7rissppska9kpra5te_pr5elempri4l3epri6s5kprun7geprørs5tpråk5k6psei8geps5e4lyp4s3kilps7kjenp7s6ko_p5s4koep9s8lo_pslø8vapspi9lap3s4prep4s5prop4s5temps4vingpsø4ke_pta8la_pta4le_pte4ma_punk4t5pvi4se_pør4ret3radio3raf4fer6r5akadra5k6harak4kelrak3s4erak6se_ral5ans6ralbum4r5alge4r5algo4ra5l8å6r9ambi4ra4merram8et_ram6p3u6r3analr5andelrang5strann3s4ran4tik4r5appl7rarbehrar5e6l4ra3reprar7etarar8ka_rar8ma_2r1ar5trar6ta_ra7s6korast5re6ra5tegra4t5rorat5telratte4srau6ge_rave5s4r3a4visravlø8srbed5enrbed5etrbed9rarbis5trrbo8di_rdag4s5rda4le_rda4mesrda8n9ord5antar4d3armr4d3artrd5e4ger6d7engr6d7enhrden4s3rdense4r4derikrd3e4tar6d7ettr4dianar4diansrdig3s4r4d5o4drdover5rd7rarar5drev_rds5tanrdsto5grds7trerdsva9rrdta8kardø4ve_re4d5rired5skureds5larega7tarei8ga_rei8ge_rei5na_rei7nasre5inderei5ne_rei7nesre4invarei7skarekk6anrek4k5v5reklamrek4ledrek4terr4e5lei7relenerel4lagrel5ledrel4levrel5ses4re7l6åremann6remmed5ren4delr3e4nel4renestreng5st6r5e6pi4rer6at4rerent4rerese4reresu4r3ernæ4rerutere6r7øyres7kodres4salres4sekres4sit5restaures4tes4re3stires4til4restre4re5sty4retaki8retek_6reteke4retekn6re5tem2re5t2rret7tedret5terr3e4vigre4v5åprfe8en_rfe4et_rfei5lirfe5m6ørga8le_r4g5anvrga4ve_r4gereir4geretr4ge3rur4gestarg3i4rirg5repsrgs6korrg5s4lergå6ve_rhjul8s6riansv3ri6avo4ridale4rielem6rielimriel4la4rietatri5evenrig6s7tri4kalirik7kenri8k9la2ri1k2rrik4s5u6r5ilderi5n6amrin7gomrin9nesrin4t5jripo4s3ri4seli5risiko6ristadris5tik4ristilris5tofri5stunriti9darive9ge4riverkri4vi4sriv5iseriø4r3arj7ambirkei8kar4ke3lur4kenavr4kerisr4ke3rur5k8ledrklæ5rerklå9rarko6b5rr4koselr6k7rasr5k6remr6k6segrk6stalrk4stenrk4s5tirk6s5virku4le_r6k7u6trla4te_r6le7slrli4te_rlø8pa_rma6ge_rma5k4lrme6lapr4menetr6merevrme9tarr4m5idermi6enermlø8parm5s6korms5tilrmta8larmue5nermu8la_rmu6le_r6m7åtar4n3aldr4n3artr5neboer4n3engr4nereir6nerisrne6se_r4ne3skr4n1o4vrn4s3inrn7s6mirn5sponrn3s4prrnå8le_roff5riroga9tarog5retrok6katrok4komrok8se_roli7garol4labrol4laprol4legrol4lisro4materom5sla6ronismro8pla_ror6da_ros7tasrost7røroti7karot5ordro9varerove5rerprø5ver6p5ut_rre7intr5relatr4re3rur4resperres5tarre7stirre5strrret6s5rri6ka_rrmå8larro8se_rsa6la_r8s9ald5s6ch6lr4s3elvrse4te_rsett8or5s4ingr6s7kafr4skar_rskla8grsk5larrs4k5lers4k3lær4s3krar5skrivr4s3krorsku7etrsk5undrsk5varr5s6litrs4makerso5n8erso5n6irso7risr5spredrs5tankrs5tendrsten6srs5ter_rs9tre_rs7treer4strinr4s5trorstu9varsva9rar3s4vekrta4ka_r4te3inrte6ke_rte6ma_r5teresr4terisr6testirtian8dr4tiansrti8ar_rti6grar4ti3kvr4ti7nar6tiskar4tiskirt6i9sor4t3opprt6opp_r6t7o6sr4t3risr4t5rosr5t6rålrts5engrt4s5jart5s4nort3s4pertu6en_rtu8ve_rty8da_rty8de_r6t5ås3rul8ke_rum4p9l5r2underun5delrund3s4run6ge_rus5selr7utan_ru4vereru6v7isrve4denr4ve5drrvel9ler4v5eng4r5yndlry5nes_ryr4ke_rys6sal8r3æ4rerø4kerorøn5nesrønn5skrøn5sko5r6øntgrø5vederø9versrøy6enerådy9raråle7s8rå5let_sa4dere6sagent6s5a6gi2s1a2gr3s4a3ke5s4aks_sak4s3i4s3aksjsak6ta_5s4akto5sa5lat4s5algosalg6s5sal4mes5sal2s34saltersal5vedsam4an7sam4levsammen54s1a2nasan6da_sand5stsan4d5ø1s2a5ne4s3angrs7anken5s4ans_san7s6k9s8are_4sarealsar6ka_4s3arkisar8me_sar4ta_2s1a4sp4sa5t6r4s3attasatte4ssau5di_sau6ge_sba4ne_sdag4s5sde6le_sdu8en_se3an5dse7ansaseg8ga_7segletsei8dansei9dens5ei4etsei6ga_sek4kes3s4eksjsek6te_3sek5to5selanesel5arts3e4lasse6l5at4se5led6selega4s3elem4selengsel6løpsel4sinsel4sposel4vanselv3e4sel4ve_selvei4sel4versel8vinsemini6sen9d8a6senden8senesa6seneses5engassen5ters2e5r4e4serenn4serent4sereso4seress4serest4seresu4serkjeser7nevser4takser6tatse4r3unser4vedser4vel2se5r6øses5ald5sesalsses5altse4sene4sesjukses5kalses5karses5lit5seste_2se2t6aseta8kase4terase5teros3e4tiks3e4tis5setje_s8e5varsevi4sasev4ne_sfa4ne_sfe6et_sforlø9sfø9rensfø5rersga4ve_sgå4ve_6s7hoppshø6ve_sial5v63si4de_3si3densi5der_si4detesi6erensiger4s4s3iglosikt4s3sil4delsil4dersil4dessil4les4s3indu3s4inn_7s4innas6inne_5sinnetsinsk5esi4serfsis5e4vsi4s5tesi6t7rasi4t5resitsva9sit4tes8s5ja9gsje4f3isje4flasje4lev3s2jen_5s2jene4s3jent5s4jer_s2je5s45s4jet_sjet4tiska5lar4s5kana4skande5s6kap_4skapas6skapitsk5arabsk7arbe4s5kark3s8karvs6keliks6kenavs4ketet5s4kiltski6netski4nin6s5kirk4s5kist5skjema7skjerss6k5lansk5lings4k5luf7s4kola4s3kolls5k6omes6korpis4k9ra_5s4krals2k7re_4s3kref5s8krek4s3kret5skrevn4skrite5s4krog4s3kropskru3s66skrysssku4endskue5re5skulan5skular8s5kurs6s6kyss5s6kysksla8ge_4s3landslap5pes5laran4s5lastsla4te_sla4vin8s5leke4sle7nes6lenersli4en_8s3linjslin6t55s4lit_3s4lites6lott_sluk3s6slum4p5sly8et_slø4pa_slø8s5a3s4løsislå5nersma9let6s5medi8s5meld3s4mell5s4melt3s4mertsmi4enesmo8de_6s5mugg1s2my4ksnei5ersne4krisnik5kosnæ4re_snø5d4r6s5ofresog6nemsok4se_so4leneso6mend4s3omfa3s6omme7somren5somrer6s3områsom5stisong3s48sopple7sorga_4s3oriesover5esove3s4spa5g6h3s4pannspe4legspe4les5spelet3s4penn6s5pilospi7res5s6piss5s6pole6s7poli5s4pors6s3pregspre5ke5s4pren6s5pres5s4prets6print8s3pris6s5prob5sprog_5sprogesre8ke_sri4ve_sro6se_srå4da_sråde9rs7sabelssa8ke_ssa6la_ssa4me_s7s8ar_s7s6armssau8sass9elv_sse8na_s6serabs6serats4seskis8s9imes6s3indss5inits4s3insss4kapesska8ras4s5nøds4sorgass7tilpss5trenssva7ra3s6t2adsta6d3osta6ka_6sta4lasta5laksta4le_5s6talista5na_3s4tandsta8n9o3s8tasj4s5taststa5top3s6teg_stega6l4s5tegn4stegspste4herstei5er4steikn3s4tek_4s4tekaste4ket4s5tekns8te5kvste5le_s5telegste5levs5telig3s4temmste4nars4tener3s6tengstens5l8s5teras4terams4terevs7t6erfs4teridste7ris4s3termste5runste7sleste7t6rstgå8vas6tidels4tigen7s6tigist9i8gj6s5tika4s5tike3s6til_5s4tilasti4lag6s5tils5stiltesti7mer3s6timus6t3ind4s6tinns6tinst4s3tipp6s7tisk4s3tjen6s5tomtst5opplsto4retsto4t5r4s5trads8traff6strafi6strail5strand4strane6stransst7ras_s4tre3ast5reis7strek_st5rekl6strenist5rer_6strers9s8tridst5rige5stri3ss5t4rog5s4trokst7rop_s6tropes6t7rug9s6trukst5rum_s7trykt6s5trøbst5røses5trøststsy8nastue5re6s3tung3s8tunts3t4vedstø7va_stø5varsul4t5r4s3umid5sundet5s4undisun6d7rsun4ge_6s7u2nisur4stisu6s5es2s1u4t1sut6ra_sut8reg8s5u6visva4les6svalet5s6valis4varet3s4vartsve6g7i3s4veis6s5veks5s4venssve8res3s4verg5s4verjsver4ki6s7vervsvi6e3lsvi5ke_4sviks_svi4nessvi4sa_svi5sensvi5ser5s6vulmsvye7nesy5kere4s5yndlsyr4ke_8s3æ4re3s6økna5s6øksmsør9ettsø7tastsøy8de_6s5øy4nsån6de_ta8d3eitad5spatad7s6vtak7keltak5k4lta8k9latak4saltak6se_4t3aksjtak4tal4taktigtal5angtal5eieta5ler_tale7s6tal6ge_talj5estal4ledtal4legtall7es6talter2ta3m4o4t3analt5andak4tanett6t3angrtans5kat5an5sl8tantiltan4trata4r3akta6rare6t7ark_tar8ka_4t5arke4t3arkit5artiktar7tittar4t3rt3a4sia6ta7stotat5e4v2t1a4uktau4ne_tbe6te_tbe6t7r2te9a8ltebu8da6t5edditedo4ertedyr9kteg8ga_te9g8li6tegspltei6ga_te4innete5intete5k4late6k5ru4t3eksat4ek8sttek8t9r8te4le_4telemete4lenete5lesk4te4levte6levatel5leftel4leitel4levtelses5tel7s6v5teltette4mans6temenntem5ne_tem5ordte4n5alten5at_6tenerg7tengont5e4nig6tenormten5skoten6sluten5økstepa9rat5e6plete7rakk6terammter7apa4terappte4rare6terasa4terase7terast4tereis8terem_6teremm6terennte4rerk4terett6terevo4terisi6terks4ter8ma_4teroll5teromr4te3ros4te3rotters4klter3s4mters6nete4r3øvte4r3ås6te3sin6tesjef2te1s2m7tesmåe4testaftes5tas4testat5testidtes4tik4te3sto4te3strteså9reteta6ka2t8et2rte4valutgi5rostgrei9e4ti3all6t3idee4ti5dem2ti5f6r6tikarr2ti1k2r6tikulttila6ga4tille_4tillinti4mera5timeritin5art6ti4nit6t5inne4t3insttion9s6ti5s6an4tis4ei4tisers4tiskan4tiskiltis5kok6tisprå4tistattis4ti_tis4tilti5streti8støytiva9reti9ært_tjen6sttjæ4restka8ra_tku6le_tla8te_tle6da_tle8se_tlight5tli6nestli4te_tlø4pa_tma8ge_tmin5s6tmå4la_t7neligtne4rektne4r5øtne8se_to4derato2g3at6togravtolele75tolera1to4l3ktol4labtol4lagtol6legto5miseto7misttong5s4ton5s4ltor5alttor5angto4r3astor8da_tor7eks6torenttor5etetor5inttorvei5to5verdtove7ret5overstra8ka_trak7to3t6ranstra5se_tra5sest5rate_tre4al_4t3redstre5int3t6reni4t3renntren6skt4re3rutre5skot4ri5ne4t5ring4t3rom_5t4rongtro5per5t6rosk2t1run9tru5sa_7t6rusktryg5ge7trykk_5trykketry7pe_5trøye5trøy9ettrå8da_4trådett6sch5kts4endet5senditsen8kat4sentut4s3erkts5e6sttse4te_t7s8hopt4s3inst6skollts5krent6s7kynt7s6lo_t3s4lott4s5o4dt5somstt3s4port4s3talt5standt5stangt4stilkts5torsts5treet4s5trots6trålts5øknitsøy8ertta4la_t6t3aldtta7lelt4t3anat5t6anet4t3angtt5appet7t8ar_tt5ar5ttt6artat5tede_tt7elevtte4ma_ttem8nat5tene_t9tens_t4tereitter5untte4r5øt4tideltti4g5jt4t3inst6tistitton6natt5o4ritt9rakatt5raket4t3reptts5kantts5toptts5tratts5tøyttva8latt7øy6rtul5les5t4un5ntur7ant4tu4reitus7s6ttut5tortutt5ovtva6ne_t4v5anltve5deltvi8ka_5t4vil_5t4viletvi4sa_tvi4se_tyg9geltyg5gestykk5s6ty4pere5tyranntyre5stty4ri5stær6enetæ4renht7ø4lettøn5nestø4r3astø7veletå5ket_tån6de_2t1års1u3a4ne_uble3s4udd4s5eude8areudei5eru6d5ettudover7uensar4u2ge5s4u5g4ladug9lar_ug9ler_ug3s4pruid5en_uid5ensukar5t4uker5anuke4rekukse7teuk4s3unuk4t3idukt9s6vukt4stiu5lere_u2l3erlu5lest_uli5ke_uli9na_ull7armull5eggul6lengul9lereull5i4vull5sleull3s6mul4t3reuma8ge_u4m3enhum4p7ut5undervun6d7imund5s4iu4n5engu2ne1s2un9g8ruung3s4iunn5erfunn5steun6sj5iun3stekunt5repun5øy6dupe6renu6r7arlureer6eu7r8ellu7r8eltu4r3elsu4r5engure7o6suri9en_uri9er_ur4ke5sur6k7jaurla8gaurnæ6reuro4staur6p9utursa8kaur4s3elurs5tilur6t5riurue7reu7sarenu6s7arkuse4al_u4s5ermuset8jeu2s3h4au2s3h4ou4s3kanuska8rau6s5kisus6k5leusk7u6tuso6l5du1s2pinuss5korus4skurus4s5tiu5s6tigust7onnust5o6vus8tra_us8tranus8trarust5renust5rødu6st5råu5svaleu5tandeu2ta1u4u5tekstute6ma_u2te1s6utfø5reutikk6uu6tivenutlø5seutlå7nautmå5leu5trengu5t6rul7uttak_5uttakeut4terkutt5evau3t4vilutvi5se3u4t6yduve6ris7v6aksi4v3aksjvak5s6tval9eksval4g3rvali9e8val6mes4v3analvang4s7van4nanvan4nivvan5semvar4meevar6temvas4sauvas4selvas6s7øva2terfvba4ne_vdu6en_ved5s4k3ve8d5tve6g5av5ve4ka_vek4t5rve4l5as5velat_5velatpvel4delvelses5velø8pave6neteven6n5ivennle7ven6stiven6strven5t6rver6desver6dinver6dir5vereig4verennve5res_4verett4veretuve4rialver6nalvern6s5ver5skiver7spo5verum_ver3øs4ve5stedveså5re8vetaka9vetokevett5skvevi8savfø7re_vga4le_vga8ve_vhø4re_vide4o7vi4d5o4vi2k3o6vik5s6lvi4k5ø4vi4les4vi4l3invil4ledvil4leivill9ep6v5illuvil4stivil4trivine5stvin8g9uvin4ned4v5innl4v5innsvin7sjavin4tesvin5trevis5andvi6sengvisk6revi5tese5vi6t5jvit5skrvi4t5unvje4t5avje5t6evje4t5rvku4le_vle4se_vle5strvma8le_vmo8de_vna8ke_vne5r6ev4nestav6nestevn4s5pavnæ4re_vof8fanvo4lituvol4tesvor8da_6vrenge4vrengiv6rengjv6rengtvrett4sv6rigasvri6ma_vri8me_vri6ve_vro8te_vrå8da_v4s5engv5s4ensv6s5kumvsmå8lavs5oms4vsø6ke_vsøy4ervta8ka_vta6ledvta9lenvta4levvti8ne_vuden5tvun4ge_vvi6k7lvvi4se_vøm4metvør8na_vå4kenewalk5o4wester6yak6te_yba4ne_ybue7reybu7ernyd6delay6d7enhyel4s5jyel6s5tyfjell4yga8ve_y6geretygg7arty5keleny4kerely5kjareyk4kanayk5kesjykk4s5kyk6lestyku6le_yl4derkyld5s6kyle6ge_ylke4s3yll5is_ylst7reym5jaray9n8andyns6areyn6teteyon5neny4penetype4relypin8nay4r3a6ly7rek7ky6rerely5rest_yre5steyrin5g6yri8ka_yrs7tanyrs5taryr5ut5ryråde7rys7ekteyse7ridy5sesteys6karays7kareys4s3eiys4s3ekys4s5ilyss5tabys4s5tiy8star_y4s3terys7teslys5t6ryy4t3anayt5e4gey4teretyte5r6øyt4s3enyt4testyve4riayve4risyvi6se_4z3ense4zi5s4væk9jer_æ6rarbeær4arteæ6r7eldære5ne_ære7nesæresa4mære6skræ4retekærmå8laær4s5ilær7s6noøbe6levød6s5ekød6sku6ød8t5omøglo8veøgn6s7pøg5res_øka8ve_ø6kerelø4ke5ruø5kjareø4le5teøl4geraøl4leseøl9letiøl4sereøl4se3søl4v3eiølv7erkøl4v3inøm4meroøm4metrøn4n5itønns5alønn4s3eønns5kuønst9raøps8legø2r1a2mø4r3antø9reletø4r5engø2re5o4ø6reretøre6s7vør4keriørla8gaør4nereør4nes4ø4r3ostør4r5isørsa8kaørs6levørs9tarørste5iørs5tigør6ti9aør4tideøsa6me_ø8sararøse4n5oøserie6øst9astøst9ettø2t5eksø5tela_øtså9reøt4teroøt6testøtt5eksøtt5etaøtt5eteøveren8øv6l7ut9øy8ansøy4dereøy7e4deøy5rer_øy5s4ar5øysundøy4tereøyte5s6øyti7daøy2t3y6åan8ka_åan6ke_åba8ne_åd3s4laåd3s4peåd6s7teå3e6re_å4k3enhåklist7å5l6ampål5einiå4l5enhåle6riså2le1s2ålla6gaålsy8naålul8laålå8te_åpe4n3aåpe4n5iård5strås9keneåta5le_åta5lenå4t5armåte6ke_5åtferdåtva5raåtva7reåun8ge_åvæ4re_",
  4
  "_aa4_ai2_a6k_a6l_a6n_a6s_bl4_bæ2_ds4_ei2_ex4_gl6_gø2_ik2_i3ø_ji4_ks6_og4_om1_ph2_ps2_sk4_sn4_st6_sv8_sz6_sæ2_th2_tr6_ts2_u1i_u2n_u1o_u1p_u2t_vy4_xe2_ye4_ys4_yv6_zj8_øi5_øs2_å6e_å6f_å6g_å8l_å8m_å4t_å6va1ad4aafaa4gaa2ma1apaa2sa1ava5bhab1lab1raca5ack3a1co6ada1adgad1j2adl1admad5n1adv4aeaa4eda3ep6afa6afcaf4i6afo4agaa4gé4agoa5hiah4vai5øa7jea4jéa4jia6jl6ak_a1ka2akd2ake6akn2akva5kå2ale4alnalp22alsa1lå2amia2moam1s2anu6any2anøan7åao9aaog9a2oiao2pao4ra7péa1piap1j8apua1pyap7øa1ra1arba1re6arf2arsa1rya1rå6as_a1scas2has1la1soa1suas5å4at_a4té4ati2atsa1tuat5va1tya1tø4au_au3cau5i2auxa1va1avd1avg6avna1voav1r1avt2avua1waa5wea1wiay2aa5zua7å61b4aba3aba2d4bafba2k6bavba5z2b1bb3bab3bib4bøb6bå2b1d2beeb4efbe3gbe6i2bepb4er6beå2b5fbhu11b4ibi1dbi5gbio74bipb5khb5ljb6lu2b1mb7ni2boh2bojb4olboo61botbo6yb7plb2ro1bryb4rø6b1sbs4ebsk4b2smbså56b5t1b2u4bubbu1ibu1p4buv6buø2b1v4b5wbya23byiby5nby1s2byv1b4øbø4ebøf3bø2nbø1v1b4åbå6e1c4acab4ca4eca1tc1cicde6ce3dce1i1cel1cer2ch_2chb2chm4chn2chp8chs6chtch1vci1c3cidci2e2c6kck1ick1kck7rcku6cly4coa62cod6cof6cogco2mco2o2corc1pr5cru4c4s4c1tc6tacty54cu_2curcu6tcy2acys34daa2dafda1i2dap2dav4daø4d1c6d1dddø22deade7bde1c2dee2def2deg2deh2dei2dejd2erde1s2deu2dev2dey4deø2deå2d1fd5gid3go2d1h2dib4dih4dii2dij2dipd1jad1jodki6d5kjd3lad5lid5lod5lå2d1m8d1ndn6a2dof2dop2dov4doø2druds1lds1pdst4ds1v4d1td3tidt6jd7todtø8dtå4du1c3dug7duo3durdu1s2d1vd7vo2d1wdy9a2dyf2dyldy2t8dz_4dø_2døkd2ør2døsdøt31dåd1dåpe1ade1afe1ane1ape1are1aue1aveb3heb5se4caec4ce1cee8dée1dredæ4e3e2eea7ee3be2edee4n4efa4efi2efle2fn8efre8ft6efue3fæ4efø2ega6egm4egoeg2re1gø4egåei4cei7e4eii4eil4eime4ip2eir2eise1ki2ekke1kl4ekne1kue5kye3kæe1køe1kå2eliel1jelk2el5n2elæ2elø4em_6emd8emee5my6emø2ena4enb2eno2enp2enu4enw4enåe3o6eo3aeo5de2oke2oleo2peo1s2e1pep2l4erbe1ree8ré2erg2erhe1ri2ern2ero2erp2err2erue1ræ2es_e1sa2esee1sue1taet1c2ete4eté4eth2eti6etlet5m2etnets14etz4etæe1tøe1tåeu4ae8ufeu4heu2leum2e2ure2use2vjev1se2vøew3aey5ke1yre3zie1zue1æ2eær3e1ø4eøy4e1å6eåk4é5e8é2rjése2ê6raê1reêr7ofac8fa4ffai55fal2fap3far2f1b2f1d3fe_2fec2fef8fej2feo2feu2fev2feø2feå1férf2fjf2fof3fæf4fø2f1hfie2fi4ff6ig4fihfi2rf5juf2l21flof6lu3fly1flå2f1m2fo_2foe4fof3fonf1op1fra2f1sfs2hfsi2f2slf4smf2snfs2tf1taft5lft7nft3rft1u4f1vfyr2fy3s2fæ1fø1f2føkf8ør6gah6gakg2at2gaw4gaø2g1b2g1c8g1d2gebged42gee2gef2geh2gei2gejg2en2geo2gepg2erg6es2geug2ev2gey4geæ2geø2geå2g1f4g1gg2glg4gn2g1hghæ83gi_2gibgi8c2gidgi1e2gih2gii2gip2giugl2agl6e4gljgl5lgls42g1mg5még3mugn1dgn4egn5rgn1sg2nå2gob2gof6goi2gok2gom4gov1gr48gr_8gs1gsa2g2sigsu2g2søgså42g1tg3tag3tigt5t6gug7gum2g1v6g1w7gymgyr6g5æt4gåmgå2sha4a4haeha2ghai1h4au2h1b2he_he2ahe2ihe2khet2h5huhje42h1mh2nahn1shob6hoi5ho4oho4shou2ho1v2howh1rah1re6h1sh1trht5thvo2hya3hyd4hy2ehys3hæ5ghø4ehøf5hø2ghøk6hø2shå7aia1ti1avi1b2i5boib4rib8ti1ciick1i1coi5cy2idai8dji2dyi3døid7åi2edie1ii1eni1etieu2i8fti3føig3di6ghig1li5ini1kii1kjik1li1koik1ri1kuik1vi1kyi3køi3kåi1lai1léi1ly8im_4imai8méi7mjim5mimp24imu2in_6ina4ine8iné2inkin5l2inoin1s6inu1inv6inøi2obio1iiol4i1pii1pli1pri3pøi1rai1reir7gi1riirt6i1rui1røi1råi1sa8iséis1lis1p6isuis1vis7wi1tai1téit2ii1toi1tri1tui1tøiu6aiu2biu2niu8pi2uri1vei1véi1viiv3ni1voiv3riv7yi9væi1waiwi5i4zei1zoi4øsi1øyi1å41jaeja4j1jaz2jeb2jef2jehje1i4jej2jel2jem2jep6jeø4ji_6jik4jiø2j1k6j1l6j1m6j1n6jn_j5ni1job5jocjon24jop2jos1jou4j1r1jubju2l8jup1jusju1å1jø_1jøejø1f4jøl1ka_2kaa2kag2kah1kam1kas2kav9kayk5ce2k1d2keb4kecked44kefke5h2kei2kej2kek2kem2keo4kep2kev6keæ2keø2keå1ké4két52k1fk5fik3gek5ghkgu44k1hkh6m2kifkio42kip1kir4kiuk6ivk1kak1kikk5kk4knkk7skk1v6kl_k2læ2k3mkn5fk2nøko3e2koi2koj1komk6on1kos4koø4koå6k1pk2rok1sak1scks1lksmåk1sok8srkss6k1suks1vks5wks1å6k1tku2a2kud6kuf6kug1kunku4o1kup1kus1kvok2vuk1våk7wek5wuky5a4kyf2kyg1kyr2kyt1kø_1køek1ønkøs41la_2laala1b1lae2laf2lal2lao2lav1lawl5bel5bå2l1cl9déldø22lea2leblec42lee2leh2lej2leo2leplex14leø2leå5lée1lér4l1fl5felf3flg5glg5nl1gælg5ø8l1hl5hjli1a3lif3lig4lih2lip7liul5jél1jiljø36l1kl3kalk4elk2llkå12l1lll1jll5mll5p2l1mlm7blm5llm5mlm1slm3t2l1nl3nel7ny2lob1log4loh2lop1lov2l1pl7palp2hlp2ilp2l8l1sl4sfl2shl2sll2sml2su2l1tlt9blt9nlt2rl3ty2lublu5c1luflui61lujl4umlu6oluth1luvl1val9vél1vilv1jlv1åly1a2lybly5ely5l2lyo1læ16læd2løt2låilå2n2låp2lår2maa2mab2maom6at2mau2mav2m1bm6com3de2meb2mecme7e2mef4meh2mejm2el2mem2mep2mev2meø2meå2m1f2m1hmi1ami6c2mih2mii4mij2mim2mip2miv2mjem1ji8mjo1mjø4m3lm7laml6im3mémm5nm3mummø22m1n3moa3moe4moh2mopmo5w8m1pmp1smpø5m1scm2smm1soms1vms1å2m1tm3tamt4bm5tomt4rmtå5mu6amu2e2mugmu2k7mumm2us2mut2m1vmy5amys3mø6emø2o7møt2møy2må_må5amå1km6ål2mår8naf6nah2nakna7on5can1dénd5knd7v2nea2neb2nef2neg6neh2nei2nej2nek3nen2neo2nep2neu2neø4neå4néb4néd2néf6néh2nél4ném6néo2nép5nér4név4néå4n1fngd4ng1lng7nn1gø2nih8nij4nirn4it6niå4n1jn1kan1kin5kjn3kon1krn1kun1kvn9kyn1køn1kå4n1ln5len3ljn7lå4n3mnn9rnn1å2nob3noe2nof2nok2noo2nop4nouno1vn5pen9ran3renry6n2shn1su6n1tnt9gnt5lnt5n4nu_2nugnuk5nuo26nup2nut6n1vn5vin3vu2nyd4nyg2nyn4nyo4nypny1s2nyv4nyø1næ12nøe4nøfnøy11nådnå8j1nålnå2soa5co1afoa4ko1auob4e2obr2obu2obyo5bøo3båo5cy2o1dod4eo4dj6o1eoe6foe2loe2no2es2ofao1fé2ofio1fl2ofo6oft2ofyog5øohø4oia4oi5ko1imoi6ro1is4o1jo1kao1kj4okl2okno3koo1kro1kuo3kå8ol_2old2oleo1lé2oliol9no1luo1lyo1lå2om_2omaomb62ome8omhom1j2omm2omoomp21omromt26omyo5måon5bon7fon3jon1koo5s2op_2opa4opho1pi2opl4or_4orb4orc8ore2orfo1ri6orl4oro4orr2ors2ortor1u4ory2orøo1saos2lo2sno3soos1vo1tao1tjo1too1tro1tuo1tyo1tøot7åoub8ou4r6ovh2ovj4ovoowa8ow5ho1zao3zyô6raô2reô1rió9saò9re4paa2pac2paj2pamp6aspa1t2pavpce6pdø22pea4pebpec3pee62pef2peg2peh2pej2pekp6el2pem2peo2peppe2u2pev4peø4peå3pér2p1fp3fop5fr2p1h4pib2pid2pif2pih6pii2pim1pit2piu4piø8pl_p2lip1lyp1lå2p3mpo9apod82pofpog64poh2pom4poupow4p1pipp1jpp3kpp1lpp5npp5ppp1rpp1sp2pup6på4pr_6pru4pråp1scp2shp2smp2snps1opst2ps1vps5wps1å2p1tp3tep5ti5pucpu2k5pum2pur2p1vpy8o6pys4p5z5påb1pålp5ånpå1r1pås1påv1que2rao2rav4raw2raør5bør8dérd7mrd3nrd5t1re_2reb2ree2reh2rej2rem1rer2reu3rew2reå2r1frft2r9fæ2r1gr2gn2r1hr7hu2rib2rih2rii2rij2rip4riå2r1kr3kir8ks2r1lr3ljrl6or3ly2r1mrm3brm7pr3narn3drn3nrnu41roc1roi2r1pr5parp6jrp2lr3pu2r1rrr3drr6er3rirr5v6rs_r1sar1scr1sor1spr1svr1sz6r1tr4thrt2r4rukr4umru2rr4us2r1vrv4arv2jr3vr4r1w2ryrræ8v2rø_6røb2rølrø6m1rør2rå_rå7a4råb2råf4rål2råprå1s2saa1sas1sat4sca1sce2seb4sec2sef2seh2sejs2el2sep2sev2seø2seå2séa6séb4sée4séf4séj4sék2sél4séo6sép9sér4sés2sév2s1f6sfes5fo3sfæ4sh_6she4shj6shs2shus5høs7hå3sig4sih3siks2ils2is2sj_2sjb6sjd2sjf2sjg2sjk2sjl2sjm2sjn2sjp2sjr2sjs6sk_1ska4skb6skd2ske2skf2skh1ski2skm2skn2skv1sky6skæ1skå1slus1ly2snæ1sod5soe6soh3son1sos4sou2sov4sp_1spisp6o8s9rs5ro4s1ss2shs2sls2smss2ts6så6st_st7c2std2stg2stk2stl2stm2stp2stv1sty1stø1stå4su_1suesu2fsu2hsu2ksu4o1sus7suv6sv_s3vrsy4c5syes4yms2ynsæ2l4sø_sø2d4søfsøg44søjs4øp7søt2søv5sågså2pså2rså2s9såvta1ata1c4tadt8ae8tah1tau2tavt1cet5co2t3d4teb2ted2tef4teh2tej2tem2tept4es2teu2tev2teø2teå4téa2téb2téf2téh2téi2tém6t1ft7fo2t1h3thr2tib3tid2tih2tii2tijt4il2tir2tit4tiy2tiå2tjo2tjø4tjå2t1m8t1nt3nat5ni4toc1toe2tof2toh4tojt6ok1tonto1s2tov5tow4toøt7pa8tr_t6ræ6ts_t1scts3fts1lts1ots1vts1wts1åt1tat1tét4tht6tst5twttæ6tu2k2t1vtv4a1tyd6tyh1tyn1typty2st5zatæ5l4tøl4tøpt2ørtøs44tøt2tøvt4øytå2k4tåptå3stå2tua7gu1akua3tu1avub5hub1j2ubsu4båu1ciuck1ucu5ud1rud3tud5vu5eiu1elue7ou1eru1etu1flu1frufø6u4glugo1ui8aui2du4ilu1imu7jå4uk_u7kiu1kj4ukku1ko2uksu1ku6ul_u1lau1léul1ju1lo4ult1uly2uma2umb4umc4umd2ume2umh2umi2umk4uml4ummum3n4umo2ump4umrums1umå72un_un6i4unk4unsunu6u3nyu3nøu3nåuo9au1obu1omu1opu1ov6upfu3pi4upr6ups6upt6upuu1påu1raur4curd4u1re2urfu1riurø24usaus1c2use4usgu2shus1lu4snus1pus1v6usæ1utb1utd1utf1utgut1j2utout1ru1tu1utv8utzut1øu7utu5viu5vu4ux1uy6au7ynu1ø6uøv54vabvaf32vap4vauva4z6v1dvd6rv7dø1ve_2veb2vec2vee2vef2veh2vej2vem1ven2vepv4esv4et2veu2veø2veå2v1fv9gevgo42v1h1via1vid4vim1virv1jav1jev1jivls92v1m2v1n6vob2vofvoi11vok1vol2vom1vosvo1v2vr8v1rev1rov1ruv7ryv1råv1skv1slvs1v2v1tvta18vuévu8k2vul2v1v2vy1vya4vø4lv5øv1våa1våev4åk1vånwa6l2wap1watwa3zwe7bwe3gwes2wet5w4i2wi3dwi5fwk3rwn5swob5wou6ws6kw1yoxga6x1icx1p6x1s2ya7b1yacya5fya4hy1akya2ly7amy1anyas4ya5ty1avybo2y8cé4yddydo4y1dry2duydø44y1ey2eky2emye2nyes2ye2ty2evygi2yg7myg6ry1kay2key1kiy1kjy1koy1kryk1sy1lay1lyym1sy3noyns1y1omyon4you4yp8ey1piy5poy1pry3puy1ray1riyr3my1ruyr3vy1ryy1says4eys6iy1soys2ty1suy1tay6tjy3to4ytty1tyy6uay8ueyu8gyu4ly1å2za5b3zaez1b4zbu4zea15zhaz3hiz5hu5zie1zis4z1l5zo_5zoe6zos4z1tzu3ez1unæ5byæ2bøæ5deæ7diæ3keæ5kiæ8kjæk6læ1laæl5jæ1re4ærfæ1ri4ærmær3nær5rær3væ2sjæ5ta4æteæt4ræ5vaæ5viøau4ø2bløb4rød3dø5djød1rø2duø4edø5epøfe8øf6jø5fnøg2aøgs2øi4eø4it6øk_ø1ki4økj2økk1økoø1krø7kyø1laøl3døledøl1jø1loø1lyø5mi4ønnøn2sønt1ø1piøp5pø1prø1raø1reø1riør1oør5vø1saø1scøs1lø1tuø5tyø1u2øv1røv1sø5vå2øyløy3o6øypøy1sø1ø2ø5å6å2arå1b46å1då7diåds14å1eåe2nå3eråfe6åg4råg5øå1kaå1kiå1kjåk1kå1koåku8å1laål3dål5jål1uå1lyå3niån5oå9nyåp2eå1piåp6jåp7på1prå4på2årnår2så1røå1saås3hå1slå5soå1spåsu4åså9å1taå5ti2åtnå1to6åtpåt1tåt1uå5tyåv4aå7vyå1ø8åøy4",
  6
  "_ab4ba_ab7be_ad1s2_af5t4_ak3kl_ak3kr_ak6ta_ak5tr_akva7_alfa3_al5gi_al5lo_al4na_als5o_alt4a_alt3o_am4s4_am6ta_ana3b_an3er_anes5_an3ge_ann4e_an5s8_ap1p6_arbi5_ari6a_ari8e_ar5ka_ar3ne_ar9ti_arvi6_as8ka_at4ki_at2o4_atte4_att6r_au8de_au8ga_au4ge_aus9k_au4sp_av7s6_ba6by_bi6en_bla4d_bo8da_bogs8_bo8la_bu4et_ca6se_co4st_da4ta_dau3s_de4so_di6er_di4sk_do4en_do4er_do8et_dome5_do4ra_du4er_duft3_duk3n_du4st_dø6r3_eb4ba_ed4da_ef4ta_ege5l_eg5si_eid5a_eik5a_ei3ni_eir9u_ei5te_eit9r_ekk4o_ek3li_ek3se_ek4sp_ek8ta_ek7to_els6a_els6t_em3b2_emfa9_end5r_en3ge_engs6_en6ka_en6sa_en5so_en3sp_ent4r_en3ø4_er4ke_es3ka_es4so_es5ta_es3te_es5ti_est3r_es7tu_et4na_ets4i_et6ti_ev8ja_fela9_fel5l_fe4ma_fe8me_fem5t_fer6s_fe8sl_fi4b5_fis6k_fjel4_fre6e_fy8se_ga4me_gel4e_ge3ne_gen5s_ge4st_ge9sv_gis7p_glo6i_glo9v_gly5s_ha6vi_hei5e_he4t5_hil4l_hu4di_hvit3_hø4re_hø4va_hå8er_i4her_ikke5_i3k6l_i4la__i3leg_i6les_il4ja_il6sk_in5ad_in5de_in3gr_in5k6_in4n3_io4na_i4rer_ir7k8_is7k6_is5pa_i5spe_is3s4_is5sk_is7ti_i6s5ø_i4van_i4vel_i6ven_ja4ne_je5re_je4ta_ju6la_jule3_ka5me_ka3na_kau9k_kier3_ki4na_ki7ni_kino3_kje4k_kle4s_ko7gr_ko4la_ko3le_kol5j_ko3pe_ku4le_kå6pa_la4ga_la3tr_la4va_la3ve_le8ar_le4er_le6et_lef3l_lemu9_le6o7_le7ta_le2u3_le3va_li4e4_liga3_lik3o_lik3s_li4ma_link6_li6ra_li4sa_li5ti_lo6na_lo6ri_lo6te_lo4va_lo3ve_lu4na_lu6pa_lyd3s_ly8ge_ly4sk_løv5i_lå8ma_lå5re_mag9r_ma3ka_ma4si_ma6st_ma8ta_me4d3_mek5l_me3ri_me4sk_mi6kj_mo5de_mo6er_mo4ta_mo4tr_mu8ga_my8ka_mål3o_nabo3_nan5s_na3tr_nei5e_ni8ar_ni6er_nig4l_ni8sa_nita9_ni4to_ni4va_no8ka_no8se_nød4d_obo5e_ok8ke_old3s_ol8la_om4me_om5s2_ond3s_on6kl_on6na_op5ar_op4pa_op4pe_op4pi_opp3l_or4da_or4dr_or5ga_or6va_ot3to_over3_ov8re_pe3do_pek5t_pep3r_pe4st_pi9ra_po4et_po3la_po2p1_pop3p_po8ra_po6st_på5d6_ra6et_ra4ka_raks7_ra4na_rap4s_ra7ti_re4al_ree6l_re6kn_ren4t_rep5s_res9s_rev9n_ri6ma_ro4an_ro8di_ro4mi_ro6pa_ro3pe_ro4sa_ro8va_ro3ve_ru8ka_run7g_ru4sk_røy7e_rå4en_sag6n_sau6e_sen7s_si6er_si4va_sje4i_skat4_ski6n_slim5_sma4s_smo9g_små9l_snø3k_so8de_son6a_spe6e_ste4i_stu8a_su4ri_su5te_sy3ti_sy6v5_sø8ka_sør3a_søye5_så3re_tak9r_tam5m_te7si_tid5r_ti4ki_ti4l5_tili6_tokk8_to3ro_to5t8_to6va_tra7c_tre3b_tre7p_tu6na_tve6n_två7g_ty8et_ty5ti_tøv9d_tåp9n_u4er__u6era_u4ere_uf8sa_u4ka__u4le__ule8k_u6let_u4lin_ul6ka_ul6te_und5r_u5nek_u9net_unn3s_u5raf_ur6an_ure4n_u2r2i_ur4ke_ur6na_ur8ta_u5rut_u4sa__u4sas_u3ska_us3se_us6t4_usy5r_uta4g_u3tak_u4ti__u5tol_u3trø_ut3t4_vei3s_ve4l3_vel5d_vel5l_ve4ly_ve8læ_ve4sl_ve4st_vete5_vide4_vin5n_vi5tr_væ4ra_vå4r3_vårs6_yn4kv_yr8ka_øg8la_øk6ta_øl3ed_øl3s6_øl3v6_ør4je_ør9sm_ør3st_ør8ta_øy6na_øy6ra_øy4re_åp6na_års3k_å3steaans9ta7antraa4ri6aa5t6hab9b8lab4butabi9erabi9laa4bistab4loka5bo9aa3boerabo3kla3borda4buela6buska4buteache3aad5anta4darta5denda3denea5der_a3desla3det_a3dets3adferad7oppa7doraad5rafad7ranad7relad5repad3retad3ridads5tead3stra4d5øyaf4fanaf4feiaffe3saf7fi_affi3daf5f4uafi5anafi7rea4fitiaf9la_af9lara4frikafra5saft5eiaf6t5oaft1s4afø5ria4ganfa4garta5gas_a7gersa5geruage5s2a4getaag5garag4gasagg1s2ag6gutag4lemagmo8eagn5omago5d8ag7ras4a3gruag4selag3semag6sjuag4skaags3tragu3ayagå8vaai3er_ai5ke_ai4s3kaisk2hais6omai5s4v1a2kadak3aksaka4o5ak6arba3kei5akel8ea4kerøake5smakes6pa8keteakhe6nak7indak5ke_ak3kenak4kesak5kimakk3olak4kulak4k5vak3levak6likak6lusak5om_ak1o2vak4pe6ak5regak3resak3ro_ak3roeak4sekak4ses3aksjeak2s1kak7skuaks5tiaks4trak4tabak4taiak4takak6tamak4tapak4tasak4tavak4tegak4tek7aktigak5titak6treakt3rå5aktueak3valal7adrala9gaa5lagmal3allal3anaa3landa5laneal3anlal3anvala5pra5lar_a3laraal3arka7larlal5arra5larsal3arta7larvala7tral5aukala4vaal4ba_albo4g5albumal7derald3rea9leg_a5lekea4leksa4lelial8en_a7lepta4leruale1s2ale7sea4leska4lesla6lesua4letaa4levaa4levi3alfabal3gebal4gåral3illa9lin_al3intal9ja_al3je_al3jeral4joral2j1ualk7s6al4lapal5leaal4lekal5let3alliaal4lidal6lulal6mekal4metal1o4bal3opeal7ordalori5al3oveal7sedals5løal6spuals4tealt6akal3tedalte4tal5undal5va_al4vedalve5salø5seal7å6tama5isa5makiam3aksam5alda3mar_a5maraa7mas_amaso7am4bar3ambasam4batam3eiea3meisam3eksami7naami7neamisk3am4madam4nedamo6veam4papamp5eiampes6am2p3lam4punams9utana3laanal4f3analya3nanea5nanganant8a6narban5artana3to6an7auanaus7an9av_3anbefan4dekan5denan9detan4dosan5eggane3rua5nes_a4nestane5sv3anfalan4gedan4gi_5angivang5ofan5gosang4sman4gunan4gå_a4nisjan4koban4kopan4kosan2k1rank3reank3ut8an2kvan5nenan5neran5nidan4nom5annonan4novann6slann3sta9noa_a7norma2no4vano5vaan3ove4ansan3ansatan4sekan4ses3ansikan4skian3skjan5skøan6sløans5oran1st61an1sv4ansvean3tedan4timan5toiant5s6an4tulanus7a3anven6anvina2n1æ2a6pinsapi6r5api7seap4pleap5pliap6priap5renap5retap3rinap3selapse4sap8s9lap4s5øa6p5utara9biar5aksarak5tar3alta4ramia4ransa4ranvar5augar7aukar7avh6arbeh4arben6arbetar7debard3re1a2rea4arearare3ina4relaar7emn3arenaa4renia6rerka4reroa6rerøa5res_ar3evnar7g6har5g6iariba9ar5idrar3innar3insar3intari3sear4kauar5kha3arkit3arkivar4klear6kodar4køyar4map5armbåarme7tar4nadar4nalaro6paar7ostar3ovear6pedar5reear3selar4sinar4sprars6trar4topart9raarts5øar4tyvar5u6rar5utbar5utnarve3sa6r5åta4saloas7augase5lea4senka7seola2se5sa6sesta4setea2se3ua7sis_asis5tas5joras3karask6etas5kisas5ko_as5koeas3koras3kotas7kraas3kulask5øyas4levas4lita2s5omas4panas7pisas9sa_as4sabas4salas4samas5se_as4sedas4sekas4sesassi3sas4sitas6s1kas2s3nas5so_asso9aas6s1pas2s3tas4stras2s1vas4sysas4søkas2s5åas6tabas5te_as3tedas4tegas4teka9stofa5stokast5ovas4troas9tuaasu9saasyn7das7øyea4tanga5tas_at5avhat7eddat5eidat3eigate3ina4tekaate7leat3emba4tenia4tenua5ter_at6e5u3atferat4ha_at8hasatili5atl9øy3atmosat4nelato5gra5tosea3to1vat5regat3renat3rera4trifat3rinat5rotat5røsat5røyat3serat7sjeat7skjat2s3øat6tatat4tidatti4sat3titatto6vatt3spatt3svat6tysatu5e4a5t6yvatør3satø9sea4t5øyat7åt8au9ar_au5da_au9detau4di_aue5reau3estau4galau4gasau4gel5aug2nau5ketauk5laau5kveau6lasau4lataul8laau9menau5raeaure5sau5retaur5s6auru4eaus9kjau6skrau5strau4sunau3ta_au7tarauto5vav3alvav3anga9var_av3art3avdela7veilave3ina4velaa4veleavens4a5ver_aver5davi4ar4a5vigavi9ke5avisaavis3tavlu9tav4nesav4resav5seg3avsniav1s2pavs4teav1s2vawe9neay9s8tba4bysba4da_ba7danba8de_ba4debba3karba3kenba3kerbake3sba8ki_bak6kobak5krbak4reba5kribak3robak3smbak5spbak7t6bal7akba4lesba4li_bal6læba4na_ba5nanba5narban9daba4nelba4nesbantu5bark5sbar5trba5senba4setba2s1kbassi4bas4sobas4stba7s8u2ba1trbat6tibau9lab6baseb4bedabb3eiebb5eigb6belob4bes6b6betab4betib6betob6betrbbi9e8bb7lenbb5rekbbu9rabb5ut_bb5utebe4bo_bebo9kbe4da_be9darbe3derbe4drebed2s1be1då3be4ga_be4gi_be4gå_be6ha_beha7gbehå4rbe2k3ibe4lekbeli9vbel5læbe2l1obe5nat4benedben5guben5spben5te4beraibe7rasbe4repber4gaberg3jberg3lberg3obe5ribbe7risber6klber5naber5nebe4ro_bero9aberri6ber5teber5tiberø5vb4e1s2be4se_be5s4i4besikbes5kebes7ne4be3sobeso9vbes7sibe4tab4beteibe7tesbe4ty_be6ve_bi6blabi5deebi6elebi5ervbik6kibi5k4l4bi7krbi6la_bi4lasbi4laubi3letbi4linbil5labil5m6bingo54b5intbi4ri5bis6hibis7kebis5sebi3s4vbi6ta_bi4te_bi5tesbi8ti_bi4trebi6tri1b2ladblad3abla6f3bla8gablak5rbla5meb4lankb4lantbleie5ble4mob6lesab4lestbli9kebli5mabli5meblis3sblo6drblom5mblues3blu9sably7glblå7sab7nes_boa5s4bob7labo6dinbo6d7rbo4et_2bo3f6bo4gelbo6kelbo6kop5bok1sboks4pbok3veboli7nbo7lo_bo5loibolst6bom1s4bo5napbon5nebo5nusbo4ra_bo6re_bo7relbo3renbo3retbo6ri_bor4ti3boskabos5sebo4stobo4ta_bo4takbo4talbo6te_2bo7to4bot6r4bot4vbra5kabrak5sbra5sebrei5ebrei3sbro9arbro1s4bru5kebru4nabru5plbru5sabrus4lbryn4sbrø5debrå9neb4s5elb2s1ofb6st7f4bu3embu4en_bu9enebu4er_bu4le_bul3lebun7debunk3rbunn3sbu6ra_bu4re_4bu3robu4se_busk7øbus6sjbus4snbus4spbus4stbuss3v4bustrbu4talbu7tem4butstby9areby7depby4en_by7eneby5ensby3ersby4ge_by6re_by4steby5tarby4te_bæ5rarbæ4re_bæ5renbø7ensbø4kesbø6la_bø6le_bø6re_bør4spbørs3tbørs3vbøy7arbøy4esbøy4etbå9desbå7enebå6regbå4repbå6t5jca4pe_ca2sa3ca6setcas5toca4to_ce4nedce4neece4nemce4netce4nevcen6toce1ro5cest3ocha5le3cham4cha7nechel5sche7techi4licho5s6cie2s5ck5ar_ck5artck3er_ck4ereck5et_cke8y5cmini4co6bidco4la_co4labco4lakco3r6aco4vercras4hcrack4creen7cures44daberdadør5da4gevda6go_da4g1rda6gunda8la_da4las6dalau4d5aldda4lesdal6soda4ma_da4manda3masda4me_da3mendame3sdam7pe6danal2d1anl4dannod4ans_dan3sa4dansv9dant_9danti4dareada4resdar5s64daseida9sko6dastrda4tek7d6atoda3toa4da5trdats6jdau5god3av5sdd3eied4demidder5sd4desud4d1redd5rundds5trd4d5øy6debar4debas3debat3debut6d7edd7dede_4dedek4dedel4dedia2ded4r3deig_d2e1inde5is_de3ist7de7itdekk3a6dekly5dekni4dekod4dekon4dekosdek6st6delad4delau4deledde4lef4delei4delid4delis4delivdel3sedel4sidel3tedel7tr6delukdel5ve6deløy2de5mademie4de4mo_de4mog5demok4demol5demosdem5pede7nakde5neb4dened6denel4denem4denet4denevde4nomdent3oden4trden6tå4deopp4de3orde4ove4depak4depapder8amder3av4derea4deredde4ref4dereg4derepde4rifde4ril5derinder5nede5rob4derog4derosdero4vder4spder5unde5rup6derus4derør3d6es_de5seg4desho9desk_5deske7despld4es2t5dest_de5sti4destj4desto4destu6desty6desup4detea6deteg4detel4deten4detepdetes74det6r3devikd7ev8ndhav4sdhu9gadi5algdia5lidia3redia7spdias6tdiats4did5ridi7elldi5en_diffe53difuldi4gat4digrudi8ka_di5kem2di1kr6dimed4dimes4dimet4d5imp2d1inddi7nendin3grdi4ni_4d1inndio3nadio4nodi3oridio5tr4dired4direg4d5irsdi6seddi4skjdis7kudis4vidi4tal4ditekditt3rdi9us_di4va_4divaldi7van4divekd7jes_dje9vedla4gad4ledid4legadle3ged5lekad4lerudli5kedlå9redmors6dodør54doled6dolisdol5l44domesdo5misdom8sadoms3ldom4sodo4na_4donkedon5stdon5t4do4pa_do4pe_d6o1rado5ran2d1orddor4dad5oriedo7ryedo4se_do4setdo3strdo5vendo4verd9rad_d5rade1d6rag3drakt3drap_5drapa3draped3rappd3rarbd5rarmd5rarr9drattd5reds9dreg_d3regj3dreied6rekad7rekk3drektd3ret_d3retnd6retrd3retsdrett43drevn3d2rif2d1rigd3rik_d3rike3drikkd9rikt5d4ril2d1rindring6drit5u1d2riv3dronndrop5s2d1ror3d4ros2d1rovdro5vadro3ve6d5rutdrykk4drø3ved3sabldsa9gad6salld9sameds1a6nds5aneds1a2rd4satfdsbø6nd2s1eids7eksds3elads3emid5sensds3e2pd7ser_d6serfds5erkds3etad5setjd3s2idd7sidads3idrds5indds3i4sdsi4veds7jords5kabds3kard4skatd5skotds3krods5la_ds5lands6lemdsli6kds6lo_ds4lukd4s5osd3spekd3speld9s8pyds3takds6tauds5teod3stord3stridsty8eds3tyvdsure6d5s6usdsy6nadt4engd5t4etd6trocd5t4rød6t1s2d3t2vadtørs3du9enedu9ensdu6ka_du4na_dun7de4d5unidun5s6du6ra_du6re_du6reidur8tadu5s4adu9semdu5s2idu6va_du4ve_dve6vady5ke_dy4na_dy4ne_dy3pesdy2p3rdy4ra_dyr5s4dy2r5udy6se_dyst7rdød2s1dø4pe_dø4pendø2st3dø3vel4d9øysdåd6s5då8na_då8ra_då8sa_då7semea2d1ieadli5e5alleea4love3altee3amanea4ne_ea4nore6ans_ean3slea5rerea5retea5r4iea2s1ieat6leea5trieau6gaeau6reeau8saeav8laeb4be_ebers6ebet5se5b6loebo4daebo6krebo6laebu6eteby4taed5ad_e5d4aged3arked3arved4dyred3eiee4dekse4denfeden5te6deprede4rae4derøe4deskede4slede4sme4desnede4tae5d6iaedi6gjedi3sied3reged3romed7skied3skredvi6sed5ynkeeg4gaeei7nieek4tee5e4lieem6naeen3ineer3ene4er3le6e5shees8kae4fanaef3anke4fark3effeke4f3idefo4noef6strefta5reft5eief5tereft1s4efyrs5efø5lee6galaegde8leg7dese5gedoegei9ee3gemeegen5se7geome2ges2ege5speg9genegi3ane4gikoegis4pe5g6løeg4neme7g8røegs4amegs4kiegs4taegå4vaehei9eeh5er_eh7erneher4sehø8vae9iaktei9a4nei7ar_e3ideae3ideoei9derei5dete6i2doei3d4uei9en_eier3aei4ertei6gevei6graei5kaaei3ke_ei6keeei6kehei4kelei4keteiks3aeik6seeik4soei9lede3illuei3lo_ei9loaeil5opei5loseil5s6ei7ma_e5imagei4medei6meiei7menei4met8e1impei5nedei7neleinga6ein3grein3k44e1innei4nomei4noveins6oei3numei2n3øeir9akei7renei5sarei3se_eise5iei3senei4sile3isk_e3iskeeis3koei4spiei4tekeit7taei3tveei6t7øei4vakeiva9rei9veneiv5s4eju6laekali7e5kavrek3eiee4keroek4kjøek5kokekko5vek6lege6klenek5letek9na_e3knekekne7sekni7peko7lee3k2rae7krefe3krene3k2rie3k4råek5rådek4sal3eksamek3sel3eksemek4sigek4skaeks5peek4staek3stiekst5oekst3åekt3avek3tefek5tesek4tidekti5mek5tivek4valek4vinek6vis3ekvivekå6paela4gael3agge2l1ake5lakeel7akte8lameel3anle4larre5las_e5laseel5atoel5avlel3avse4ledie4ledreleg5de7leire7leise5lekee5lem_e3lemme3lempele9naelens3e5lepa2e3lerele3ske4letae4leteel9ga_elg3s8el5la_el4ledel4legel5lerell7saell5skell5spell5svel5m4oe3lommel3omnel3omse2l1ore3lortel3ostel4petelro4sel4seiel3senel4sjeel6snoel4speel3sprel4stiel4stjels5økel5te_el6tegel4troe1lu2eel3ungel3utrelv3anel4vei5elvs_el5yndel9ærve6l5ætel3øy_el5øyael5øydemafo5e4magre4makoe4makue4manae6manue4maree4masie4mataema3ukema5ve3embed3embetemei9eeme4lie4mendem5e4vemi5niemi9saemle6sem5me_em5menem8mi_em4ne_em4nedem4nemem4pedem2p3lem6pliem4polem4posem4sesem4s1lem4sorem1st8ems4teem4tilemå4laemål4sem1å8ren3aldena5lien3allen5ande5nanee5nar_en8aree4narren3assen3avien4deken3delen3derend3stendø4ren5eggen3eieen5ekse3nekten5eng3energe4nesken7garen4gemen4gleeng5soeng5spen4guten4g5åen9nalen4nemenn4sjen3om_en4påsen4remen5sabens5afen4sekense3uen4simens4tiens4veensvi6ens3øken5ta_en4tapen5te_en4tecen4tegen4telen5tieen5tigen5tiken4treen6tul3entuse2n7ule4n5ure4nytae2n3øven5øyden6ås_e4o7loeom1s4eon4kleopp5reor4daeo4rideo4rikeo4rise6penoeper5repe4ste4petaepi7kr3episoe8plenep5ler3epletepo6et3epokeep6seme3p2syep6tine4raeler3afte4ra4ge2r1ake3rakeera5kleral3ue4ramaera4noer3apoe5rar_e4rarge4raske6rasoer6aste4ratrer5atter5aukerau8ser3av_er3avher5avle3ravner3avrer3avser8byler4deder4diserd4raerd8reerds3ter3d4ver3effer3efter3eider3eieere6kae9rem_e5remmer3emner8er_e5rerier3esse5ret_eret6here5toe7rets6erettergi3fer6glier4go_erg5spe4riade4riakerib3beri3ble4ricee5rid_e5ridne6rikner3inde3ringer3inner3inser3inte5ris_e4risaeri3see4risoe6risperi5søe4ritee4ritoer7ivo3erklæer4nader4neder6neeer3nober3obler3offer5okser3olyer5omkero5moer5onderono5e5rop_er1o2re5ror_e3rore3erosjer3oslero4taer4raeer4relers6aler3seper3skaers4laers4mier5sneer4svaers4veer5tiaer3tiberti4eer5tiler4topert3saerty6ee5rud3er1u2ker3unie3rup_er1u8rerure8er5ut_e5rutae3ruteer5utner9utoe4rutser7u6ve2r3yaer5økne4røkoer1ø4le4r5ønerø8raer3øyaerøy4nerå4daer5åkeer3å4le2r1åner3å4pes5arvesbi9ees5egees3eige4sekue3s2ene5ser_e5seree5seriese5s2e3seste4sesve5setje9setses6haresi6are5silies3illesi3stes3jore5skabes6kedes4keees4ker8eskiles4kjæes5k4ne5sko_es7koae3skotes3kvie6skyreskå7res4lekes4letes4lites4løkes4løves9na_es4nere2s3ode2s1ofes3okse3sommes3pases5pe_es3pole3spores3punes4sedes4seees4segesse7ies4seses4sjees4skress3omes4soses4spaes2s1ve7stades5taees3tape3states4teges4tekes4tel6estene3stifes4tige3stikes4tise4stive4stoge3stokest9rée3stråe5studes5tusestå6ses5viges3visesy4nae4s5ytes5øvies7øyeetafo7e6takoeta3laet5aldeta5leet3ambe6tande9tapae5tapeet8ar_et8areet5art1e2tate5tatoe3tattet5aune4teiee4tekaete5ruetes5ie4tesle5tet_e7tetse7tjeret6neveto4eret3orde5treee5trefe9tru_et5rumet4skuetsnæ4et4taket4talet8tapet5te_et6teiet6tiaet4tiletto5aett3reet3tuget4tur5e6tuietu6naet3uni2e3t2ve4t3vaetæ3raetå5reeug8laeu4ka_eu5keme4up5aeu6rateur8na3europevad6reva4lae4varbe6vatfe5vegg6evenneven5se4venye9ver_e5ves_e5vetae5vev_evin4sevis3tev7omse7vri_e2v3une5vyrkeybal4eyr6kaeøy9aneøy7eneån8daédø4r5é5n6etéva8laè2rek4ère3s2è4restfa6de_fa2g1afa5gerfage4tfag3skfa2g1ufakta3fal4sk4fa5mofa4na_7fan5dfanfa5fang4s2f3anlfan5s6fan5tifan3to9f8ar_fa4ra_fa4re_fa4resfa4ritfa4selfast3rfa3talfa4te_fav5ne2fe1a4fe5a6lfe3drafe7enefei5enfei5gefei4li9fein_7feine2fek4afe5lagfe5len6felikfel7læfel5okfel4tifem5akfem9nefe2m1øfend9r2fe3p2fe6ral4feramfe5rasfer6atfer5de4ferea4feregfe4rekfer6enferi6e2fe1ru2fe1skfe6ta_4fetapfe4te_4fetea4fetil2fet6rfett5j4fe4tyfe4venfe6øy_f4f3akf6fannf4farbffar6dffa7ref8f9auf2f3avf2fe3df4fetif4fetoff5evef4ficef9fienf4finnff5intffi5s4ff9legf2f3refi4as1fi9cenfigh9tfi7g6rfi7kenfik6kafik7safi4la_fi4ne_fi5nerfing3rfi4n3ofi9norfi6ra_fi5s4afi6se_fi8si_fi6ska6fiskufis5ti6fistufitt5sfi4ve_fje4skfje2t3fjære5f5lag_f6laggfla7kefle4slf4lettfli7neflis7tflo9gaflok9sflo2m3flue3sfly3s4flå9saflå7sefoi7lafo8ke_fo6la_fol4drfo4le_fo5ledfol5lifo4ninfon1s2fo6re_for9eifor4etfor9g6for3sefors8tfors4vfor7v6for5æ4for5ø4fo6te_fo4tokfo4tomfo6topfo4torfots6vfra6mifra7r8fra7skfras6pfre4e3fre4m5frems4fre7nefre6skfro8stfrø7kofråve4f5sjukfs7ne8ft3algf2t1amf4tanaf7taneft3anlf5tar_ft8as4f6t1avfte4naften3dfter5sf4testf4tetaft3indf2t1o2fts3eift2s1ift3stoft5støfu8ga_fulle6funns3fu6ra_fu6re_fu9retfu7selfus6o7fu4s5tfva8lafy8ra_fy4re_fy8sa_fø4da_fø4dekfø5denfø4desfø4le_fø5rarfø4re_fø4resfå7renfå7retga4ded4g5adrga4e5k6gaflogak8tega4la_galei5ga7len4galli5ga7loga4ma_ga5mer6gand_4gan5k2g1anl4gansa4gansvga6pa_ga4pe_ga4p5lgap3s2ga6p7uga6raf5garbr5garby7gare_4gareagar5es4garkigar3neg5arteg3artigar4unga4rylga5s2iga6skigass3lgas5tega5stoga4te_gate5s2g1avsgd5altg6d5aug3debag4dedigde5log4dendg2de5og4derag6derog3det_g6d1øyge4ark4ge5be3gebri4gebrå3gebyr4gedan6gedelgedia54gedos2ge1g2g3e2gng4e1ingei4r3gei9regeit3ageit3oge4lar4gelauge6le_ge7lea4geled4gelei4gelek5gelet4gelid4gelit6gelivge5lov7gels4gel3segel5sigel5t4ge5lungel7ve9gema_4g5emngem6nage2n1age3nea4genemge5nesgene4t4genevgen5gr6genivgens5lgen5tr4genumgeome5ge9opege5ra_ge6ralge9rasger5di4gered4geref4gereg4gerek4gerep4gerikge4rimge4risge4ritge4rivgerne64geroa5gerudge5rup4gesje2ge1skgeslu7ges4lø4gespege4spr2ge1st3gest_6gestå2ge1såge5tak4ge3te5gete_5get5sgety8e4gevir4g5evn4ge5vog6g5algg5askg2g1avg4gedig4gelag4geleg4genug4gerøgges6bgges5lg4gesmg6gesog4gespggje5sg2g1o2gg3radgg5ratgg8re_gg3redgg7rekgg3stog7g8ud4giarbgi9endgi6ga_gi5k4r2g1indgi4nin2g1inngin5nu4g1ins4g1int4gi5om2gi1opgip5sigi4re_gi6rob4gisel4gisen6giskagis8lugis4løgis5ti4gistu6gisty4gi5tegite4sgi2t9rgit5te4gival2g1jakg5jarn4g3jeggjels46gjentgje7sk7g6jutgjø9degla3degla4gag3landgl5artglar7v1g2las7glaseg6lass6glastgle3geg7lek_g5leke3glemtg9len_g9lensgle9plgle4rag9les_1g2lidgli8er3g2limgli9meglitt46g7liv1g4lorgl5ungglø8pagl7øy_5gløymg4meteg4metrgmini6gmå6lagna4logndør5g4nelog6nerog6nerøgne1s4g4neskg4nestg6netrgning4gni6stgn5o6pgn7o6vgn4skrgn4somgns4prgn4stign2s1vgnu5regnæ6re7goar_go5dalgod5argo4de_gods9tgo5ge_go9g8rgol6fagol4vag7o6mago9ne_go5nokgo5ra_go7raego7rasgor6dagor8vago8ve_go8vi_gra5ce9gradsgraf5fgra4m5gra6skgras3tgre4eng7refeg4rega2g5relg5rent4grepig7rese4grett4g5ri_4g1riggro9arg4ro7igrom5mgro5skgro3ve4g5rui4g3rulgrun7g5g4rupgru7sagrus5t2g1rut4g5ryg6g5rør4g5røvgrø5vegr7øy_grå6dag7sal_g7salegs3ambgs7amng5sardg7sastgsbø6ng5sekrg7sekvg5sensg3sentg5ser_g3serigse4stg3setegs3etig9setsgs4ettgs4jarg3sjefgs4ka_g5skadgs4kalg6skamg4skangs7kavg7s4kjg3skotg7skugg4slukgs4lung5slyngs5medg7snelgs9opeg5spalg3spelgs5pikg3spilg3spurgsse4egs5takgs5te_g3stifgs5tiåg5sto_gs4tolg3strøg5stuegst5utgs4tørg5s4tågs5vikgsy6nagsø6kig4t5ifgt6re_gtvek8guds3tg5ug6lgu4le_4g5ulkgul4lagur8nagu5ruagu3rueg5ute_4guttrgva8lagvi8tagy4da_gy8sa_gy6se_gy4te_gy4ve_gøye6rgå6en_gå4er_4g5å4kgån8da2g1å4p2g3åregå9vengå4vetha4ga_ha3genha7ismha4ke_ha5kenha6la_ha4le_ha4levhal6løhal4sohal4v5ha8me_ham4sthand5øha4ne_hanis4han2n3han4nehan3sehan4skha4re_ha5reiha4relha3remha4resha5rovhar7sehasj5eha3tarha4te_hat6lehau6stha4va_ha4ve_ha4vegha4veihave3shav4slha6vu6he7ansheat4rhe4de_he2d9rhef9tahe4ge_he2g3rhei5enhe3inshei4skheit4she4la_he4le_hel2s2hel3sahel3skhel5sphel3svhel9vehe4makhem5nehen5o6hen1s2hen5sehe5rethe4ri_4her5nhe4ro_hero9aher6svhe2r3øhe4se_hes7pahe6støhe4te_he5t6ihe6va_he4ve_hi4bakhi6ge_hi9se_hi3senhi5s4ihi4t5rhit5tihi8va_hi4ve_hjem7ehju6l7ho5ar_ho4de_ho5denhode3rhof4f3hof4fiho5lagho5lanho4le_ho4linho4lomhol7utho4me_ho4mo_ho4modho4mosho5n6oho8pa_ho4pe_ho8pi_ho6ra_hor2e1ho5senho5serho5si5hri5nehri2s3htere4hud5s6hu6et_hu4ge_hu8ja_hu6ka_huk8rahu4le_hu4leghu5leshu4levhun2n3hu1ru4hu8sa_hu4se_hu2s1ihu2s5jhu2s1khus5s4hu8strhu6styhu4ve_hu4veshva5lehver3ah4v4irhvits4hy6la_hy4le_hy4se_hy2s1jhærfø9hær3s6høg3rihøg7røhø6le_hø4ne_hø5rarhø5renhø5rerhø4reshør6sphøst7ahøst5øhøy5a6hå6na_hå5nelhå6pa_hå4pe_hå4p5lhå8va_hå4ve_i2a3deia5d8riale4tia4linial3opia6lovi5als_ials4ti3alt_ia4nalia5nari7andria8nesia7netia2no1ian3saian3sliar4doiar4dui5areai5arn_i9arnsias3s6i3assii7ast_i3bereibe4roib7lari2b3leib4legice5neid3delid6dep3ideali7dekii9del_id3elvi5dendideo3vi7derni5dersi6desmid6gemid4gesidi4en1i2dioid7jer1i4dolid9ranid5regid5samid6selid5simi2d1uni6d7øyi5einiie5l6ai5elemie4levi8e9maiem7b8i2e5niien4skie4ranie6re_ie5regi6eretie4rilie4risie4rivie7ro_ier4raier4spiers3vie3runies4tii8es6vi3etatiet4reie7vedife4s1if4lesiform4if4talifte5sig3anni7garkig4artiga3ruiga7teig3atti6gediige6noi5gersi4gerøi4gespig5ettig4gedigges4ig4graigg9s2i2g1iaigion4ig5loaig5neuigo5frigo4noi2g1røig3rådigrå5tigs4alig5seligs4muigs4taig4steihu9laikan9di4kapoi5kar_i5karaika5rei6kasaika3spi5keliike5lui5ken_i4kenai5kenei9kensi3ker_i4keraike5riike3sii6keski5kesoike5sui5ket_i5ketsiki9neik5inniki5stik4kafik4kapik4kasik4katik3kjøikk3reikk5svi9koariko5dei2ko3fi4koreik4rakik5remik3rosik4sekik7sotiks5tiiks5toik8stuik4tavik4tegik2t1rik4vinikå8pail5adri2l3aki4lanail6andi4larkil3artil5assil4dakild3reilea9ri3le7ei2l1eii6leigi4lenoi4leroi4lesei4lestile4tuili9gai2l1imi7linei4linsil3ja_il5keril4kesil4labil6lamil6lapil9lauil4leeil4levill3s2i9loloil5omvil3oppi5losoilot3ui4loveilret4ilsla7ils4muil5stril3s2vil6t7åil7ul8ilve8dilve4ri4maeni4makoimal8ni5mar_i4matri2me1gi6meluim5enhi9met_i4metai4metiimi9laimini6im4levim8l9uim5ordim7o6vimpse8im4refim4rekim4resims3krim1s4tim6stiin5aggi5nakki4na2min3amei9nanein5annin5appi5nar_i5narsi4naski4naspin7aukin5avlin5avrin7der6indigin4dogind9rain3druindr5øind5skind3spinedy6in5eggin5eidin3eiei6neleine4liin7engine8pai7nerni5nerti5nes_i4neski4nesø3infekin4fosin4fotin4gavin6gemin3gevin4goain4gosingst8ings5vin2g5øi4ninni4nisaini3sei4nito5injekin5kelin4kokin4nalin4nem4innet3innho2inni4in4ni_inn1s46inns_3innsainn5sein2nø4i5noarin7oksin9sa_in7salin5sarin5se_in4sekin3seninsis5in4sjain3sjeins4kiin3skjins6køin3sloin3sopin4spains4poin6ståin7sul6in3sy2in3ta4inte_in5ter4in5tiin7ut_6invevion3g4io4ninio5ra_ior8daio4rieiosk3vio3t4eio4traipela9i7pe6pipi9neipp4søip7punipse4lipsfø5ip2s1kip6tarir5arki9rastira6trir3eiei3repoire7sti8retoir3indir3innir5ka_ir4katir4kleir4magir4malir5oppir7skoir3s4tir5u4kir7å6li4saksi4sanbis3annis3antis5aud3isbryis6ceni4seeli4seenis3eieis5eigise5isi3sektise5nei4senoi5ser_i5sersis5essi4sete3ishavis5ildisis5tis7junis9ka_is3kalis3karis5ke_is8keeis4kelis3kjei3skjoisk3loisko5gis3kopis3kotis4kulis4kviisl7uti5smakis4medismo5ei6smus6isold5isomois5omriso3paiso5peiso7pris4panis6pisis7pruis4sesissis5is4skois7skris5skyis4skåis5sokis7stois6sveis5svois4søki5stabis5tapis5te_is4tekist6enis4tikis5tisis3tokis3tolis3tryis3tusis4vakisy8nai2s1økita4loita4lyi6tangi7tekyi4teniite3rei4teroi2te1si4tiesiti5mei4tisai4tisii4tisji4tistitivs5it7jerit5ordi4tra_i6traeit3relit3renit5rimit3rini5trisit3serit6sesit5skuit6stiit3sunit4tagit6takit4talit6tapit5tedit4tidit4tilit6tofit7tonitt4søit7tysiu2m1ii6umsei4umsui4vanai4varbivat3tive6geiv7eigive4raiver5di4veski6vesvi6vetøiv5insiv5is_iv5isbiv4sali2v3univ7åpni5wie6iårs7lja4ga_ja7garja4ge_jak4koja1k8rja8krejaktel6jambijan4grja6ra_ja9rekjar5tajar7tija8skija5sti2je1a2je4debjef4sajeg5geje5i8sje4klijekt3aje4lesjel7gejel4lojel4trjel9utje4miaje4mitjem5pljem5se2je7na4jendrje3ne_4jenet2je5o4je3rafjerd6sje3r6e4jered6jereg6jereije5rikje6rimjer4kvjerle7jer6muje6ronjer4spjert5s4je1ru2je3spje3str5jesutje5svejett3oje4t3vjety8e4jev6aje6vasjevi4sjev7ne2j3infjo4da_jo6datjo6disjol5t6jons5ajonse4jons3pjons5tjonsu4jord3rjord5sjor6dujo4riejort6ajo3r4ujo4sesju8areju7doejue7nijug9leju3ke_ju3kenju3la_ju5larju5lasju4li_ju6lidju4likjun7gej6u6niju7ras3jurisju5so5ju6va_ju6vakjy8de_jæ5le_jæ3ra_jæ9ranjæ7te_4jøend4jøeng4jøetajø4lesjøn5nejør4spjørs5vjør7utjø4sesjø3te_jøte4tjøtte4jø4veljå5ar_jå9ge_jå6la_jå4le_jå7lesjå5let6kabes4ka1brka5delkadi7ekaf5tak5a4gika5iskka5ismka4ka_ka4ke_ka4kedka4kelka4keska4ki_ka4kiska3lamka3lanka3laskald5s5kaldt3kalenka5lev5kalis5kalkykal7lakall4ska6ma_ka8me_kam4prka8na_4kandaka5nerka5nin2k1anl4k1anmk3annoka4no_ka8nom4kansa6kansi3kansl5kapadka4pak3kapas4kapen3kapitkap3re4karab4karamkaran5ka3rav4kareaka6rekka5relka4ri_ka6ridka3rolkar3omkarp3s3karri7karsjkars4tkar5tika3sekkas5evkas2ju6kasjøkas3kakasko5ka4spikas4soka3ted3kategka3tetkat5taka4t5yk7au4rka7vesk9avis2ke1a84kebuk4kedag4kedal6kedei4kedem4kedes2ke5drked8skke7ernkeg8ga3kehetk3ei2dk6e1ink5ek4t5kelalke6lat4keles4kelev3kelig4kelis5kelit4keliv4kelofkel5slkel5spkel5stkel3svkelt3e6kelua4kelue6keluvke4mit5kena_6kenamken6apke4nasken5de4keneb4kenek4kenel4kenem4kenev5k6enhke4nomken1s2kens6tken7te6ke3ny5kepi_9kepia7kepiekera7l4keramke4ran6kerau4kered4kereg4kerekkere6n4kerepke3res4keretke4rifke4rimke4ris7kerop5kerorke3rotker5toker3un4kerus4kesam5kese_k5eselke5sil4kesit4keski4keskj6keskå5kest_ke3sto4kestu4kestøk6etar5kete_4ketek2ket2rkety6e5kevas3kevelkev6jaki3a2rk3ideo4kidolkie5reki3er_ki6ka_ki1k8lki3k2rki8la_3kildeki4le_kil9jaki7loaki4logki3loski4lovki8ma_ki4me_5kimo5ki4mol2k1impki6ne_kin3geki4p5lkip5pekip2s3ki5skoki3smuki1s2pki5strki6tenki4tonki4vekki6vi_3k8jankje7fj4kjegg3kjeld3kjemp6kjenkkje9nykjet5t3kjærlk5jødi3kjørikjø4trkk3aftk2k1akk2k3alk4kanbkk5andk4kannk4karbk6kargk5kastk6kasuk6kattk2k1auk6kedok4keduk5kel_kkelu4k5ker_k4kesak4kesek4kesik4kespk4ketek4ketøk4k9g2kk3indkk3infkk9innkk3inskk3intkkjek8kkje7tkkla4gkk3lankk8larkk7laukk6s5vk4k1ofkk5omlkk7omskk9omtk4kosik6koskk4kostkk3ovekk5ramkk3rapkk3reakk5reikk3renkk3reskkri6kkkro8ekkro4skk4ruskks6alkk4sarkk5sedkk4sinkks4kjkk3slakk7slekk5slikk3spekk1s2tkkst4rk4kuni3k2lask7latikla4trklei9ek7leikk4leivkles7jkle4sp4klie_k5linjk3luktklun5t6k7lyfklø7naklø9vaklø5ve6k1lånklå5rekmann63k2napk4nedi5k2neek4nest3k4nipkni2t33k2nivkno6klkno9takno5te4k3numknø9le4ko1ak9koane4ko3brko4de_3kodek5kodenko4grekogst6ko7i6kko8ja_ko4ka_ko4kabko4ke_ko6kelkokk6ok3okku4kok4lkolba5ko4legko4leiko6lelko4letko4leu3kolleko5lo_ko4ma_4komafko4me_ko4mi_4komil4komsekom3slkom5sokom4st4kom5tko4na_kon6dr4konivkon3s24kopetko4pi_ko4pipko4p9lko4ra_kor4duko1r6e6korefko5remko7retko6rikko5rol6korpa6korpe1kor3rkor4svko6sa_ko4sedko4sekko5senko4seskosi9d4kosmuko6stakost5jkotes7ko5t4i4kotilko6trekot4tikott4skou7ta1k4raf3krakk6krank3kranskra9sekras5skra4to4kred_3kredi4k1regkregi3krei9ekrei5sk5rela4krentk5repr5kreps5kresjkreta9k4retsk3rett7k6rigkri9gakri5kekri4kjkri4me1k2ris3kritekro5b4kro5dek3rofokrok7kk6ronik5ronlkrop9nkropp4k4rostkru3i4kru5sakru3tr2k5rygkry7pakry5pekry4pikrø5ke6k5rørkrå8dakrå5lekrå7nek2s3adks3altksa5mek3sanek4sansk3sar_k7sarakse6gek2s1eik5sektk5selak4serfks3erkk4sesak5sesokses4pk5sessksi5koks3indk3singksi7niks3innksi3stk4sitiks9kabk6skioks9ku_ks7kuaks8kutks1k6vk7s6luks5løsks4melk5s4nok7s8nøk6s7oak4sombk2s1ork3spalks3pekks5pioks3pirk5stadk4stakks3talks6tavks4tegk3steik4stekkst3evks4tilk4stinks4triks4troks9tumk5stusks3tyvks5vegksy8nak6s3ølkta7f6kta6kak4taktkt3anlk4tanvkt3appk9tar_k6tassk5tastkt5avhkt5avkk4tedak4teføk2te5ik6tekakte5lekt7emnk9ter_k7tes_k6tesak6tesek4tetekt5evnktis5tkt5offk4tolikt5omfk2t1opk9tor_k7torak5torektor7skt3ralk2t1rektro5sk2t1rukts5arkt5sekkt7semkt6sinkt5skukts4kvkt6sokkt4spakt4stakt4ståkt7undk2t1utkt7yrkktør8ek6t5øsk2t3årku4be_ku4dalku4er_ku4f3lk5u4gr6kuldikuld3rku4ledku4legku6leiku4lemku5lenku4letku4levku6li_ku4man2k1ungku4pe_kup4plku4rekku8r7okur6skkur4spkurs3vku5ru6ku7sa_kus5arku4ska6k1ut_ku6t7rkva8kek4valik6vardkva9sekve3d2k6veil1k4velkve5la5kvernkves5t7k6via3k4viekvi5erkvi7la3kvinnkvi5se7kvistkyf5leky4leg2k3ynsky4p5rky6se_ky3skrkys6sk1ky4stkyst3aky6ta_kyte3skø4en_1k6øyrkån8dakå4pe_kå7penkå9rask5åt6tla4demlad3s44laent6lagnela2go8lag5omla2g1rlag4sj2la1inla4ke_l7aksjl5akslla5mabla4mesla4metl8a8muland3rl6a3ne3lane_4lanetlan4grl3annola4norlan5til3anvila6pallap5sa1l8ar_l8are_la9redla5remlare6tla7rialariar6l7arrlasi9e7laskjla5smi4la4sp4lastr6lataula4teglat6ekla6ti_latt6ulau7selau6stla4vellba3delbe9nald5aksld5aktl9dandl2de5ol7der_lder7al4deshldis7kl4doreld5ovnl3drakld3ranld5rasl6dre_ld4sekld4selld4sesld4skalds4kjld4s9mlds3trld6tuslea5lale4bem5lebæk5ledarled4dø4ledeble4dem6ledeple5derle3des3ledop5ledovle4drole5dryled1s24le3då4l1eff4lefor4lefot6legap5legasle4gedle9genle4gev7leggi6legifle4gol4legreleg3s46lehal6lehan6lehaule3idol6eie_leig6dle3intleis7tle4ka_6lekanlekk7s2lek2llek4na4leksp2le3la8l9eldl3elem4l5elg5lelig4lelukle8me_4lemet8l9emnlem8nalem4silem5tile4na_le4nal4lenavlend8a4lened4lenem4lenevl4engdleng9u4lenivlensa4len4trle4pelle2p3jle4ple4leramle9re_6lerea4leref4lereg4lerekle5res4leret4lerev9leri_7leriele4rivle5ro_4leromle3ros7lers_lers4pler7te4lerus5leryr5l6es_le4sab4lesam7lesar4lesaule5sedle4seg4lesekle5senle3ser4leset4leshole6si_4lesig4lesit4lesju4leslales3s64lestale3sto4lestø4lestå4lesug4le5sy5lesøyle4tab6letak5lete_6letea4leteg4letekle5ten4letes2le3ti2let2rle7trelet6sjlets8klet6trlety8ele4utele6vadle4ved4leveg4levei4leveklevi6dlf5antl5f6inl4gelal4gelelge3nalge5ril4geryl4gesllgie8nlg3reflgr9øylg3s2elg5år_lgå8vali4alali5anslibie6liby5eli4dakli4dedli4do_2l1idrli4eneli3er_4lifatli4ga_li4garli4getlig3selig3slli5kanli9karli7kasli5keeli3kenlikk3oli1k2lliks4t8l5ildli4marli4masli4me_limp3rli4na_linch54linduli4ne_li6nem2l1infling5l5lingvlin4kv2l1inn3linni6linnsli4norl4inse5linsklio4noli5o6slipes4li9rarli4rek4lisakli5setlis4kllis6splis5tilist3oli4teeli4tekli4tidli4tigli4tilli4timli4tivli2t1rli6va_liv5eglivi5eliv2s3l4jarblj9elvl3jer_l4je1sl5jes_ljes4tl5jet_l4jete3l2jodlj5oril5jøs_l5ka6ll3kedelkeei4l7ker_l4keral4keril5ket_l5ketsl5k4lulko9malko9salkras5lk4serlk1s4tlk9utel6kvegl5la6all6a5fl4lamil5lanell3anlllans4ll7apallap3sll5aspll5aurll7avlll5avrl5leaklle5grl5lehal5lehol5lehål4lekil4lelil4lenkl4lenulle4sol5let_l4letal5letsl8letæl5levål4linsll3intllo5idll5oksllo2m1ll5oppl2l1orl4losol6lotellra7nll4sakll4semlls5kvll5skåll3smylls4nolls4tells7økllto4el4lu4el6luksl4l1unllu4pil2l1url2l1utllva8nll5øksl4løvell7øy_ll5øyall3øyell1å8rll3å2slm3anml4melulme7rilm3indl5minglmini6lm3inslm5intlm5s2pl6m5øslm5øy6lmøya9lm5å4rl4m5ås7loanelo1a4r5loar_lo2d3alo6d5u6loenglo4girlo3goplog5salo5id_lo3idelok4ko4lokonlo1k4vl5omdrlo4nallo4nitlo4pealop5pa5l4opt4l1orglorie6lo7rødlo6seklo4seslo5sevlo9teslo8ti_lo3vanlo3varlov3salpa5rel4pedol3pelil3pesml4petilpin3elpo6etlra8dalre4delre8kalre8valri8malrot5sls5aldl7sanals5arkl4sat_ls3eidls5eigls5embl4senol7ser_lses3llses5sl5simul5sjefls3jegls3jenl6s5kelskif5ls3kjolsk3læls3koals5korls3kovl4skralsk5unls7kvals3kvils3kåpl5smørls5ondl2s1orl9spegl5speil9spells3pril6ste_ls4tedl4stegls4tells6ti_ls4tiels6tonl9strils7veals5veel4svikl2s1øylt3aktlt3anllta6nolt3artlta4stltat3rlt3avkl5tavæl3tedel4tekalt4en_lt3epiltid6sl4tietlti6g5l4tinalt3indlt9innlt3insl4tivil2t1jalto9arlt3ostlt3reglt3reilt3resl5trevlt3rollt3roml5troslt5s4ilt7s6tlt2s3vlts4vilt3undltu4ralu6brilu7ere3lugarlu4ka_4luket5l6uktlu6mellum6sklu4ne_l7u2nilun5ne3lunsjlu2p3u6lureilu5ren6l5urnlur8nalur8talu7saklu6sellush7elu2s5klus4o5lu3ta_lu7tetlutla9lu4t5rlu4ve_lu9venlu9verlva6lal4va4ml4vanalv8andl7var_lv7asal4velal4velelve9nel9ver_l4verul4vesklve5sllvi9erlv3irolvor4slv5o4vlvra8rlv7s6klvå4p4ly4d7rly4gelly5g6lly2n3aly4ne_lyn3s2ly8ra_ly6re_6l7yrkly4sa_lys3kjlys9klly2s1lly8ta_4lyteklyte5slæ6ra_læ5rarlæ4re_lære3ilæ3rerlær6svlø3de_lø4dellø5demløk5kj4l1øknlø4k5rløns5tløp6s55l4ørdlør5k64l5ørrlø5sanlø5serlø9ta_lø3te_lø4tegløva9rlø4ve_lø3verlø5vesløy8edløy5elløyg5elå6gallå6grelå6ke_lå2m5o6l5åndlån2s1l1åp9nlå8ra_lå9rarlå5raslå3rinlå6sa_lå6skolå4s5llå4stelå3te_lå4teglå4teklå8ti_lå4ve_ma3chema4delma3dram6ad9s7maene3mafia6mafråma8ga_ma4gedma4gelma4gesma5kab4makadma4kesmak7kemak6lema4kotma3kremak4to2ma1kvma7lebma4letma4lov4mamerma3nakm3anal6manam4manavman8cem6ange4mangrmania8m3anle5m4annmar5d67mare_6maregma3reima7relma5res3mar4ima3rinm4arkamar4kvmar7slmar5tema4ry_4maselma5setma4siama4sikma4sis6masjumas4ki4maskomassø97mast_4mastoma5tadma4te_ma6tedma4tel7maten7matet4matil4matramat3s2mats8lmat5tamau7suma6ve_ma5venmbar3dmbe9dam4bedøm4belim4benam4berombi6armbo5idmbo5re4medat5mede_me4dedmed5eime7denme7det4medik4medirme6dok4medommed1s4me6dun7medve6me2game7galmeie5nme3ildme3indmei5nime7isk4meisome2k1l6mekte5melarme4le_4meled4melei4melek4melik4melis4melit4melivmel5le4melok4melovmel4simelsk4mel7trmelvi6me6mo_men4nyme4nomme4normen4simen3smmen5temen5trme4nytme6rab4meradmer5di4mered4mereg4merei4merek4merelme3resmere6t5merinmer5osmer5skme3run4merusme2r3øme4råk2me5sa2me1skmes5ke2me1slmes6le4me3so7mest_4mestames4timest3r4mestu4metabme4tar4meteg4metei4metek4metel4metep4metil4metonme4treme4tru4metræmeva8nmfa9ram4fibrmgå8va5mi6al9miane7miar_8m9idémid3s4mi3er_mie9s8mik5sami4la_mile6tmi4lev4milinmi8ma_mi4na_mi5narmi4ne_6minntmin3spmins4tmi4n5ymi4san4misek4misel4mi7simis4komis9le4mistu2mit6rmitt3sm5jar_m7jarnmju7kemjøs5tmkå8pamla6gam4leram4leskm4letamma5klmmar7om4medøm4melum6menim4menummer5tm2me1smmest6m5met_m4metam4metim7mianmmie6nmmi5skmmi5sommi3stmn7eidm2ne9lmne4ram5nesem4neskm9net_m4netemo3demmo6di_mo4en_mo8ka_mo6la_mo4le_mon5t65mo1ramo4ra_mo4rar4mordlmores7mo4ri_mo6ridmor4klmo5rokmo4rommor4simor4spmo9senmo2s7k4motapmo4te_mo4teimo4tesmot7remot1s23mo3vam4panam6penam5pettm2pe5um8pla_mp5le_m6p5obmp3oppmp3radmp5retmp3ropmp3sekmp5s6tmp5ut_mrø9dems5antmse5lum9s6eim4servms4ingms3innm4s5jams5kabmska9kms6kinms3korms3lanms9luams3luem4somsms3orims7teams3timms4trums3unnmsu9tams3yndm4s5ørmteks7m9tidam6tinimtiør6mt4vin8m9uka4m1ukemu4legmule6smunes6mu6ra_mu4re_mu4se_mu2s3k3mu1tamu8ta_mvak5tmva6lamvari6mvi7e6myg4gamy9ranmy9rarmy4re_m5yrkemy4r5umy4se_my4te_mæ6la_mø7desmø9ensmøkk6amø4ne_møne9s3mørkemør5smmø9tasmøy9arm5øys_6måenhmå4ka_må4ke_må4kesmå5larmå4le_må6ledmåle3imå8pa_må4pe_måra6rmå6takna6ansna6botna4dedna8demn3adopnad2s1nafo7rna8ga_4nagennag3s4nagså5nak7kanak6konak8sa8n1aktna9lagna7legna4lekna4lesna4levna4lilnal3opnal5s2na3lurna2l5øna5mesna5mo9n3analnanfø84n3anlnan4nena4n5onape4snap3s4na4rapnar5dr4nareanar7einar5tinasa3rna4sas8nasikna4skinasta5nate8kna7tem4natomnat8ranat3spnaus6pna6va_2n3avh4n5avknben4snbo5etn6butrnbø9lench3ein7daa_n6dabin7dag4ndags5n4daksn4dalfndals3n4darkn8daskn5defind4einn4dekln4dekon5dem_nde5mon5den_n5densnd6erkn4desin4destn4desundi4enndi6sknd3jernd4lemnd4levnd3orgnd5ormn6dotend5raend3rannd6reknd4sagnds3aknd4sernd4sjend4skjnd7spundu3isnd3ungndu6sindus7kndy5spn2d1øyne5alpne5als6ne7avne4ble3nedal4nedeb4nedeg4nedelne4di_nedi4sne6drened3stne5dårne3gla6negrun2e1inn3einine4ka_6nek2lnel3de4neled4nelei4nelid4nelis4nelit4neliv2ne1lu4nelås4n3emb4nemel4nemer6nemesnemie86nendr4nened4nenemne3nes4nenet4nenevnen5sene5o4r3n4er_4nerad6nerap4nerea4nered4neref4nereg4nerek4nerepne5res4neret4nerev4ner2gner3ganer3ge4nerik4neritn3erob6nerocne7rofne5rok4neromne5rotn6ers_ner7seners4pner5un3neryr4nerørne4sa_5nesar6neseknes6er4nesit2ne5sjnesk4e4neski4neskj4neskr6neskune3sline7slønes6mine7snø3nesot5nest_4nesto4nestu4nestø2ne1svnes8va5nesøy4ne5så5nete_4ne3ti6netid2ne5to6netom2net4rne6va_ne4ve_5nevikne4y5tnfall4nfan5tn4folen4foran8g8adng3ankn4gartngar5ung5atong7aving4dedng4delng4depn4gedan4gelan4genan7genen6genon4genunge3sln4getan2ge7vn5glemng5oddn3g4okng9omeng5ondng5ordng3orkngos6png3ra_ng7reang3regng3renn4grerng3retng3revng3ridng3rinng7ro_ng9roang7roeng3rådng8sa_ng4semng4sesng6skjngs3neng3undngvi4sn2g1øyngå8vanhet4sni1a2nni4delnid5stni3er_nie5rini7ersni5ertni5glani9glo4ni5koni5l4i4nimar4nimas2n1indning3onin5gr2n1inj4ninnb4ninnh4ninns4ninnt2n1ins2n1intnions34ni5ovni4petnip3linip5si4nisemni5setnis5imni9solni3str4nisty4nistøni3tedni4togni4tosnitt4rni4umf4n5ivoniv3s2n2je1sn3jes_n3jet_njet6rn5jettnk3aksnkal5ln4kedon4keernk5eienkel5snkelt3n8kenon6ketønk3iernk5indnk7infnk3innnk7intnk3loknkofi8nk5oksnko5len3kravnk4taknk6talnk4tinnkt3sknkuri9n4ku6tnk9uten7kvitnkå6panly6dinmini6nn5ad_nn9aftnn5airn6n1akn4nalann5algn4namenn5anan9nanenna8nin5nanln9nar_n4narin6nasin4nasknn3avlnnbo9ennbu9enndør3n5nea_n5neapn5nebun4nedin3neken4nelon3n4enn9ner_n4neron7nes_n6nesjn4nesøn4netenn3idenn7infnni4sjnno2m1nn6omsnn7ordnns3arnn5segnns5opnns3ornns3tvnns3vanns3øknn6ungnnvi4s5noaneno7ar_nobe4lnob5leno3b4r4noent3no3ftn6ogran3oksino6midno6mikno4milnom7s2non1s4no1r4ano5ranno5rarno5rasnor4da4nordnnor4døno9reeno3rekno3renno7ret3norge7noritno4selno4sesno3stjno4ta_no4te_note5i5notekno4telno4tes4no5vi4n5ovnnpo8tanra8nanra8sanrei7enrå8dans1a4dn5sakkns3aksns5akvn3salans3aldn5sanen4sanfns5antns6armn6sartn4satins5eddns8edense5einse6erns5egensei6dns9eign4seksn5sen_n4senin7sensn3ser_n4seran4sesan4sesinse3sln4sestn6sesun4seten9setsnsin5dns3innnsi8ransis7kns3jakn4sjavn5sjefn4skann9skimns5kirn5skisn6skjan3skjæns5korns3kron4skugn5skumns5lasns5lidn5slynn4smaln4s5mon4smurn4smusns5nesn3s2okn4sondn3sovnn5spetn7spurnsse4ens4ta_n4stakn4stagn3stamns4tauns4teln6stepns4tinn5sto_n3strun3stuen6stukns5turnst3utn4sungn2s3vens9vegns9visn3s4væn4s1øvns5øyan5såpens7ås_n4tagrntall4nt3anlnt4anvnt3appn7tartnt3avint5avrnt7avsn5teatn4tegen4tegin7tegnn5teisn4tekan7teknn5telln4telsn9teltnt3embn5ten_n5tensn5teppn5ter_n5tersn7tes_n4tetan4tetent4e3un4tiatn5tiemn5tikin4tikln5tilenti3lon6tinin4tisant5omfnt5omnnt3omsn2t1opn5tor_n6torgnt6rann4trepn5trern6tromn6trulntrøy4nt5skjn6t7ubn2t1utntyr3snt7år_nufts5nug6lanuit8enul9t8nu5sa_nu5sennu7sernus3tanu3te_nute6rnu6umenva6lanvand5nvi4etnvi5kenvæ8rany5ar_ny9astny4de_5n6yheny6ra_ny4re_ny7revny9s6knystu4ny8va_ny5vakny8ve_næ8ra_nødde5nød3sknø9dunnø4le_nø6rednøtt6rnø3ver2n1øy_n3øys_nå5dedn1å2k4nå5levnåp8naoak4kuoa4r5iob4b5rob4b3uober4sobi5e6ob5la_ob3le_ob3leno2b5li3obligob5rar3obserod7attodd5eiod4delo6d5eio4dekoo5dekuo5det_o5detsodie4nod3omlo2d5reo4d3røods4kao2d1å6oeng5doeng3soeng3uo5ens4o7ens_o3e4reo6ereroer8mao3erskoe6sipoe6sitoes8kao4etanofag6ao4faraofa4seo4feraof4fekof5fesof6fiaoff5ido6fra_of9ras6o5friof8se_of4teloft2s3og7anko4gareo2g7avog4g5jogg3s4og6g7uogi3a4o4gievo4gikoo3gingo2gi1oog5jerog4nedog6nelog4re_og4rero4g3riog3rydo4g5røogs6anog3s2eogs4kjogs4leog1s4pogs5paog5steog3stiogs4toogs4trohe5teo4inspok7aftok5arkok5elvo5k6eno4keskok3kjeok3ko_ok5kolok4kunok8la_okla5mok8le_ok7lutok3omtoko5peok5oppok3ormoko9seok5reoo6kreto4k5ruoks4alok4sekok4semok7senok4sesok5s4ioks6tioks6tr3oktanok5u4kok7uteola8gaol5anlol3anto9lar_olber4olbo7eol4bolol9danol5de_ol4demol5detol3driol5eigole5ino7lekio5lem_o5lemso4lenio4lenoo4leruo9let_ol4f5iol3g4eol1g4lo4libaoli5neol2k3lol5la_oll3akol4lamol7le_ol4ledol4lelol7lenol4lesol4logol4lomol5losol4lovolls4toll5svol4løpol6løsol6løyolme5so5loanol5oksol3omsolo5veol4pedol5svaol3tedol5tepo4l5urom3aldo2ma2mom5angomann4oman5tom3arsom4betom4bis5ombodo2m1eko5mekaomer6so6mese3omfan3omgreomi3e4o4mieko7mikko7mineom7inno4misjo4mistom6matom4medo4mofoompa3toms3alom4sek3omsetom4somoms3un3omtalom4tesom5øy6on3aboon3appo6narbonat5ron4darond3reonds4ion5eieo4neleo7nello4neruonesi6o4nesko4neteon7ga_on5ge_on6gedonges4on5go_on8groongs4jon4g5øon5ildoni6mion3info2ni1oo4ni5po6nisoon5k6a3onkelon5k6ion4kleonle6gon5nado5nor_o4no4von3oveonsi3sonsi4vons1k4ons7keon4sveon4tedon5tenon4tokon5toron7ul8onu4sko4n5ø4on6øy_oo5k8aook5esoo4m5ioop9anoop5enoop5etoor6daopan9do4pasjo4penao9pendo7pent3operao7peroo5perto4petao4piekop4na_op4pasop4pi_op6piaop4pisopp3li3opplyop6poeopp1å2op6sa_o8p8siop2t1ror3adror5aldo3r4amo4ranao3raneo4rango4ransor3attora3ukor1a4vorbit5or3dea6ordelor7dikordi4sord3itords6eord3sto8redio4relao6reldor3enkoren3so6rerfo4reroore1s2o5resco4retao6retv4orga_or5gerorge4sorg4skorha9gori5b4o7rietori7kaor3indor3inkor3innor3insoriro8oris4ao4riti3orkesork7s2or6mapor5melor4narorned5or5netor4nolor3offo4r1oro5rosaor3oveor5ovnorpe6sor5senors4kuor1s4lor3s2oorso9vors4paor4tekor3temor5tiior7tilor5tis3ortodor6tokorto4ror4touor9udeoru4t5oruta4or4utfor5vegor9ø8korøk8tor3ø4vorøv8do4sa5bo4saku6o5sauosefi5o6senaose5slose5smos7hisosk3eio4skilosko5po3skrios8k3vos3lodos7oveos6pa_os6pe_os4pilos4poros4sekos3semosse5vos6skioss3kjos6spaos7styos5talo8ste_os4tegos4tekost6elos5teoo4sti_o8stiao4stieo4stinos5tisost3reo3stroost7råot5aldo9taneo9tar_ot3argotek5io4tenao4terooter5so4teråotet5aotet5ootika3ot5jero4to3ao5toa_ot3offo6togaoto5neotor5dot7redot5rerot5revo6t7rio6t5røots5elots6opots5prot7steot5tasot5tinot5toaot7tugot4typo6t5utovan9oov3anvo7var_o6varbova9reov5artov7arvove4lao4vendover3aovere63overg5overrover9voviso3ov4nesov1o2vov5salov4sekov4senov9skeov4sleovs5teov4stiov7sunovsy5kpa8cenpa3deb4pakti3pa1lapa7limpal5inpal5løp3analpa4nappan9depan3kapan5sepan5slpant8rpa8pa_pap4prpap3ripa4ra_5parad4parekpa4ri_pa3ris4parkipar4kvpar3m8par9s4parvi6pa4s3tpas5tipa6trep8attap8at6vpa4ve_3pa1vipbo6dape7d6a5pedaspedfø9pe6doape6donpe4dro4pedy62pe1inpe6ismpe8ka_5pelalpe5lar4peledpe4lef4peleipe6lep4pelerpe6lev6pelivpel4lo4pelovpel7stpe5lunpe4nanpen3de4penerpe3net5peng8pen7glpeni4n4penivpenly4pen5skpens4tpen5trpe7o6spera3a4peradpe4raipe4ral4perappera5t4pered4perei4perek4peretpe4rev4peritper5mupe3ros5perropers6m4pe7råpe6se_p3eske3pest_4petab4petal4petas4petau5pete_4peted6petei6petek4petel4petem4petid4petilpe4tim2pet4rpet1s6pfø5repgjer4pha9vaphavs5phe9tephe7vaphe5vephi5li7piasepi6ca_pid3s26piendpi3er_pi9erspig5gep7i6gjpi4kehpi6kelpik3kopi6la_pi3leppi4na_pi4ne_pi9nedpi4nelpine4vpin6goping3r6pinnspin4slpion5spip9lapi4rarpi4respi4rutpisi9epi4skipiss4lpis4sppis4stpka8vap4lan_plan5gplan5s4p1larpla4st4pleispli7vaplo4gjp4lo8i4p5lovply5d8plæ5replø6papo6da_po4de_po6f7rpo6lanpo4lekpol5lipo6lompon4grpongs62pon1spon5sapon4svpo2p1apo6pe_2p5ordpo1r4epo4refpo6reg2p1orgpo4se_po4sespo4stapos3te4pos4vpotak9po4te_pp3aktp9panepp5ankp9par_pp5arrp7pastp4p7atp4penappe5p8p4penøppe5rapp9esnp4petap4petepp5ettp2p1ilpp3infp4pistpp3ledpp5leipp9levp2pol4pp3oldp2p1oppp3orkpp5reipp5rinpp4rispp9rivpp9ro_pp7rotpp3skapp9spepp3splpp7sto3prakspra7lipran3s5prat_5prate4preiipren4s6pres_4prettpri5ke4pring5prinopris3tpri9ve6p7roc4prog_4proge4progl4p3roip5rop_7prosepru5tapru5teprø5s4prå8dapråk3iprå4kops5a6np2s1elp3sen_p5sensp7ser_p5setep5setsps5insp3s4jop2s1kop3skodp3s4låps5pleps7talp5s6tåp3s4uspsy3ke3psykop3s2økpt7arkpte7reptus5t6pu6dypu8le_pu4ma_pu4re_pu8reapusl7upu4ta_pu5taspu5terpu5tevput6trput4tupy6sa_py4se_pæ4re_pø8sa_p1ø2v8på4by_på4la_på4le_på7sko6påtå7qu9ar_4rabisra1bo4ra3cetra3d2a4radir2ra1drr3adrerad2s3radvi4ra5ede4raerkra4fiura5fo_ra4fosra5frera7geara5geera5intra3iskra9karra7kelra5krorak6sarakst64raktirakt3rr4a5ku5ralds4raledra5leora4linral5leralo6iral3opra4magra4mas6ramed4ramilra4naara5narran9csrand3r4ranfaran5ge6rangirania8ra6ninran3kv2r5anlr6anli2r1anm4ransvran6utra4pel4rapinra4pirra4pisra6pitra4pos4rappa3rappo2ra1pr1r4ar_4rarea4rareg6rargu4r1armrar3rera3sea4raselras3kera4skirass4lras7st4rasti4rastj6rastyratak9ra4te_4ratfera1t4rra4trø4ratubrat5utraud3srau6ga4rau4kraus6sra3vørraz5z6rbede4rbi9errbist6rbo4nirbon7srbo5rerbra5srbrei6rbu5enr4d5akr4dalardals5r4dantrd5atlr4datmr4d3aur6dedirde4enr3defir9dekar4deklr4deksr6delor6demir7denar6deporde6smrdfes5rdi3anr6diaurdi3e2r4dikar4diklr4dikur6dimirdi3ovr4dishrd3ostrd1o4vr9dradr3drakrd5ranrd3rasr3dreird3retrd3rotrd3seird8skerds4kvrd3stords7turd3undrdy5perdy3rer6d7ytr7d6ærrd1øs6rd7å6srear5e3redak6redamre3defre5denre3des3redigred4sl3redukre4el_6refos4regar4regebre5gel4regen4regerre4giare4gil4regub4regud2r1eigrei9rarei5sarei3sire7ismrei7varei5vere5ka_re5kavre7ken4rekob4rekom4rekon6rekos4rekra3rekrur3eksa6reksp4relag2r2ele6relekre7lenr3elit4re3lj5r4elmrel4sk4re1lu2re5lyrelå7rremi6lre7misrem9jirem8narem5p42re3na4rendr8renedre5negre7nei4renek6renet6rengdreng5l4rengnren6klren5sar3enss6renture3o2r8repen6repus6reradre5re_4rered4reref4rereg4rereire4rek4rerep4reret6rerfa4rerig4rerik4rerol4reromre3rosre5rotrers4pre2s3c4reselre4sem4reset4resinres5keres6klre6sky6re1slre4slure5smore3sovre9spe4respi4resprres4sjres6skres4spres4stres4syres3tére3str7restv4restå6resuk4resunre3svi4retalre4tap4retea6retelre5ten4re5ti4retoarets4iret4strett8o4re5tu4re7tå4revakre5van6reveg4revei4revelre5verreve5sre7vomrfa5rerfe8errfu8serga8lirg5andr7gannrga3rirg3artr6gedirgent4r4gesjr4geslrgie4nrgi7slrg5le_rglem5rg3lenrg3lerrg5rabrg3rearg3relrg5rinrg5storg9sturgå9asrgå6varhavs3rhø5rerhå9ne4rianf4rianl4riarb4riarrri4avari2b3lri8ca_ri4co_ri5der2r1idr4rieie4rieig4rieks6rieldri3end4rienh4rientrie5rarie5ririf4firif5la4rifø4ri4ga_rig4gr4rigreri5kanri3kesrikk5j2ri7ko6rikonrik4skrikts3riku6mri3k4v6riledri5lei2ri5loril4snri9mabri9mar6rimesri5metri4mi_7rimisri4mor4r1imprim9utrina5l4rinas4r5incr3induri4neeri4nes2r1infring3r2r3inj4rinorrins6krin6smrin4tr2ri1of6ri3om2ri1oprio5s4riot3r4risau4risedrise5i6risek4riselri6sju4riskari4ski6risku4riskyri4sto6ristøri6stå6riteo4ritilri5t6orit1s6ri6tun4rivarri6vedri5vei8riøyar4jerer4jetir4jetrr4jeturju6lark3aktr6kanfr4kaprr6katrrk5eikr4kelor3ken_r3kener4kenir5kensrke5rir4keror5kersr4kerørke4ser9ket_rk4hanrki4virkjek8rk5jorrk5lunrk9lutr3knekr5kneprk7nesr6kofor4kolar4kolir4koper4korar4korur4kosjrk5reirk4sarrk2s1irk4skark4stjrk4storkti4srk9veir5kvelr4kverrk3vesrk5vikr4k5ølr2k3øyrk9øysrk5åkerkå6park5å4srle4str4lesurli9kerli8tarlo5verlys7kr5løy9rm3anlrm4ansr6manvr4marer4marrr2me7grme5ner4mesermini6rm5i4vrmo7strmu7anrm5øy_r6m5åpr4n1akr4narbrnat7rr4natvrn3avlrndør5rne5a2r3nellr3nelsr4nenhrne3rorne1s2r5nes_r8nesir4nesmrne3sor4neterne5vrr4ninnrn5omnrn3omsr4n1oprn3orkrn5skern3skrrn5slarn4stirntre4r6n3utr4n5øvro5asi9roban9robarro4bedro4bef5robenro4besr3oddsro5endro7ensro4felro4femro7ga_ro7ge_ro6gryrog1s4ro4kelrok5klro7k6lrol6lyrolo9vro6makro4mal2rom7b4ro3merome5d4r3omnro4morr7omsyromsø3ro5ne_ro7nimron4narono5sron1s4ro4pad5ropetro4piaro4satro5selro3senros3laro6sovro1s1pros4stros4syro3stiro3strro5tesround3ro5va_ro7vasro5vekro7venrov5smrovve6rò6te_r6parbr5pefor4penor6penør5peskrp3ladrpun7gr6p5øyr4raror4reklr4replrre5skr4resmr4resor3ressrre4strro8sarro8tar2r3unrrå5der2s7adrsa5kar6saktrs3allr4sarrrs3arvr8sedirse6g7r4sekurs4elars7eldr4selir4sesir6sesurs6ettr7sim6rsimp7r4sinsrsis5trsj3orr3skadrs4kamr3skapr4skasr5skilr5sko_r5skoersk3opr4skorr3skotr5sku_r5skuers5kysrs4lefr4sleirs4lekrs4lesrs3lokr4slunrs4mo_rsmål4rs6nevrs5omlrso6n5rsons4r2s1orrs5ordrs4panrs6patr5spelr4sperr7spesrs4porrs3tapr6st7brs4tedrs4temr3stilr5stisr4stitr6st5kr5strørst7utrstyg7r3st6ørs5uklrsu7sars5usirs8vakrs5vitrsy4narsøks3rs9øyer4t5afr4tanart3anlrta9par4tarrrt3artrt3avsr4tedar3teder4tegor4tegrr4teier4tekar4tekir4tekur3tempr7t6err5terdr5terkr4terår4teser6teskr4tetar4teter4tiarrti5enr4tilar4tilir4tilorti7sar4tisprtis3sr3titurt3offr9tofor9tok_rt3omkrt3ordrt1o4vr9tre_rt6redrt3regrt3reirt5relrt5repr7tribrt3rutrts3arrt4segrt5skert3skjrt4stirt3undr2t1utrtyr5srty6rartæ9raru3andru6avhru4di_ruds4lru4elerue3s4ruga8lruga5trui3d6ruk4surukt3s6r7ulkrum3alrund3r4ru2nirun5krru4nøyru8ranru8rarru9rerrur8tarus2h3rus7luru1s4orus4stru3talr4utberute3iru4telru9terrut4reru6trørutto5ru4vedru4vegru4veiru4velru4vesrva7karva6larve3der4vegar4vegir4vegrr4veimrve5klr4velar5ver_rve5rervil9lrv5ungry5ke_2ry1klry4nesry4pa_ry4tekrær5inrø4be_rø4dekrø4ke_røk5s4rø4pe_rør5d6rø7retrø2r3orør4sprø5slarøt9asr4ø5væ2r1øy_røy9arrøy6edrøy5esrøy4et5r6øykrøy5rerøy4st3rådetrå9ene4rå5g4råk3rerå2k3urå4letrån6darårs5ksa4ba_sa5boks3abonsa4dag4sadamsa4ga_sa4gassa4gat6s5aggsag8nasa6go_sa4gogsag3s43saka_4sakadsa5kaisakh5esak5krs4akkysa1k2rsak4sp5saksr5saksu2s1akt4sa7kø1s4al_7sala_1sa3lesa9lets4algesals4asa5ma_sa5massam5eisa4melsa4metsa9na_sa7narsa3natsand5r5sang_3sange2s1anlsan5ne6sannos5anorsan5os4sansa6sansvs8ant_san9te6santr4santy4s1anv1s2ar_6sarab4saregsa5revsa4ri_2s1armsar5me2s1art8sasju4s1ass4sastysa5ten2s1atls5atsk5satt_sau6gas3auge2s1auksa4ve_sbo4dasbu6etsby8tas4cene8schl_sdam9psdu8ersea9re4sedag5sede_se6e3ise3e4l4s1eftsega6lse6gesse3gev9segl_sei5ge3se8ilse3inds3einise6inkse3insse3int2se5ka2sek4l4se3knse2k1r4sekra4sekri4sekro4sekspsek4stse6la_3selak5selarse4le_4selei4seles5s6elg4selik4selil4selis7selolse3lomsel5t62se3mase4mi_2s1emnsem4na9semndsem5pe6senau4sendr4senedse3neg4senem2s1enhse6nins3enkj5sen3nsen4sjsen3so7s6ent4senum4seram5seran4serap5seras6serau5sere_4serea4sered4seref4sereg4serei4serek4serel4serep4seret4serev4serik5serkr2se1rose4ropse4rorse4ros9s6ertser4tr4serulses5in4sesjeses5kvse3snases3pr5sest_4sestoses5un3s2et_3seta_se5taese5tar6setea4seteg4setei4setekse7tel4setes2se3tise8ti_4setje2set6r3sevågsfo8rasfra5ssfyrs5sfø5risga8vasgen9ssge4stsgå4vas5hei5sh5isk3shortshø6va4sia5msi7ans3si2dasi4deos4ider2si2do4s1idrsid8rasi5er_si3estsi4f3rsi5ke_sik2h7sik4kasik4kosi4komsi4kopsi4kossi4kotsi6mel4simet4sindesi3nek2s1inf7singus3innhs5innks3innl4sinntsi5nob2s1int4si5ovsi4pa_si8pe_si6re_si7rensi4ri_sir8klsi5selsi6sin6sisjusis5kesi4stisis3tosit8jisi4trisit3s4si4umfsi9vansi6veksi8vi_si9våt4sjanls7jarn2sj3av6s7jaz5s4je_sjef5tsjons76s7jugsju8la2s7jussjø3k6sjø9røsjø1s2sjø3t8skabe34s6kags4kaml4skane4skano6skant4skapp2sk2ar5skard6skars4skart4skates4kedas6kedoskel3ts4kelus3ken_s4kenas4kenos5kens5skepts5ker_s4keros5kerss2ke1sske3siskes4mske5sn5s6ki_5s4kiks6killskino65skiols4kiresk5irss6kis_7skiss5s2kivs6kje_3skjor5skjøn6skjøp2sk1k42s1k2lsk5laks5klassk9legs6kleisk3leksk5lits2klyd7skodd3s2kog2s3koi3skoles6koma6s1konsk5ords7kors4skort3skotts4krat6skreg3skrib3skrif4skrig3skrik3skrip3skrivs3kronsk6rud1s2krå2sk1s22sk3t41s4kuesku4er3skule4skulls4kulp4skultskum3s8skurvsk5va_3skvadsk3vass6kvensk3versk5vitsky3re6s5køaskå5resla8das3ladesla5gesla5kes5laks3slakts5lare4s1laus5laus3slaves8ledas4legis4legns6legrs4leivs5lekks4leme8s5less6lesjs4lesos6lests4letas4levasli5kes4likk4s5livslob5bslott48slu7a2slu2eslu5ess3lunds5lunsslu7sa1s4lyn4s5lys8s5løpslø5vaslø5veslø5vi5sløydsløye79s4lå_3smak_s4med_s4medes4medksmek7ls4mekt2s5mens6mesis6mil_smi7las6milesmini6s6mulas4mulds6mule5smurt1s2mørsmør3ss8mått4s3nas6s3nats7nektsne9sasnes9vsni6gl3s2nil6s3nin3s2nip5s2nit2s3nivs5nord6s7not5s6nud5s6nø_1s2nørsnø5viso4da_so4fagso4fas6s5off5s4oi4so4la_sol5avso4le_sol5f61so7liso8lo_sol3s2sol5t4so4lum4s1omg2s1omk1som5msom5sls4omst4somsy1s2omt5somt_6somtaso4na_son7da7s6oneso8neaso4n3osons4kson5stso4ny_2s1o2pso7pakso9parso7pet3sopp_5soppa3soppesop4piso3ran4s1ordsor4da1so1reso4reksor4gl7sorisso5riu4sorke3sor5s7s8ort4s5oscso8se_so8te_so4trasot5tesot4tiso4ve_so5ven5sovet7spak_7spaka5spake8spakks3pall5spalt3spari8spedaspe9dé1s2peis4pent6speri4sperls4perrs3pers3spesis4pests9pet_4spingspi7rispi7ro2s3pizsp9lars4plin3splitspo6ets4poras4pore3sporv2s5poss3pote9sprag5spran5spreis4preks3prems5prio8s7pros3prod4sprof3sprøy3s2pyd6s3pølsre8kasri8e9sri8kasri8masro6pasro6sasro9tesrot5osrå8mas7sablss5allss5amps5sanes4sarrs6seetsse5gess5eggsse5lissel5ss5sen_s5senes4senis4senus6senås5ser_sse7sks4sests7set_s9setss4siffs6siloss3injss3inns5sis4ssis5mss3karss3kofs7skogs4skorss6ky_ss4kyess5kåls7skåpss6narss5nøks4sok6sso5loss4omasso3rass3ovess6pilss4pors5stadss4tedss3tekss5teps7stipss4tråss3tusss3t4vssy6nass7øye2s1ta_stabs3stad3as5tafa3stafesta5flst3aftsta7ge5stakk4stakl6stal_st5ald4stale5stalts3tame3stammst8anes4tanfs4tangst3anlst3anvs7tapas4tapps8tapås3tari4statosta3tu3stave2s4t5b2s3te_3sted_s4teda5stedt2s4tefs4tege3steghs4tegrs2t4eis6tekes4teki4stekos4tekt4stela5stemd5stemn4stemøsten5as4teni6stenk4stenos5teolst8er_6sterrs4teses4tetas6tetø4steve4stevi6stevl5stevn2s4t5f2s6t5h2s3tias5tibes9tibl6s5tidsti5en3stift3stigns4tikl4stild3stiles6tilk6stilns4tilo4stime6stimés6tinis6tint1s2tip6stips4stitt5stjel3stjer2st5n22s3tog4stoks6stokt3stoli4stoljs5tolls9tommst3oms4stonist3opes6tormstor3o4storsst5o4s5stovast3ra_st3ralst4ran4strap4strars4tred9stria5striest3rin6stroest3rolst3ron6stryg4s3træ1s2trøst6røm4strør4strøs4strøy6stråd2st5s64st7t6st3t4r1s2tub3s4tudstu4elstu4er3s4tum6stunn2s4tut3s4tyk2s5tyn2s7typ3s4tyrstyrs36stysksty5ve6størkstø3vestø5vi5s4tåesu7a8lsu6ga_su4ge_su3is5suit5a4s1uke3suk5k1suk5ssu4le_3s4ulfsu4lik5sund_9sundssu4pe_super3su8presu4re_su4riesu4riusurs5ksur4spsu3sansu4se_su4sik5svak_3svake6svakssva4la7s6vams4var_s3varm6s1vas6s1vegs5veies5vekasve4res5verks4verm7s4vev6svikg3sviktsvi4sesvi9ve5s2vorsvor7tsy4de_sy5densy4kersy6kogsyn6sksyn3tesy5rarsy4re_2s1yrksyr4kasy2s3tsys4trsy5tensy5t6hsz3c4zsæ4r1isærle9sær5s83s6økesøk7kjsøk4sksøk4tasø4la_sø4le_sø5letsø4rassø4re_sø8retsø7telsø5tes2s5øy_4s3øya6s5øyd2s7øyss3å2keså4le_sån4daså5pet6s1åpnså4re_sår3skta4bu_4taend4taenh2ta5fetaf7f65tafista4ka_4takauta7kenta5kertak4si5taksttak4tot5aktøta9lamta3lanta7lasta4leita4lektal4lytal3opta6l9ut3ambi4tametta3narta5nasta5nattand5rtandø4ta4nelta5nemt3anfatanfø66tangft3anle2t1anm3tannlt5annotanns4tan6sk4tansvt3anve2ta3o4ta4pa_ta4pe_4tappa5tappi1t4ar_4taram3tarbo5tarbø4tarratar9sitar7sptars6v6t9asftasi3eta4sifta4siltas5s4ta7strta7testat3optat2s1tat3tet3attr4t5augtau4sk6tavin4tavlitbo6datbu8datby7tetdy5pe4te3ag2tea2nte5arb3teatr4teatt4tecel3tede_4tedebte7def4tedek4tedel4tedemte5den5tedilte4dorted4skted4sltefo8rt3efte5tegat4t3egdte7geate9geete4gimte3gla8tegs_6tegsvtegvi85tegås2tei4dt3eiga6teigr3teikntei5le6teinfte5i4s6teisote7kente5ker4tekil5tek1ktek4li4teknute7kra9teks_t3ekse4teksptekt4stek6tyte2k3v2te3latel6ak3telav4teled4telei4telek6telerte4les4telid4telik4telil4telinte4lir4telis4telit4telivtel4lotel3set3elsk2te1lu7telut3temae6temant5emba5temiktem9matem5pe3tempote5nabten8amte4nante4nat6t7enc4tendr4tenedte5neg6tenem5tenes4tenet7tenik5tenis4tenivten9note4nomte5nor4tenotte6novten3saten3sotens5v4tenumte6ora4teord4tepak4tepas4te5pe7tepee4teract6er5d4tered4teref4teregte4rel4terep3ter5gte4rig4terikte4riv4terk_4terke4terkh7terkr4terktter3notern5ste5ro_tero6ete3rof4teromtero6v5ters_ters4lters4hter5sv3ter3tter9toter9ul8terumter5ør4terøt4teråd5tesarte7sen2te1sh4tesid4tesik4tesit4te1sk6teskite5sko2te1sn2te3so5test_4testy4testø4te1svtes8væ2te3søte8sårte4tap5tete_tete4e4teteg4tetei4tetek4tetem3tetik3tetis3tet2stet5titett3s5tetu_te2t3åtevo6rt4hea3thei5mtho7litho3rethu5le2ti1akti5als2tia2m2ti1apti3asp4tidan4t7idé4tidistidvi44tienhtie5ra4tierf4tierkti4ertti3esk4tieta4tiettt8ifråtif5teti9ge_3tignoti6gunti3ka_4tiket4ti5kitik4kj2ti3kotil1d43tildeti3lei3tilfetil3id4tilke3tilkn4tillhtillø77tilnæ3tilsttil3t44tilteti7mab5timatti4me_4timo72t1impti6nab4tinazt3induti4nem4t1inf6t5inj7tinks4t1inntinsk54tinsp4t1int4tinva6ti7omti6platira4tti4ref6tisak4tisam4tisek4tisel4tisem4tisep6tisig4tisio4tisje4tisjutis4ka6tisku4tisty4tistøtiv6istiv5sitiv5skti5ær_ti7ære6t3jag2t1jakt5jarn2t1je_2t1jegt5jord3t8juvtkå8patla4gat4ledrtle5titligh6t6l7uttl7øy_tlå3net6makut2meg4tme3intmini6t4nelit4neskt4nesttnæ6re7toar_tobe6rt3o2blto9de_6toff_t3ofreto5frito7gento4gretog3st2to1in1to3ke5toksi5tolatto5lel7tolkitol5trto9ma_4tom1s5toms_to4nedto4nelto8nibton3saton5spto4ny_4to1pl4toppd6toppgtop4po4topptto4rak6toregto4rekto7rem5torertore4t4torgator7metorm5stor5nators4itor5t84to3setos5keto8sku4tos2pto8ti_to5to_to4torto7vegtpi7netpi7pitpo4et3trafit5ranetra3petra5potra5r45trase5trasét3refu6t1regt5regi6trek_4treke4trekl4trelatre5net6rengt7repet4rero6tresitres4l3tresnt5resut4retat6retotre9va4t1ric4t4ridtri7eit5rig_t4rikkt8rina3trinn7t6riot4risttri5totri7vi3t4ro_tro9ar3t2roitro3int6rondtros3l7trua_5trued5truet5truknt3rullt3rund4trupet5rutat3rutet3rutitry3dr3t2rygt5rød_t5rødt5trøya4trøyr6trøys5trøyttrå4drt6råklt3råstts4angtsau6rt6schatse4erts5egetsei4dts3eigt3sen_t5senst5ser_t3seritser3ot4seskts3etats1e4vts7illts3innts5jegts5jort7sjukt4sjurt5skadt4skants6kists6kjøt5skolt7skottsk5ruts5krøts1k6vts9kvits6ky_t5smitt5spekt3spelt5stadts3takt5start5statts6taut3stedt4stegt4stekts6tigts4tikt4stint4stitt2s1tjts5tonts3trytsu7gets3ulits3u4rts5usit3sviktsø8katt9abott5adrtta9frtt3aftttall4t4tanst4tanvttare6t4tarrt4taset4tasjtt3avitt5avktt5avrt4tedat8tedrtt3efftt7eidtte3intte7kvtt5emnt5ten_t4tenat4tenitten5st5ter_t4teråt4teset4tesit4teslt5tet_t4tetat4tetett3indt5tinet7tinét5tingt4tinit4tisjt7titettlin5t5tofrtt5om_t7tomrtt3oppt5toratt3ordtto5rett3ormttpar4tt6påstt3ramtt3raptt7rattt3restt3revtt5romt5tropt2t1røtt7saftts3artts5kjtt3soktt3ugltt8utett6vuntt1y6ttt3ø4l4tu4avtu4be_tu6demtu4er_tug8la6tungdtung9s6t5unitu4niotu4rastu4rektu4rintur5s4tur3uktu5rustu4sintust6rtu8va_3tvang8t9var3tveit4t7vertvert53tvet_7tvetstvi5lat6ving3tvungty4medty4ne_5t6ypety4petty4rak6tyregty4repty4ri_tyri9et3ytelty5tenty4ve_5t6zel6t6z5ltær4ertær4ettær5s4tø9kettøk8ta5t4øm5tøp5setør3in7tørk_9tørka5tørketør5netø5ta_t9øyemtøy5tetå4en_tå2l3atå9la_tå4legtå7leltål5s4tån8datå6pe_tå6re_tå4rept3året4t5åri3t8årnt3åtaktå7tenu5ars_ub7altub7antub5arkubel5subis7tub5rinuch5enuch5eru7das_ud4dagudeie5ude3luu6derou3d2etu5devoudi3anudi4enud5legudy9raud5å4suem8nauend5rue4re_ue5renue4rerue4resuerle7ue4skjufi5neufor3suf4tanuft3spu6g5avu4gerøu9get_u8getaugg3s4ug4le_ugle7sug7ne_ug5s4iug5øynuid5eluid5eruid5inuista7uit3enuit5erukare6uke5l4uker5iuk8k9lu5klemukl7utu5k4nou4k5oguk3rusuk4sekuk4seluk2s1kuk7skiuk2t7rukts6lukt3spuku5leuk5viku6l1aful3aksul5artul4detule5mau3len_u6leniu3lensu5ler_ule3riu4leroule3stul4f5luli9en3ulikhuli5neu7linjul4k3vul4lagul4lamul4legul8li_ul8ligul8lotullo3vulls4tull3svul2lu4ulo7vauls4poul4tegul4tekul4tesul4tilul4timul7torult3riul9ut_u7lutau9luteul7va_ul5vanul4varul4ve_ul4vegul4veiul4vesul4v3uulæ6raulæ5reulø3seuløy6eul5å6lu6mareu4mendume5rau6middumie6numi9nau4mintum4milum4misum7panum4pleum7se_um4skuum4sorumta8lumør3suna6daun5algu4n3ap6unde_un4dekun4del6unden4undetu9nei_u4nenou3nes_unev5nun4gemun2g1jun4g5lun2g1r1u2nif3unionuni4stun4k5lun7nakun5nesun4nivun4n3yu2n3osun3skrun5s4punst3oun1s2vun4talun4tamun4tasun3t2run4triu7nøyguor8dau3pea4uper3au4petaup3insup6nevupo9peup4pedup4plaup6preup6senup2s3kups4keups5prupåvi6ur3aftu2r1akura6lyu5raneu3ransu5rar_ur3arvu9ras_ur5aspur3attur4bodur4d5oure8alur5egguregi63ureinur3eleu4reliu7reomu4resuu4retau4reteur4e5vur4febur6feduri5neur3innur3insur3inturi6spur7k6jur8klaur4kleur6k5nurma7gur3neaurn1s2urom5suro7piur3oppuro3s4uro8taur4pelur4salur4sinur4skrur4speur5steur4stjurs3vaur2s1øur3teourts4tu6rug8ur7ugluru4keuru7knurumo7urun4gu7runkur4velu9saneus3angu9sar_u5sealu2s1eiu4seleus7erku6sesius3evaus3indus5innus7jagus5kafus7katus5kenus5klous7kruus5linu3sorius5sarus6satus4sjåus4skjus7smiuss7møus4stru4status3tavus3tedu5steius7tenust5ofuston8us5toru6streus4trius3troust7utus3ungusva8nusæ9leu7taggu9tal_ut3albut5aldu3talluta7nout6anvut3armut3artuta1s4u5tas_ut4ba_utbe8dut6by_4utdatut3eksu5temmu9temtu6tenau3tenku4tenuu6terøu4tetau3tettuteva9utfa7s8utgåeu4t5ifutiku9u4tiliu5tjen3utleiut7omsu3trivu3trolu3trosut9rød1ut1s44utseiut4tidut4tilut4tra3uttryutt1s2u6t5unu2t5utut4ø8sutøs7t1utø4vut5øyauve5diuve3inu7ves_uvet5øuvø9reva6ka_va7kanva5kerva8ki_vakt5rva3lanva4led4valelval3lava6l1ova4lunva4løyvam8puvand5svane5sva4netvan4grva8ni_1v4annva4nom5vanskvan3smvan3tivan9trva4ra_va6rakva4ralva4ramva4rapva4re_va4regva6remva4resvar8kavar5mavar4savar4skvar4svva4sa_va9set6vasidva6sieva4sifva4sikva4silva6sisvass5a4vastava3ta_vat7ravber5gvbo6davdu6er2ve1a2ve6ar_ve9dobvedom5veggs4ve3gle6vegre4vegruve4gutve4g5å1vei1evei3en4veillve4ke_ve4ked4vekeevek8lavek8leve4klivek4stvek5to6veld_8velds4veled6velei7velet4velis4velit6veliv5velocvel3sevel3smvel5spvel5st4velugvel5unve8na_4venemve5net4venevve4ninvent6avent4s4ventyve4nusve5ny_4venyave4nym2ve3o41v8er_ver5akver3al8verauverd7vve3re_4vered4vereg4verekve4rel4verepve5rerve9ri_veri3ave7rie4verikver3il5verknver5m6ve9ro_ve3rom2ves4ave5san4veset4veskive9slive1s2m6ve3so4vestr4vestu4vestøvesva74veteg4vetek6vetev2ve7tive4to_veto7eve4torvety8eve6vakve5vanve9varvev4smvev4spvfall4vga6livice5svid3s4vi5endvi4katvi5kedvik5ke3viks_vik5sa5viktivi2l1avi5la_vilt7o4vindl5vindu4vingnving3rvin3na6vinnh4vinntv2in2svi8pa_vi6pe_vis3abvis3akvi4seevi3senvi2s1kvis3omvis9paviss4pvis5tivi4takvi4t3ovit7ravit5revi4va_vi6vesvjet3tvje4tuvk4lervla6gavlei9ev5lesnv6lesvvlu9savmord4vmå8lavne7dev4nelev4neliv4nelov4nerovn1s4tvoks3kvok6s5vo9nalvo9narvon5devon5sh2v1o6pvo9ren2v1orgvors7kvos4sevo4tegvo4telvo4ve_vo6vi_3v6rakvregi3v3ringvrin5svrø3vev7salivs3eggv3s4elv5sen_vs3lanvs6letv6slikv6s7nav4s3nøvs7s6tvs4s5åv1s2t2vs3tilv2s5øyvså7rev5teppvti8navva8lavvi5kevy7ensvæ9retvæ8ta_vø6re_v3ørkevø3se_4våendvå8ka_vå4ke_vå4le_vå3renvå8sa_vå5tesweate7wi9ar_5wi6enwi9er_wi3renwyork3ya4ne_yan7slyb4bedybu6eryd4depy4deroy2d1isyd5remye6dreye4lenye6letyel4skyels3my7e6ney8enery4ensey3e6reye4relyer8sky4erstyf5le_yg4dalyg4dekyg4delyg4depyg2d1ryg2d1yygen5syg6gamygges4ygg3s2yg6g5åy6karay7kel_y3keliy7kelsy4keroy5ket_y9ketsy4kjarykk5niy3klubyk3lusy6koliy4komoy5kosay5kotiyk3varyla8gayl4danylde4syligh9yl4levyl5tety8luse3ylvenylæ7rey4meteym8sa_ym6ta_ym6te_ymå6layndes8yn5detyn7eldyner3gyne5s4ynesi8yn5gelyn4gemyn4g5øyn6k5vynn3s4yn4semyn9setyns7kiyn5skjyn4tapyn8tegynt5eiyn4tekyo4gatyo6gi_yor6day4penay6petay7pingyp5innyp7p6ayp4tokyra8kay7rarby4r5auy7realyre3iny5reisy3relsy5remsyre9ney4reroyre5scy4retay4retey4retoy7retøyr3innyris6pyr4keeyrke4sy3rommy5roskyr4sanyr7setyr6skjyr6skryr3stiyr6tekyr2t3ryr3trayrå8day4rådiy6råstyse4buyse5eiy4seray4sesjy4sesky4sesty6sesuy9set_y7skagysk9auys2k3lysk5øsy4s5orys5pisy5s4poys6sakys6samys4skuyss5peys4stays2s5vys4tatys3telys3teny2s3tiyst3opyte3iny4tekay4tekiy4tenay4tenoyte6royters6y2tes2y3t2hi6y5tilyt5jenyt9jeryt4meiyt4mesyt4re_yt5reryt4rikyt5t6ayttes6yva8lay4vesey6vesyyvi8sayvå5teza5k6hzania54z3ent6zistyz2z3elæk7je_ækkel6æ2le3dæ4lenaælsle9æ4r1akæ3raneæ4ransæ4rarbæ4r1atærbu5eæ8r7eiærei6eæ5rernære4slære4spæ4retaæ9retsærgen5æ4r3ilær3insær5is_ær5ne4æ2r7o6æroms4ær6selæ2r1ø4ærøy7eøbe4liød9de_ø4dedeø4delaø4deriø4deroød4redød4rekød4repøds7keøds4koøds4muød3undø4d5urø3e6reøf8la_øf8le_øfte5søg5re_øg4steøg4strø4keloø6keseø8keslø4kestø4keteø5kjasøk5keløk5ketøk4k5løk3lagøk3lanøk5oppø8krarøk8sa_øk6se_øk4sesøks1t6øks5tiøk5ur_øk5ureø4lediø6leluø4leroø6letaølke7søl6levøl6seløls6t4øl5s4vøl4varøl6vekøl8velømini6øm4medømmet6øm4peløm7s6pøm5sviømå8laø6n5alø3nes_ø9neseøn4nalønns3lønns3tøn9sa_øn5sakøn5samøn5se_øn3serøn3skjønst3rø4pedaø6pe5iø4penuø5peroø4peruø4peteø4petiøp5steøp4s5øø2r1afø2r1akø4ransøra8saøra6siø4r7auør7eddø6reduø6reinørek6lør3eksør5ektø4reruøre1s2ø5res_ø4reseø6resiø8resoø4restø4retaørge5sør4jetør4kesør6k5nør4kveørm9utør4n3uør4n5øø5r6okør4rekør4repør4råtør4sakør6sesør5skiør4skrør4somør4speør3stoør9tarør4tekør6tifør1ø2søseri7øs7karøs4lagøs8tasøs6tegøst5oføst5ovøst3reø2s1ø2øt5asaø6tegeø4teniø3ter_øte3ruø2te1søte7snø4tetaøt3s4pøt7s6åøtt5avøtt5raøtt7riøtt1s2øt4turøug8laøv5ansøve5inøve5noøves4tøve3teøv5reb7øyan_øy4dekøy4eleøy4erføy3ke_øy4ledøy4legøy3pe_øy4peløy4ra_øyri6vøy4spiøy4teiøy4teløy4veiåak6taå5aranåau4reåbo9taå4dereå4deriå6deroåd7sloåd3slååd1s2nåd7spuåem8naåfø5reåg7aldåg5rinå4karbå4kenaå4kereå4keslå5keviåk7lauåk3oppåk5røkå5k8ulå6larbål5au8å4leniå4leteål4sanål4sekål4serål4stiålti5då2l1øyåløy4eål5å6kåm4li_ånd4saånd4seånd4soåneds5åne5i6ånely6å5nes_å4netråpen3så6peroåp4ne_å7raraå4restår4le_års5afårs3elår3semårs3koår8skuår3solårs3taår7steårs3tiår7stoår5stuår5u4kås5eidåse3s2å4sesmå4sesoåse5taås5ka_ås7kopå7steiåtaks5åta9laåtale3å4tangå4tarkå2t1eiåti7daåt4tedåt4triåt6t5æå2ve7då4veniå9ver_",
  3
  "_a4_b6_c4_d6_e6_f4_g6_h4_i2_j4_k6_l6_m8_n8_o6_p6_r6_s6_t8_v6_y6_z4_æ8_ø6_å28aca1ha1ja1oa1ø2bc1be7bé6bg2bhbl26bnb2o4bpbr81by6cb4ccc2dc2lc1mcr81cuc6zcæ51da1de1di1do5dqdr48ds1du1dyd5z1dæ1dø2ea2ece1fe1he1je1ue1vey1é1aé1bé1dé1fé1gé1hé1ié1ké1lé1mé5oé1pé1ré1sé1té1vé5åè1r1fa1fe2ff1fi1fjfn61fo3fôfr22ft1fu1fy1fø4få1ga1ge1gé1gi1gjg1n1go1gu1gy1gåh2a4hc2hf2hh2hl2hnh4oh1p2hr4hthv4h6yh6å2ie2if2igi3hi1ii1j2ik4io2iri1ui5yi1øj1b2jdj2ej1f4jgj1hj2oj1pj1tj5vjy1j2ø2jå2kc1kekj22kkkl4kr6kv26ld1le7lè5lê2lg1li2ljl5q8lvl5wl3z1lø1mam1c1me2mé1mi1mom3q6ms1mu2mw1my5mæ1mø1må1nan1c6nd1ne1né6ng1ni2nk4nn1no7nón3q6ns1nun3w1nyn1z1nø2oa4oc2og2on2ooo4q2os2otow1ox3o1øo1åô4tó7tó8v1pa1pepl61po2pppr62ps1pu1pæqa5qu2r1c4rdr1j2rn4rsrx1r4z1se1sés1h1si1sjsl4s1ms1nsp2sv21sys4z1sæ1sø2tc1te1titr44ts6tt2tz1tæ2udu1hu1ju1uu1vu1wu1æ1vê8vs1vu1væw2aw1bwe2w1lw1mws5wy2w1zx7bx3fx7hx5kx1lx3rx7tx6uxy2y1by1cy1fy1hy1iy1j6yk2ysy1uy1vy1wy5æy5øz1cz1d1zez1fz1gz1kz1mz1pz5rz1sz1væ1fæg6æ2kø1bøg1ø1hø4iø1jø1o4øtå1aå1f2ågå1hå1iå1j6åmå3oås2å3uå1v",
  11
  "_blekk3s4t6_blekk9s8v4_rett7s8kri_sek4s5o6g5anseri8e9nedgjø6re7n6hgjen1opp3s4inseri8e9nentres9kjareonstitue9raonstitue9re",
  9
  "_be6d5ene_blek4k3f_bo4k4en__brudd7s6_bruddså7_de7r4i5v_ein5s6ta_ein8s7to_fem5o6g5_for3d6ri_for7d6ra_fri5e6re_ge5s6tap_hand5s6l_handsla9_høy6st5æ_hånd5s6l_in6n7eks_in6n7ets_in6n7ett_kalve5l8_ka5r6a5v_kor6s5ed_liv8s7u6_mak6t5at_me3ta4ll_mons6t5r_mor3t6a5_nær9ast__overen6d_plus7s6e_rap5s4o4_re5s6tan_san8s7ku_sel4v5i6_sju5o6g5_skudd5s6_skuddså7_sky6f7la_snitt5s6_stein7a8_stein7s8_strek5s6_torsk6e5_tota9la__tre5o6g5_tre6skja_tre3s8ko_ut6e7sko_ve6l5art_ysterie8adsle6ge_akelei9eraktle6ge_a4l5en5tralere6de_alvak8se_al8v9er8mand5s6trean5e6tikaan5e6tikkangs8t9råankra8na_armle6ne_arneva7laasseri7e6assku6le_aus6t7isebaken6de_bi3o8m3s4blesse9nebobba6ne_brevi9er_bunnla8gabusse6te_cerba6ne_dan9s8kandatali8na6d5engen_den6t5antdfø6rararding8s5ending6s5erdleva8ne_8do9b8landomsla6gadyrle8ge_eftle8ge_egøy6e5neeiseri9e8eli5e6rerelo7vers_eme6triskemp9lane_endelø7seentun6ge_erdsto8gae4ri5s6toerland7aser8skarane8s9kjer_esstu8en_5e6s5timaetal6list5e6tasjesetsku8le_fangst7evferi8e5nefis6k5endfjel6lendfor9e8te_for9e8tenforsi7de_forta8le_fri5s6tilfrite8re_friti8me_fronta9lefruta6le_ftsle6ge_fullfø7regares6ke_gart5s6lagenle6ge_gesta7b6lg6ges6tiogi6st5rerglere8de_glorie7ne6gometrisgres6sentgstatsrå7gst7evnengstri8de_hek6serinhimme6l5ohøyse6te_8icanarariderla8gaiktsla8gaildsfa9reili5s6tikin6n7etteio6n5erstipplæ8re_ipsle6ge_ita6l5ersjamhø8ve_jor6d7ervjor6d7is_kan6t7endkelei8ke_6k5en6den6k5en4derkesle6ge_4ke5s4tenket6t7enhkil6le5stkinnsi8dakinsi6de_kinti8me_kke5r6undkor6s5innkos6t5erskrani6e7nkspor6t5r6k6s5porskstev6ne_kterie7nskti6v7endktsle6ge_kumen6talkvari6e5nkyn6skjerkøn6skjerlakterie6lder5s6telder6s5tile6sk9u8tlesse6ne_ling7sen_l6l5e6rikllet6telelob9byar_ltesa8me_mari8e9nemarmo9ra_menle6ge_m5funn8s5mmatik7kamo6te6g6empera8te_mperi6e7nmse8t9jasmuske6l5a7na7bortrnatori5e6nderla6ganditorie6ne9a8r9anned5over76n5en6denngsmå6la_nnomsy8nanor6d5endnormlø7senstar8ta_olele6ge_ordre8gi_ordsa6me_orgi6e5neoriti6me_osseri7e6otekla8gaotshusvæ86p5enden_pil4le5s6pis9t8ra_plun6d7rip8p9ender3pr6in6s5rambu9ensramse8te_ramta8la_ramta6le_ran6n5ett8r7a6telir7d6æ5r6ere7a6r7anred7s6ledren8ne8slrennes9lare6s7kje_res6t5erv7retøyetsrfø8rararrg5s6tillriferi9e8rkeslø7ser6n5apparr6n9a6visrnele6ge_rolle8ge_rolle8se_ronta6le_rote7sterr7rebart_rt7s6trek7r4under_ryl4l5i8sr6ørende_røy8senessand5s6lo5s6a5v6in5se4au3sk6sedvanlesei8e9nessel9s8lagsen6s5endseri6e5nesfri5e6re7sh6e4rifsing4s5a4s8k5e4lev5sk8inns5spe4r5andssari8e9nssi7e6rerssi6v7endste6in6s5v4s5tekstsøren6de_8t7allergtamba6ne_tek6lede_6t5en6denterba6ne_terle6ve_tersø6ke_4te5s4til5t6jingan5t6jingar5t6retteltsje5t6sjttaba6ne_tteli6te_ub7lande_uguay7ansuinnsmig9uk7kestaluktu8e9raulele8ge_umsku8le_unele6ge_un7s6tenkuntun8ge_uran6t5reusove7r6eutse8t9javar4t5i4svatle6ge_verta8la_verta6le_ves6t5endville6de_vit6te6s7vitun6ge_y4d4r5oksyenle6ge_ykke6s5tayns7kjeleys6a7kersysterie7nyttsa6me_ønn4s5i4døn8skjer_åkøy8rar_åle9s6und",
  5
  "_ad2r_af7f_ag4r_ak6r_am7b_a6me_an3n_ant2_ap8t_as5s_at4h_at3s_a5ty_au6e_au4r_avi2_bok5_bon2_ce6b_cos1_da2m_de4u_di2a_du4a_ecu6_efo7_ege2_egs4_ei3l_ei3m_ek4r_el3k_el5l_el6s_em5p_en5a_en5t_ep6t_er8a_er4e_es1k_es5l_es3p_es6r_et4s_fa2e_fe4e_fe2l_fi6a_fol2_fo2r_fug2_ful2_gaf7_gas4_ga2t_ge2a_ge4o_gha5_gi4n_gi4s_gos7_gus1_gå4v_he2n_hi4n_ho2d_ho2e_høi5_i3a4_i3bl_i4da_ik6k_ik5t_i5kv_i3la_i6me_in5s_i6sa_i3sc_i6se_ist6_i5ti_i3va_i3ve_ja6e_je2a_je2l_je2m_ju6a_kaf2_ke6e_kel3_kir2_kø3s_le2f_le2t_li8a_li2g_li2k_lo4e_lo4i_lo8o_lu4d_lu2e_ly8e_ma4v_mne6_mo5v_mur7_mø2t_nak2_na4r_nat2_ne2s_ne4t_no6e_no4r_nu4e_ny5a_ok1k_oli5_ol6m_op7r_opt6_ort6_osa5_os4k_os4s_ot5r_ove6_ov5u_pe2p_pi6p_pi2s_pøn3_ra2m_rei2_ri2d_ri8e_ro4e_ry2e_rød2_rø1v_råg8_sch6_se2b_se2e_se4i_si2d_små3_sne3_soa8_s8p6_syd5_sær1_ta2s_te4e_te6i_te6o_ti8a_ti4e_ti4s_tsj2_u5a6_u1b2_u3d2_u7de_u3e6_uf4f_u4ga_u5gi_ug8n_ui6m_u1k6_u6ke_u7kn_u3le_ul5t_u1lu_u1ly_u3lå_u5ma_umu7_une8_un2n_u3no_un4t_u5nu_u4pi_up2l_u2ra_ur4d_u1ro_ur1s_u3ry_u5rå_u1s2_u5se_u5sn_u7sp_u3tu_vai4_vi2e_vo6r_vå4d_wa4r_wi6e_yns2_yr6t_yt5t_øi6e_øko5_ør5k_øs4t_øv4d_øy2e_øy4n_å6k4_ål6t_å6se_ås3k_ås7l_ås3m_ås5va3afta1aksaak5vaa3laa1a2na6an_aar5n3aasea6babab7av4abevabie6abl7uabo3babo3eab8reab2slabu5ea4bufa4by_a4byba4bykaby3ra6ca_a5dalad9daa2deba2deka4dela2deoa2depa2desad8ge1adjuado7aa4dob4adora2dread1roa7drøad4siad5un2advea4dy_2a1e2ae3deaed7raek5ta4el_ae5laae3liael5oaen5taes4ta4fe_afei5afia1a2fiba5fjoaf3leaf5li1afriafs1laf5yrafø4ra2gaaa5gaeag5dea2gemag5geagg7ua4gi_ag5idagi6sag1laag5låag1ora5gosa3gotag5ovag1reag1riag1råag2slag2sya6gu_ah4n5ai1a4ai3e2ai4isai5koai9kvai5nea3inga1innai1roais4eai8smais5sai5veaja9da8je_ajes74aka_6akaf6akan4akarak4aua9keca2keha6kek4a1kia6kida6kikakis12a1kjakki4ak6kjak1koak1ku2ak1lak5nea5kno2a1koa5kona7kosak1ruak6sl4akso4aksr4aksu4akthak2trakut2ak5øl8ala_ala4ga5laha1laiala4o2alat4alaual1aval3de4aldoa2lefa2lega2lema2leuale5v2alg_al2gua2limal1joal1jøal6låa5lo_a5loial1oma1lonalow7al3psals1lal2sn6alsual1voalv3s6a1lyal3øva4maha2maka2mala3manam5bea2meia2mekame5uamhu76amn_amo5eam1opam1oram2påamru4am5råams4lamst6ams2vam2søam3ti5amtmam7tvam6ulam5yram5øy6ana_8anan4anar4and_6ando4andsa2neda2nem2anen2anera2nevang4eania7a6nib4aniv4anki4ankjan4kø2anlaan4nyan2nøa3no_2anoga6notan4sn2ansu6ansyan4såan5uta4nyaanær8a2nøkao6k6a5peaa2piaap1ida6pika2pioa1plaap3liap9loap2ly4apola4pona4pooapo3pa2potap3raap2s1apsa4a3psya5på_2aran2arar2arba2arbi4arbj6arbl2arbo2arbr2arbu2arby2arbø4arbåa4reba2reda2refa2reia2reka2reoa2repar4eta4rev8a1ré6argjarg4lar7go2a1ria3riba4rima2rivar3ke2ar2nar3niar3noar3nuar3nåa1ro_a5roka1ronar1opa1rosa1rotar9po1arraars7æar3te4artn4arto6artr6artu8artyar1ular1una1rusar7æ6ar1øyar7åp4a1saasab4asak4as6anasbe2a2se_asea4a2seda2sega2sekas4ela2semas5hua4siba2sipa2sira2sivas4jaask2ia5skja1skras4kva4so_as5ovas3peas5plas2sjas1taa1stjasu3nas1vaa6sym4ata1at6afatas4atat8a2tauatch5a2teaa2teca2teea4tei4atena2teo4atera2tesat3joato5aat1oia2toma1tora1traa9tru4att_att1oat1tra2tuta3t3wa3tå_a7tåaa1tåeat5år8a8ua4au5b4a6ueau7enau7er3auguaul5lau5luau6moa5undau5riau1ruau1saau1soaus5sau1suaut6aau5te1autoau4tyav5aba5vaeava7g6aval4avas5avbi2a1vea2veka2vesa2vev1avfaa1vika1vin2avira5vitav7naa4vokavo3ravo4vav5riav1saavs2iav5su1avviav3øl4a1våawat4ay5ara5y4tazz3obaby5ba5clb5addba3dibad1sba3ki4bakrbak1vba3labal3jba1lobal5tba1luban4aba3reba3riba5ruba3siba2stba1tab6bakb3be_b4bebb2befb4begb6behb2beib2bekb4bemb2beob3berb2bevb8b1hb2b1lbb5opb2by5bby3ebby1kb2dekb7denb4depbe2aube5edbe6efbega9be4gnbe5go4behube5kebek6l4beksbel3ubel5vbe4nabe3nebe5niber5dbe1robe1ru5bes_6besjbe3snbe5spbes3sbe6så3b4et5bet_be3te4betube9vobev9rbeån9bi5akbi5cebi8débid6rbidu8bi5el4bifabi3kabik1kbil3jbil1o6bi5mbi7nobi1robis2abi3seb5ish8bisnbi4spbi1stbjar3bjø6r2b1k4b1larb3latbla4ub4lefb4lekb3ler2bletblja41blokblå5nblå3rb3ne_b3nerbo2blbobs4bo3debo2dø4boef1boenbo2erbogn7bog1s3bok_bo2kabok1ibok1kbo2kubo7li1bombbom5mbo6mo4bonnbons4boom1bo1p4bo1rabo3rob4o1sbo2slbou3c4bo1vbow4e1b4rab6revbri5ab4rio3b4rubråe6b5s6ib4slibs2t6b7s6vb7t6sbu4arbu3dabu3debue5sbu6is6bukibuk3lbu5la2bu3obu3rubus6ebu1st4busybu1tab5utgbu2tubu1tøby5alby2erbyg3lby1lo4byløby1re5bys_4byse6bysi6byspbyst44bysvby1trbæ3ribæ3rubøne5bøn7obø5tabøye5bå4debå4labå1rebå6tobåt5rca5leca5meca5mocap1rca3racar5nca5rocash5cath5cebo9ce5le3cen_5censce5o4ce3recer3t6cerucha5t4chei4ch3hch5nechom4cie8ncil5lci3neci5tack1enck1o2ck5s2ckup3ck9utcoat51co4cco5macom5tcon5scon7tco7paco1reco4so4costcre2ecros2cu5lacu5lecu5lucup1lcu6pocup1rcup7scu4påcy6p78dabod5absd4adgdadø44daef5dagb4dagjdag7l4dagå4dahe5dahl2daka4dako4dakrda5kvda1lada1luda3mo5dan_d8ane9dani3dann7dano8dany2da3oda3ped3app3dar_5dara2darbd5arnda2ro2dash6dasida4sk6dasudata5d6aud2dautd5avbd1avl2d1b2d6byfd2dadddag4d4dakd2dekddie8d7domddsa4d2dybddør3dd1årdeak3de2al2debe4debl2debo2debr2deby4debø5ded_2deda2dedy5dee_de7erd5effd5eft5deggde3gldei4d5deik3deir8deka2deke2deki2dekj5dekkdek2lde5ko5dekt2deku4dekv4dekø4dekåd4el_d4elsd4elt4dely4delæ2delø2delåd3emb2deme4demj3demr5dems4demu2demø2demåd2en_4dena4deni4denod2ens4denu2denæ2denøde2obde4og2deol2depe4depi4depl6depuder5dder5kder3tder3v2derå2desa4desc2dese2desj2desk2deso2despdes6v2desydeså7d2et_2detade3te2deti2detj4deto2detu4dety4detø6detåd1eur5deusde5vu2d1g4d4geldgi6ndhø4rdi6akdi1ardia1s2diavdi1erdies43diff4difødig7g2digjdi2gudi5ka2dikj6dikn2dikodik7v2dilidi5ma2dimo4dimådi5nadini42dino2dinv4dinø3diog7diol3dipl5dis_di6scdis4id6iskdis5sdis1tdi5sv2disydi7tediv6i2divu2diøkd1je_d1jen5djupd4jø_2d5k2dko2r4d1l4dla4vd2lefd2leldli4fdmo4edmo8s2doavdo2b34dobado3be2dobådo4dadodø44doeud3offd5ofr2dogr6do5ido3ki4dokndo5le4dolj4domldo4modom7p2domrdo4mudon5g3dopido1redorm8do3ro5dorp3dorrdors6do1ru5dos_do1sk2doso4dosp2dost4dotrdo5vadov9n2d7p8d1ra_d5raa1dramd1rar2dre_2dredd5rej4drel4dremd1ren4drer4driad2rik3drukd1ruld1rumd3rup2drykd2rysd4rømd7røtd1råd3dråpd5sa_ds1add1sagd1sald2sasd5se_dse4dds1efdse2mds1evd2s1id7sild3sird2sjods6jud1skjds1kods1kvds3mad6smods3neds5nods1o2d7sotds2pids5s4dss8tds1tjds3tvds1u2d5sykd3synds1ytd2s1ød6sørds1å6d3t4adta4sd3temdt6økdub5bdub5ldue5s4dufo4duguduit6dul5l4dulydums2d3upkdu2skdu2sldu2spduss4dust4du2sv2d1utdve6sdvo8r2dyba4dykl4dykø4dynkdyr5ø7dys_dy8sa4dysedys7sdærs4dø3grd5økndø4madør3id6øs_dø9vadø1vi6døvl2døy_døya8døy8gdå5rid3ås_d7åt_e1a2bea2gue1a2ke4akr6eakte1al_ea2løea4m1e5amne2an_e4aniean7nea4peea2ree3aspe1assea7taeat8he8atoe1atteau5s2e1b2eba3deb3beeblæ5ebob3ebø6ne5chae3come2dade2dare3de_ed4ise7dived8obe4doled1oped1oved2raed2smed5taed3teedt6redu8aed7vae3dykee3dieeg6nee5gåeei4deek1eee3lae5enbeen6keen5te3eplee8raee3rie3e6tef7eaef5efef3feef3foe5fig4e3fjeflå3ef2sjef2skef2spef2taeføy9e3gafe7game2gemegg3legie2eg7lyeg6noe7gnåe4go_7egoiehea4ehog5ehov2e6hå_2e8iae8id_5eidf5eidge1idreie5dei8egeie2nei6esei1fl8eig_ei3gaeig6eei5giei6guei1krei6moein1dein9fe4ini6einvei5orei9paei3peeip5sei3rieir5se4iseei2toei3vi4e1kae4kese6keye4ki_4e1kjek1kjekk3lek6kuek4kye3klue5klæek2løek3noe1knue5knøe1k2oe4ko_e4kov2e1kre3kroek4ryeks1k1ekspek4sæ4ektoe1k2v6ekve6e5kw2e1lael1alel4chel5do4elede3leee2lele2lem4elenel5fiel5gie9liee4lifel3knel4læel5mu2e1loe2lomel1opel4otel5phel3siels1lel2søel2tue3luae3luke7lume7lupe1lure7luselv1r4e1ly2e1låel1åre5låte2made2mahe4mame4mibe4mig4emine6mirem7jee5mjuem5le8emnd6emniem1opempo3em2snems3ue3muge2mukemy4kemø8re5møyen1akena2vend5l1endren7dø4enem2enen4eneveng6aeng4r4enhje4ni_e2nife5nir2enna2enneenn2ienn2oenn7øen3oken3ogen1open3sien1sten2søens7åen3ti2en3ve4ny_e2nybe6nyre2nys4e7næenæ8menø4ken1åse6obeeo2ble1og1eo7gre2o1ie3okseo5nee7onke3onteo3paeo5pleopo3eo3preo9ree2orieo1roeos6le2o1uepa3tepe6pe3pese6peu3epidepp2seps1tep2suept6r2e1rae2rafe2rauerd2eer1drere4t6erfi4erfre2rid4eril4erka8erke6erkn4erkrer3meerm1ser2noe3roae1roee1roge1role1rome1roner1oper1over3ra6ersa6ersjer1sker1sl6ersper1su4ersver1så2erta4ertse1ruae1ruie3rume1rus6erviervs3e1ry4er1yrerys32e1rø2e1råe9rå_erå6eerå4kerå6te6råves5aae2sadesag6es4ale3seke4seue4shae4shie1shoe4silesi6ve1skje1skre1skue5skye1skøe7skåe1slaes2noes4nues2ny4e1soeso4be2some1s2pes3pl4essues7såe1stje1stu8eståes5ut2e3sy4eta_e4taee2tafe3take3talet4ape8taxet8ete3tit2e1tjet3jø2e1toe4tot2e1tr8etreets7let2sø2ettiet2tjet4tret2ty2e1tu2e1tyeu2keeu7kre3u2neu5nue6upkeure42eurie3urneuro1e3urteu4sieu1tae3utseut7te4u3z6eved6evegevi4eev2naev7nue4vreev9råevs8vevti4e1y2de1ynge1y2te7ytiey3treåt8té4n5eè2redè2refè2repè2revè6vesê8lanêr9sl4fabofa1cifa3de6fadmfa2gifa2gofa2gr2fakrfa1kufa1lafal5mfa4lo5fane4fank6fanufa3rafar5nfart24faryfa7sa2faslfa1tofat2rfa1vø5fea_fe4da3fedefe2dr2fe3g2fehj4fekl2feko4fekrfe5li2felofem9bfe4mofem5s5fen_4fena4feni5fens5fer_7fernfer2r3fes_2fesife2st4fesyfe5tif7fa_f4fabffa7lf9fasf6fatf2febf2feef6fehf2femf2fesf2fibf2fidf2fipff3laff3liff4olff1roff5slff5t4ffu6rff5ut2f3g2fia7lfia4n4fiapfici7fi7difi1erfi5fifi5fofi7flfi9kafi5ko4fikufi3lifi1lo4filæfin5d6finj2finsfi2nu7fio5fi3rafi3ri4fiscfi2sk4fitrfi7tyf1jegf5jen2f5k6f4las2flegfle6if4lekf6lelf3levflus8fl5utf3lønflø5sfo9ar6fobsfo4lufo4nafond2fo5nefor1aforh6fork8for3nforo6for5pfor9åfo9se4fosjfo4tafoto5fot3sfot3t4f1ov2f3p2fpo6efra5lfra1sfra7vf2re_8fregf4rekf1rin6frocfro7ffrus1f1rytfrø5bfrå9rfsho6fs5ovf4s9vf3ta_fta7fft1akf2teaf3tedf4teef2tegf2teif2tekf6temf2teof5tog3ftonfts1kfts1uft5t4fu6lefull3funn2fu7rofuru1fu6skfut4hfutu1fy5lafy1refyr7kfyr5tfysa7før6afå5rifår7ufå7va4gabaga1bo6gabøga3da4gadg2gadmg3aftg1aksga3kvga1la4gamb9gane4gann9gar_2garbgar2iga4sc4gasp5gastga3tiga1toga3tr9gav_2gavd4gavgg5avk2gavt4gavvg6bykgde3ag2debg2demg2desg2detgd5opgd1orgdy4d2ge1a6geba2gedr2gedy2gedøg5eft3gefæg5eggg1eie3geit2gek2ge9klge3kng1eks6gekt5gel_3geli2gelo4gelu4gely2gelæ2gelø2gelå5gem_2gema2gemi3geml2gemo9gemr3gemsge3mu2gemy2gemø2gemå3gen_gen5kgen3n4geny4genæ4genø5geog3geolge5on6geop3ger_ger3nger5pger5v4gerå5ges_2gesa2gese4gesige1sl4geso2gesu2gesy6gesæ2gesø5get_2geti2getj2geto2getr2getu2gety2getø2geve5gevågfe2lgg1eig2gemg2gevggie6g4gifgg4jeg7glug3go_g5gosgg4sygg3søghe8ngh4to4giakgi1ar6giavgi3de4giek3gien5gier4gifa2gifo4gifr4gifu2gigr5gika3gike4giki3gikk4gikugi5le4gimi4gimø4gino2ginvgio4r6giragi3regiro35gis_2gisagi3se5gisk4giso4gispgi5tagi7va4givo4givu2gjazgje5fgje2n3gjer2gjob2g1ju2g3k2gkly96gla_4glagg1lar3glatg5laug2lef6gleig2lekg2lel4glen4gler4gletg2levglig14gliogl7jag4lo_g2loa5globg4los6glov5glugg5luk6glungl5utg5lyd3glyfg2løg2gløsgmo4egn1akg2navgndø6g2neeg5netg2nevg4nibg4nidg6nikgni4sgn5k4g2nomgn6smgn5t47goango1argobe5go4da2goddgo9gago3lego5logo4lå7gommgo7nigon9s2g1op2gordgo1re2gorgg4orig5orvgo5røgos3p4gost6gotogot6r2g3p64grab6gracgra5tgra4u2grea2gref4grekgrib34grid4grif4gritg4ron2gryd4grøy6grådgråk4grå7ngsam3g2sasgs2cegs5efg2segg2seig2sekg2semg2sergse4tgse2vgsfø2gs5isgsi2vg5sjig2sjog5sjåg6skvg5soggs2pigs3s4gst6egsu5ggs7vægsy2dg7symgsy6tgs6øtg9t6egt7svgty8egt9ytgu2digu4elgui4dgul5ogul7øgun4ggur2ggu4rigu4stgu1ta2gutb4gutd6gutgg7utl4gutn2gutsg9y8agy3ne4g5økgør3s2g3øvgøy9agøy5ngå6as4g3ångå3sthaba9ha2el4hafiha3gaha5kaha1laha5luha5maha5moha5nahani1ha4pehar5kha4sjha2slhas5vhav4aha1viha4vohav1ø4havåheb5nhe3geheia33heimhel1ahel3oher5jhe1roher7phe2sphet3thi5aohie4nhi2ethi4f1hiff2hif9rhik7ehins4hi4plhip3phi1rohi2s14hiskhit7ohiv1shjar4h5lanhma8nhne6nho6daho5dyhogs6ho2lahol5lhols4ho4luho5raho1ro2horthos5aho4véh5s4eh5terhu4dahu4d3hu4erhu4gahu4lahu5mahus1ahus7mhus1thu2søhu4vahvas5hve2rhvor5hy2blhy8sahys5thø4nahø1vahø1vehø1vihøy5khøy7nhøys4hå8lehå1rehå1rihår3shår7uia9ali1ablia1boi1adjia1g2ia2geia1inia1kri1aksia5kui1al_ial1ai2alfial3gi4alkial1uia2løi1an_i2anai5anki1anmi1ansi1antia7nøia2pai3appi1ar_i2arei6asii1asmia4spi1astia5teiat6ri1atti7aukib5boib3buibo4eibo7nib3stibya7i5dali3dasid1av2ide_i2debi6def2idenid9na2idriid2s1idse4ids5lids3tid2t13idyli3dyrie1a2i1effie4geiego4iei6di1eiei3eigiek8li1eksi2elei1elsi9eltie3meie7nai2endie8néien7nie5noi5ensie5nui6enyi4erdi2erii2erli6eroier5tier5vi2e1si6es_ies4cie3seies5si2etaie9teie5téif2faifi6eifjø8if3leif1reift2si2gaei2gavi6gebi2gemi3geni5gibi4gimigl6dig5noigof6ig1omig2raig2reigs2jigst4ig1unig9utihen3i4huki7is_i6itai1k2ai2kabi2kafi2kaki2kaoi2ke_i2kedik9eiik4klik2koik4krik2kvik6kyi5klæi2koai2kobi4kodi4kogi4kohi2koki2kooi2kovik2ryik2sail7afil3alila5til5avil7dji2lefi2leki2lelile1sil5geil1gli4lidi5likil1jeil1joil1juilke3il5kuillæ4il4miilm5si1loei4lomi5lonilo1wil3slils2pils2til7suilu4hi5lukil3uni5luri9lusil1util5v6il1å8ilår6i2madi2magi2mami9mani2mapima5si8mb2i4meei2mekim8eti6meyi6mogimo9limp4l1impoimp9s1impuim9sei3mø2i4nagin2ani2napi6nauince2ind7åi2nedi2nevinfu94infyin2gring2s6ingui7niai2nibi5niei4nifi2nigi4nilini7mi2nip2inn_1inng1innt4innæino5ai4nodinok64ins_8insain3si6insj4insk1inspin2sv8int_int2rinu6iiny4iiny4tin7øki7nøtin3øvio1a4i1offio5gni1oksio3leio3muio4nuio1pli1oppio1reio1sti5papi4peeipi1ei2pleip2pri6praip5ruips1aip2siips1ti5py7ir5deird5sir6eki3reri3retiri4airi9tir5kvirk5øir9méi5roai1roei4roii1roliro1sir3reirs2pir3tairu8mi7sasisch5is3coi5scri2sedi2seii2seki2semi2sesi2seui8skeis1kris1kuis1kvi6sluis5neis5nu1isol3isotis1ovis5sii2steis6téi2stris5ufis5ulis1unisy5ris5yti4søyis7åkis3åritau4i4tavi4teci2tegi2teoi2tifi2tioi2tipiti3ri2tiuitiv4it7jiito9ai4tomito4sito8vit1sait1snit4tjitt1oit4trit4tyitu5eitær1i5tå9i5u6li5um_ium5miu4moiu5se4i1vai4vadi6vaji5vali2vegi4veii2veki2veviv7omiv2siiv2skiv2sliv2sniv4soivs5vi5za_i7zasi1ø4ki1ør_iør5iiør5siø3seja1akja9arja4daja7en5jag_jag6rja4haja4hvja7kuja3loja1lujam7b5jammjams2j5anl6jarøja6råja7seja5taja9vije5akjeb9b4jedrjeep16jeevje2fjje5ge6jegl4jego4jegr4jegy2jeka4jekl2jeko4jekøjelt3jemp6jen1d2jenijen3k4jenl4jeno4jenu4jenæ6jerå5jesf5jeshjets22jeu64jevejib5bji7e6ji7roji6sjj4kapjo4flj3omrjo5nejon7njons1jo5rajo1rejo3sejour52j3s2jubi3ju9boju3deju2dojue9s5jugo4ju2kju3kajull61jungjup7sju4raju9roju3ru5juryju1tajut5ojy2p31jøa_jø5b42jøef4jøeg6jøei2jøekjø3grjø9kjjø5mejø5pajø3rujø1røjøst2jø5tajø1tr4jø1v5kaa_k3aaska3atka7bo4kabyka3da4kadg2kadr5kadu4kady3kaenka3fe2kafoka9fr2kaft6kaføkag2r6kajo4kaktka3kukal2ek6alkka1lokal3p7kamu1kana1kanekan4i5kano1kant2kap_ka5pe1kapp1kar_1kara1karb1karf5karg1karmkar3n1kart5karu4karå7kas_ka4sk6kaspkass6ka4stka1tokat7s6k1b4kcen4k5d6vke9al4kebrke5dake5de2kedikedu64kedy2kedø2keeg2keek2keelke4ep2keevk3effk5eft2ke1gk3egg4kehjk1eigke5ilke1imkeis2kek2lke3knk1eksk6el_2kelakel5lkels4kel2tkel5v2kely2kelæ2keløke3ne3kenfke4niken3kken7n6kenøke3on6kepl3keri3kermk4ert2kerå5kes_2kesjkes1v2kesykes1å2ketake3te7keth2keti2ketj2ketokets22ketu2kety4ketæ2ketå2keu2ke5urkev2ak1evjk3evnke3vrke2yt4k5g2kh5akk4harkhe4oki3drk4ie2ki6elki5g4kik4ski5li4kilj2kiltki7lå6kindki5ne2kinf1king2kinnki2no2kins2kintki6nu2kinv4kiol7kioski5peki5reki5ri4kirski3seki7ti5kitokiv3skje1s6kjorkju9r1kjøpk2kabk2kamk4kaokk1avk2keek2kehkk1eik2kirk1kjakk5jukk1lokk1lykk3lækk5nekk5nyk1kodk1koek6kookk1opkko7sk4krakk3rokk3rukk7røkk7råkk1skkks4lkk3t2kk5ukk2kvok1ky6kkyl4kk5yrkk7ytk2k1øk8kølkkø6rkkøy6kk1å24kla_2klak2klegk2lem2klet8klia4klig1klip4klit1klos2klov4klunk5lydk6lør6kløskmål22k1n2kno7g5knop3k2nu3k2nykny4skn3øy9koa_ko7arko2b3ko3boko5da4kodd2kodø3koef4koek4koel4koes4koevkog3lko4guko6gåko1inko1ki4koko2koku2kolekol5p4koly2kolå6komg2komr4komu4komåkon3dko4nu1ko1o4koomko5pa4kopo2koprko1rako3ri4kormko5ru2kosako9siko2skko1sl2koso4kosø4kotrkot2s4koty2kou4kout3ko1va4kovrk3rad5krag4krapkra4u1krav4krei6krek2krel6kreo2krib4krif4krik1krimkri2pk2rit6krivk4ropkro3vkrum33kryskrø3v4krådkråe65kråkkrå9mk3sa_k7sask2sedk2seeksfø4k5siak2sifk7sioks1kjks5klks1krksk8uks5lok6sodk4sogk2sotks1ovks1prk3spyks3smks1tjks1trk2ståk6sunks5ærk3så_k4såpksår4ksåt4k5ta_k4tagk3tedk6teektem8k5tibk3tilk5tirk2tjakt7jukto9ak2tomkt1ovkt2rokt3t8k4tukktør7kt1øvku9anku3bjku4etku7iskuit6ku5li3kull1kultku6mikum2s3kumuk6unnku7ra1kurskur3t1kurv5kus_5kusekus3tku1taku5to2kuts1kuu8kuøy6kve7e2kves4kvid2kvivk1vog6kvokk4vot4k3væky6elky2p1ky8sa4kysek1æt3kø2arkø2er6k1økkø4lek3ørrkø5sek7øyd4kåkekå3lekå5nekå1rekå1rikå2t54labala6bl1labo4laby4lad_l6ade4ladg2ladm2ladr2laei4laepla3fl4lagglagi42lahala5ka4lakjl2akkla2kr4laktla5køl1alk4lambla3molan2c4lanl4lann4lanvla7pila8pl2larb5larfl2armlar3n4lartla6scla5sela2sk4lasml6astlas3vla1tala5ti4latmla1tolau7a2laudlaue64laun4laur2lautl5avh6lavs7lavåla6y52l1b2lba4kl4boal6buhlby4el4ce_l7da_l2debl5denl2depl3derldo9al2dolld1ril7dryld1røldse8lds1kldø5dldø5lld7øyle7agle3akle1al3leasle5at2leda2ledo6ledu4ledy2ledø6leei6lefa2lefi4lefl2lefrl1eft6lefy4lefø3legele3gi4legj2legu2legå2leinl6eit2lekalek6ele3ki2lekj2lekn2leko2lekr2leku2lekv4lekø4lekå2lele2lelo3lelsle1lul5elv2lely4lelæ2lelø4lemale3me2lemo3lemr2lemt2lemu6lemy4lemø2lemåle5ni2lenø4lenå5leolle5pa4lepoler5dl8erele1ru2lery2lerø2lerå2lesc2lesples1v4lesø3let_2letj2leto3lets2letule4tv2lety4letø8letå4leul2leunl1eur2leut2lev_lev5n2levolev1r4levs4levæ7lét_l4fa_l5farl5figlf5jal7fjel4foml4futl6gaflga5tl2gedl2gemlg1lolg5lylg3oblgo2dlg1oklg1omlg5ovlg2sklgu4llg3unlg3url6gå_li2amli4asliba5libi5lid3tlie5slif5f5lignli2guli9ki9liknli5ku6lilali3lel6ime4limhlim7rlim9ulin6c4lint2linv2liso4lisplit5j6litnli5toli5tyl1janl1jarljas4l4jedl6jeel2jeil2jeklje3ll1jenl2jevljo8el4jom3ljoslj5unl7jurlj7utlk4anl6k5bl3ke_l2kedl6kehl3kenlk4lil6ko_l2kotlku8tl2lakll1alll4asll3d2lle5al3leel2lefl2lemll6esl2leulle6yl2lé_ll7g2lli1el9ligl2liml3lipl4lirl4livll7k2l5lo_llob5l2lodll3opllsk4ll3t4l8lual4lufll7ugllu4kl5luml3lusll1v4l4løkl5ma_l4maplm3avl5mill7mislm1oplms6jlm3utl4mø_l2nablni4ulo1allo2bllo3de6lofj3loftlo5gelog2olo1in3lojalo1ki2loljlolo96londlo5nelo3palo1ra2lordlo1relo1rolo7salo1sllo7sp2lostlo3tolo1un7lovolpas5l4peel2peil2pell2peul4put2l5r4lre4ilrø5vl2sadlsag6ls4aml4scul3se_l2sedl2seel2semlse2sl2seul6sevl5sigl5sikl4sim8lsk_l6sklls8ksl4skåls5lol2snulsok3l5sotls1ovl2spal5spil4sprl8s7sl5subl3sukls1unl2s1vl4sørl2s1ål4taal4tafl3tall2tifl2tikl3toglto4sl3tral5trålt1s2lt7t8l2tutl5tv_l3tvsl4t5wlty8dlt7øllt3øvlua8rlu7go4luk_lu3kr4lulylu2molu4mø4luntlup4slur2elu5ri1lus_lusa5lus1tluta36lutf4lutglut6mlu1to2luts6lutvlu4val4va_lva6klv4enlv9iml6v3nlv1oflv9opl6v5plv9rilv1s2lv5selvs6llv9tal5vøel3våglvå6rlyes3ly8is2lykjly5kuly7kv6lykøly5me2lymply5okly3pely1r8lysk44lysp6lysyly1trly3vel6z5blæ6talø4er2løkol5ø6llø9melø2nalør5n5løs_lø2saløs3kløs3s6løy_4løya2løyd4løye2løyfløy4g4løymlågs4lå4gålå1k4lå9melå1rulå1sklå5su4lått3maa_ma3arma5br4maef4maek2ma1f3mafr3magnma2gr2mahema4isma4ja2mak_4maklmak2rma1kuma1lamal5lmals4mal3umal3åma3mom4an_ma3nem4anf2manl4manmma4no4mapa2mapr4marbmar5mmar7nma1roma6råmash34masp2masyma1tama3tema1toma1trmau4kmau7lma1un5maurm7avhm5avkma4zema3zom4baom2beam4bebm2befm2bekm2bemm4beombet2m2bibm3b4lmboe2mbo5nm4bopmbo9tmbu4embus52m1d2md7om2mea2me5almea5mmeck42medb4medfme3di2medm2medr4medumed5v2medy4medå2meef6meek2meel4mees4meevm3eff2megr2megumei2em1eig4meki4mekj2mekkme3kn4meko4meksmek5t4melame3leme1lumel5v2mely2melæ4melømen5km6enn2me3ome6os5mer_m4erimer9n5mers2mery2merå5mes_2mesj2mesp5mess4mesu2mesy2mesøme3te2metj2metu4metv2mety2metø4metå2meu4mfav5m2fekm4fi_m2fit2m5g6m4ga_m4gi_mhea4m4hu_mia2n2miav2midimid5jmid4t2mi5fmik6h4mikj2miko6mikumi7li4milæ5mimom7impmin2smi3num4invmi7ov4misami3se9misémi2sk7mism2misy4miså6mitami3te4mitj4mitomi5urmi5våm6ja_m6janm7je_2m3k2m4ko_mkro5m2lefm2lekm2lelm2lemml5jamløy32m1m4m6maimmal5m4mamm5marm2megm2meimme3um4miam2mibm4midm2mikm2neem2nevm6nipmn7skmo2ar4moba5modemo5di2modym1offmo6gi5moglmo5gom5ogs2mokamo8kemo1kimo3le4moltmo3lym5om_4momf2momrmo5nemo2nomon1smo3rem2orimo1rømos4omo5to4motrmot7tmour5m4peem6pepmpes2mp3idm6p5nmpoe4m4pogm6pokm2popmp1p8mps4pm9purmp5ysm9på_2m1r6m9rårm5sa_ms1akm4semmse5smsi6emsk8ums4lym1s2nms9nems5noms3næms1ovms3s2ms2tim1stoms1øymtbe6m2teem2tegm4telmti9amti5em6tifm2tikm4tiømt6vem1u2bmu3elmue7rmues1mug5lmu4hemu5lamull24mulymu3mimum2smun2c4mungmun3k2murnmurs46murtmu4sémust4my3kemyk3lmy8krmy2ramy1re4myrkmy6samy4somøb3lm3økn2møkomø6namør3ømø5semøt9tmå7g2må7plmå1remå1romå1rumå1s46måtfmå5trmå3tø2nabo4nabynadi44nadvn1affna3frnaf7tna3gena7gø4nairn6akk5naklna1krn1aksna7kvnal5gnal3t2naly4nalå5nam_5nams2namø9nan_4nanan6anenan5k4nanyna5pen4ar_2narbnar5s2nartnar7vnar5ønas7h8nasuna1ta4natlnaty52nauk4navd6navf2navgna1vi4navl3navn6navo4navrn1avs4navt4n1b2n5ba2nba3dn6bufnbyr5nbø6nncel5n3chen6cotn2cy1n4dadnda5fn3dalnd5d4n3de_nde5an2debn2dednd1eind6ekn2demn2depnd1jundo9an6dobn2doond1opn2dornd1rin1dron6dufn4dunn2dupn2dygndy1kn2dysndø5l5neaenea4gnea9mne1as3nebb4nebeneck52nedaned3d5nedg2nedoned1r5neds6nedu4nedø4neeg4neei2neekn1effn5eftneg8rn2eidn5eig5neirne3knnek2rnek5t4nela6nelênel7s4nely2nelæ2nelø2nema2nemi6nemjnem6k5nemn2nemo2nemu2nemy2nemø2nemå4nenanene44neni4nenu4neny4nenæ5neo_7neosne5pe3nerb5nerl2nery2nerå2nesa4nesc4nesene3si2nesl6nesn2neso2nesp2nesu6nesy4nesæ3net_2netane3te2netj3nets2netune4tv4nety4netåneu1rne5us3nevnnev1rn6foan4fobn4fomnfos4n4gafn6gagng1akn2gatng3drn3genn3gern2gesngfø4ng5g2ng5idng4lungo4dn7goen2gorn2gotng2sjng2skng5ye4n1h2nhat5ni1akni2bl4niby4nibå4nicrn8idan5idéni6donid7rnids44niegni1elni3ke2nikj2nikr4nikv5nilu4nimo2nimp4ninfn1inn2ninv5nio_nion24niop7niosni2plniss46nisu6nisy6nitj4nituni3tynit5z2niub2niut4niva2niven6jahnjav9n2jedn4jeen6jein2jetn2kakn2kaun4kehn4kidn4kienk1k4n1klan1klunk3lyn3klænk1lån1knun1knyn4kofn6kotn6kovnk1s2nk3ven6kvonlu4enmik3nmi8ln2nadnn4ann2natn2navnn5d2nndø4n2neen6nefnn1ein2nevn2neynn3g2n4nidnni3en2nimn5nisnn7k2n4no_nn5ofnn1opnnst6nn2sønn7t4nnu1inn1utnn1ynnny4tnn7øknn1øvnoa4gno1akno4blno5co4noef4noei4noekn1offno5idno3inno1kinok8rno9le2nolj4nomjnom9m5nomynon5tn1oppnor5g4norkn4ormnor2sno3ræ4nosp2nosynot3s4notyno3ve6n3p2n4påk2n1r2n4rebn6reon6ri_nro6tn1sa_n5sagn1schn3scon2sedn2seen6sefn2segn2semn2seuns5frns3hans7hens5hins1kvn1slåns3minso4dns1ofn1solns1ovns1prns7s6nsså5ns1tjns1ukns1vin4svunsy4dns1ytn5sønn5tabnt6asnt4atn2tean2teen4tefn2tein2teont4ernti1an4tidn4tign2tion2tipnto3an2tobn2tount1ovnts2tnt3t4ntu9entu4lnty6enu3annu4avnuft44nu4h4nulu6nulynu9me2n1unnu3plnu4renus7lnuss4nu6stnu7tan7utlnves14nyefny5geny3ke4nykony1lony8pany4runy5senyst4ny3teny3trnø2da4nøddnø1flnø1frnø7gr4nøko4nøksnø9monø5munø3p4nø7ranø1rynø3senø1sknøs4lnø7tenø7trn6øttnøv4dn7øyh4nøysnå6asnå8ennå6etnå2lanå8man1å4pn1å6rnå5sanåse4o1allo3alto1a2mo3a6no9ando1a6poa6réoar5moa9téo1a4v2o3baobb4lob4boo4beao3bes2o3bi1ob1jo1b2lob4loo1b4oobo9aob1reob1riob5stobyl5o6daboda4fod9doo2debo2depo2desodko5od3ovod3skods8todu7so4dy_o4dybod5øko5døsod5øyo4einoek6soe4muoen5ao7eneoen5toet2hoe5tio2fa_o2favo2febo4feiof6frof2fuof6fyo4fipof5leof1reof8sao2ga_o2ge_o4gedog1eio3getogie2o2gifo6gigo2gilo2gimo2gino2givog7laogly7o2go_og6raog5råogs4aog1skog5slog5syogt6rog1unog7ås2o1h6ohm9ao4ho_o1idroid5toie4noi5eroi6esoi4lao3in_o1ingo2is_o6isao2iseo4isio8je_o4jo_ok1akok2aro3kasok1efo6kev4okkeo1kluoklå5o8ko_ok8oloko4so6kovoks4eokst2ok5taok3tiok5tookt6roku6to5kvao3kviok5øy4o1laola5tolbu7ol3doo6lebo2ledo2lefo2leko2lelo2lemo2leso2levol4fj3o6ljol9kool6kuol5kvol2luol2låol4må2o1loo4lo_o3loeo4lofolo3iol3opol7sools8tol2trolu5lol5vaol1vooly7dol5ørom4asom1avom3bl1ombuo5metom1euo2miao2mibo2migo4mioo2miro2miu3ommøom1opomo1v2omre2omro2omru6oms_oms4øom3tiom3tvo2m1uo3muso2møkomø4ro4naco6nako4napo4ne_o2nemo3nero2nevong3don5giong2ron2guon4gyo9ni_oni1eo2nilo2nimon5kuon3nion5nyo4no_on4shons1ions1lons1vons1åont6aon3teon5tiont2ron5uron7å6ood1so1offoo2k1ool7aoo6moo1o2poopa8oo4peo6opio1o4roo6spo1o4vo4pabo2pako4pauo3peaope1i2openo2per2opeto4piro1plaop3liop9luop4ne2o3po2opp_4oppa4oppe1oppgop6pr2o1prop6reop7ruop7råo2ragor1ak2oralor6apo4rauor7by1ordnor1eior1elo2revor3geo3riao2rigo6rim6oris6oritor5kaor5koor5leormæ9orn3to3roao3roeo5rogoro5io1ronor1opo5rotor3sior1snor1suor3syor9søortå4oru8doru4ho5rumorv3so7ryaor1ynor5øror1øyor5åso6sado2safosbi7o2sego2semos2eno4seuos2hio1skoos3leoslo1os5luos5løos9maos5meos3mooss9los8svost1oo5støos5øyos7åro5tado5tasote7dot6eio2teootfø4oti2ko6tjaot6nåo2to_o2tobo6tofo4toio2tolo2toto2touot6shots6åoty8eot1ytoul5lou7riou5roou9saout8aouve4o5vaeo1vakoved3o1veio1vel4ovenove2ro1vet2o1vi6ovna2ovnio5vo_o7vomov1oro5votovs1po7wasowat2oy9aroys5lo1y2tôr5eip5ad_p4adgpads46pak_6paka4pakepa3lepal1j5palm4paløpa5mepa5ne4panvpa4ny2papapa3pe4papo4papr2parbpar5g2paripa1ro4parrpar5upar7v6parø4paråpasa5pa9se4pasp3passpas9vpa3te2patupau7k2p1b62p1d4pdø9dpeak34peddpe3de4pedr4pedu2pedøpe7dåpe3erp5eftp5eggpego4pe4ilpek4l8peku4pelapel9d6pelj4pelu2pely2pelø6pelåp1emb6peny2penåpep7p3periper5kper5n4pero2pery6perø2pe1s3pes_pe3sepe7si6peslpes4n5pesspe3tepe3ti2petj2peto4pett2petu4petø4petåpe5vip5evnpfri42p1g2phav27piarpi4as4piavpie2npi9frpi4ké8pikk4piklpiku5pi5lapi1lo3pingpi2nø3pi2ppi4pi2pisopis1tpi9tapi5té2piti4pitj4pitrpit5t2pi5v4p5k4pka5v2pladp4lakplap3p2lasp2lat2ple_2pledp2lek4plev4plitp3livp1lokplu4ep4lukplun32p1n4p7nerpo6empo5id2pokepo3le6poljpo2lupom5s4pon_pon5dp5opnpop1s2por_po1rapo8ré2pori2pork2porvpo1ræpo1rø4posjpo2st5pot_7potapo3te3poti4potr2po4vpove6p2padp2pakp2papp4peep2peupp1idpp5impp7irpp1ofpp5ompp1ovpps2ppps2tpp7t2pp1ukpp5utpp3ø4ppøs84prad2pran4pray5pref1prem1presp3rif1pris2prit1p2ro8pro_3prof3pros6prør5prøv2prøyp1sa_p3se_p2sekp6sibp7sisp2sleps4nop3sodps5pups3s2ps3tvpsu4rp2svap2svep4svæ4psysp2s1øpsøy8pte6kpto7gp4toup4tutpu4brpu7lapull62punn3puri3purkpur5upur3vpu7sapus4hpu1ta4putg2puts2putv6putøpver7py4dr3pyrapy1repy1ropys6tpø1kjpø9tapø9tepå1k2på3pepå1plp1åpnpå5smpå3t2que7r4raam4raar4rabr2rabyra3ch5raci4radf4radj2radmrael4ra2fj2rafo2rafr6raftra4fura6fy2ragl2rah67raidr2akkr6akr2raks4rakvral3gral1jral7mra5ly4raløram3bram1o4ramu6ramyr4an_r4aner4annra5nu4ranø4rapara1pl4rapo4raps4rapu2rarbr1arg6rarn4rarrrar5sra3rø4rasa2rascras3hra6slras7vra1tar6atera1to6raty7raud6raug6ravd4ravgra1vi4ravlrav6r4ravtra5vyraøy42r1b8rba3drbe2drbie8r2bigr2bikr4dabr5dagr5dahrdal4rd3d2rd1eir4deor4didr2difr2dilr2dior2ditr2diurd5jer1djurdnæ4r9dobr4dolrd1opr6dorrd1rird5trrd7tørd5ver4dygr6d5ærd3år2rean4reavre3dir1edl2redo2redr6redy2redøre3er8refa4reff4refi2refj6refr4reft2reføre3ge4regg1regireg1l2regr2regå2reid2reie4reikrei9l6rek_4rekjre7ko4rekur8el_re9la6relgr2ell4relv2relæ2relør1emb6remnrem1s4remu8remy4remåre5ni2renkr3enlre5no4renu5renz6renæ4renøre5og2reop5reou1repu3rers2rerå1res_2resare3se2resj2resk1resm2ress1resu2resy2resø4retj2rety2retøreu6r1revyrfat5r4fikrflå3rfyr4r5ga_r4gefr2gemr3georgi1ar2gikr2gilr2gimr2gior2girr2giørg2ler4gogr3gomr2gotr3grurg5scrg1snrg2syrgu7drg6utrhav2rho3dri1anri1ar6riau2riavri5dari5dirid3tri1elrie4nri1er2rifa6rifj1rifl2rifo2rifuri3gi4rigjrig2s5rij_5rikdri7ki4riklrikt64rikå2rila2rilø4rima2rimirim7l4rimm4rimo4rimu4rimy4rind2rink4rinn2rins2rint2rinvri6nø2rior4ripe4ri1r4rish2risj4risv4risy4risøri3teri7ti4ritjri5tr4rity2riunriu4r2riut2rivi6rivo4riøkr2jesr4kaor3ke_r2kehr6kekrki3drki3erk1k2rk2lirk2lør3knor2kobr2kohrk1strk5tirk5torkå4krle4ar2lefr3lepr4leur3l4irlog2rl4skrlu4er6l5zrm5avr2mekr4meyrm1jermo4er2mofrm1oprm1slrms6nrm1strm1surm3termue4r9må_rmål4r9mårrndø4r3ne_r2necr4nefr2nelr2nevr2nésrn5g6rn5k4r5no_r4noarno5br4nodr4noir6nokr2nomr2nosrn7sern1strn3tern5tirn7trrnt4vrn5ugr7nøtrn3åsro1akroa4s1robe7rodoro7faro2guro5kirok5nrok7srok5v4rolj2roly4romk2romrrom3t4ronn2roppro9pyror3aro3rero1ru4roslro4smro5tu6rotyroun2ro5utr5petr2påkr8raar2ragrra3rr4rebr2refr4reorre5ur6riprri5vrr3m4rro6er5romrr5s2rs3abr3sakr5samr3sesrs1inr7sjar4sjhr4skir1skjr6sklr1skrr1skursk5ørso9ars1ovr5spir4spårs3s6r1s2trst4rr7stårsu9rrs1versy3trt5adr4tecr2teer2teor4tevr2tior2tipr2tivr5to_rt8rart2sirt3t4r7tugrt5ytrt5øl6ruavru8blru5borud4rrue4rru9la4rulir2ullr7ulvr7ulyru5rarus5jr4uta4rutdrut8e2rutgr1utkrut9o6rutr2rutvru5varuvi8r2vesr2vevr4vosr4vovrv2s1rvå7rry1a4ry2drry7fery5flry7lery8rer1yrkry9rory5røry5ta1rytmr3ytrræ7lerær8trø8arrød1s4røeprøf5lrøk3l4røknrøk7trøk1vrøm1arøp9l5rørlr8øs_rø3serøs5vrø8tarø1varø1vi4røya3røyr4råag2råkjråk1vrå5lur5ånd2r1årrå5ru4råsb2råserå5si2råsjrås4t6råtarå5trrå5tu5saa_s6abes8ablsa5bysa3ce4sadmsa4do2sadvsae5d3saen7saer1safe5sagasa3iksa5irsa1is5sak_sa2ka3sakb3sakd5sakf1sakh1sakisa4kj5sakl5sakm4sako3sakps4akusa1la4salb1salgs6alisa5losa1lu3salv2saly1s2am5sam_sa2ma5saml5sammsa4mys5anmsa2nosan1s2s1apsa2po1sara2sarbs4ard3saris1arrsa4ru4sarvs4arys6ast2sasu4sasysa1tasa3tisa1to5sau_sau4d5saue4saug5saum3saus4saut2s1avs2avasav5n3savu8s9b4sbi6es6bugsbul32scels3cer6sch_6s7cl4sco_6scoc4scoss4cus8s9d6sdø8v2se1a3sea_sea4gsed5dse3de5sedl4sedo2sedr2sedu2sedø5see_see3d2seef2seegse5enseer15sees2seevs1eff6segase2ge3segm2seid2seigsei5k6seim2seinsei5r3seis5sej_3seke4seki2sekj5sekk2seko4seky4sekå2selasel1d2selo3sels2selu2sely2selæ2selø6selå3semb7semdse5me2semo2semås2en_s2enes2ens4seny2senæ6senø2seo27seodse3orse3pe3septs2er_se3raser5ds1erfs2eri5sernse1ru2sery2serå5ses_4sesc2sesese3sj5sesose1stses1v2sesy4sesøses3å7setl5setn2setos4ets2setu2setv2sety6setø3seum4seunseu2tsev4ds1evnse3vr2seynsfes5sflå36s9g6sga4lsha2ks7hats3haushea4s4hi_s6hip3show4s5hyshø8l4siap4siavsi2bl4sidy4siegsi1elsie4nsie4s6sifesi3fl2sifo2sifu4sifø4sigisi5grsi3kasiko35sil_3sildsil5jsil2k2silø2simpsi3musi4ni4sinj2sinn4sinvsi6nøsi4sksi4sn4sisy3s2itsi5ta4siut5sivas2ja_4sjams4jansje3g3sjels6jim2sjob5sjok4sjom9sjon2sjor2sjou2s6jtsju1a6sjub4sjun4sjur5s2jøsjø1p2ska_4skabs2kad8skae2skak2skam2skas8skays2kehs6keis6kevs2key7skia4skid5skie5skif5skip2skir6sklas1knu4skoa4skof1skol4skom4skoo2skoss2kotsk8ra5skud1skuf2skun4skup3skvus6kyas6kye4skyr4skys3skyt6skø_4skøe6skåt3slals1latsla1v2sle_6sleis2lel2slers5lev4sleys5lia2slid6slig2slin3slip6sluf4slugs6lups4lutsly8t2sløns6lør2sløss4låes1lån1slåtsma6d4smansmeg54smei6smess6mias4mies4migs2mitsmo7as2mok6smot3smugsmul26smøn4smøt5små_små5r8sna_s4nab7snak4snav4sne_4sneb4sneds6nees4neg3sneis4nel2snem4sner6snes4snets6nifs2niksnir4s8no_s6noes3nums4nur7snut8snyh5snøesnø1sso3also8ar4soav2s1obso2blsofa1soft1so2gaso8giso7glso5id5sokn4soks7sol_1sold2soljso2loso4lø3som_5somh4soml2somrs1omsso2nuso3pr1sor_7sora5sorbso2risor5n6sosf4sosjso4slso5tesots4so3va3sovjs2pal4spas4spe_spe4as4pees2pels5peps2pio2spip2s1pl4sple2spoe2spol4spotspo5v1sprus4pry5språ2s3ps8spub2spul5s2pøsp5øy9spå_5spådsro4esro2tsrø1vs6saes4sajss6ass2segss4els2sems2seus4seyssi4ass4kåss1loss5lyss2noss4nøs2sofs2somss9risst6rs2suls3surss1vessy5r4stah4stao2stap1stas1stat2stea2stebs2tee4steo2step2stes4stet6steåst5he4stib3stics2tifs5tij5stir2stis4stiås4tja4stjus2to_1stof4stoms1totst5ou8str_6strh2strys4tuas2tue6stur2stya2stydsty6l4styv2støk5støl6støm5støp5støtst8øystå5k1su4a1su2bsub7lsub3o5subss3ubåsu8er5s2ugsug3g3sui6suk3rs1ulu2sulysulæ53s2umsu2mosums63s2upsupi9sup4rsur5d1surf4susisus3psus3ssu2sysva5asvai5s4vie4svig4svil4svir2sviss8viv4svol3svuls3vy41s2vø4svæs2s7våsy2ersy8ka2sykosy7mesynk4sy4ras6yre3sy1ssy4sesy2sl2sy2t9syttsy2vå6szt_4sætts1øde9søk_5søkj5søkk2søko3s4øl3s2ømsø6må3sønns1øns7sørlsør3ssør5ø3s2øs4søs_sø8sas1øve3søvn8søye3søylsøy2r5s4ål6s1ån9såpasåp9uså6rasår7øs7åsas4åsbs5åsesås5ksås5tsåva74tabotab2rtab2s4tabøta2data6du6taei4taek4tael1taenta6es4tafl1tage4tagjta7is1tak_2takrta1kutak3v1tal_3tale1talg7taljta6lå2tambt4ametam4it6an_ta2na1tane1tank2tanl5tap_1tape3tapi4taplt6ara2tarb4tart4tasata3setas4p4tasuta1tatati19tau_7taue4taun2taut3tavlta9xy6t1b2tba3dtba2nt6be_tby3ktby4stcen4tch5e4tead2teaktea6m2teap2teartea4s2teau2teavt5ebbte1co4tedi4tedo6tedu4tedy4tedøte3e48tefa4tefi4tefl4tefo3tefø2tega4tegg2tegh2tegj2tegl2tegu2tegå5tei_t3eiete1im2tekj2tekl2teko2tekr2teku4teky2tekø4tekå2telo2tely6telæ2telø2telå6temntem3s4temø3ten_2teng6tenó4teny4tenæ2tenø2teom5teon4teop2teovte3pa9tepé4tepr3terhter5jter5rter7v2tery5tes_2tesa4tesj6tesp5tesr3tess2tesu2tesyte7så3tet_te3te2teti2tetj2teto2tetu2tetv2tetyteu8kt1eur3teust6eva3tevlte3vr2tey64téle2tése4tésttfe6etfe4ltflå32t3g2t4ga_tge4atgei5t4gi_t4gå_t4hapthu6sthy5r2tiadti3ag4tiau2tiav2tickti2datid7d4tido4tidr2tidu6tidy4tidøti1e22tief2tiei2tiemties3ti3et2tifa2tife4tifl2tifo4tift2tifu4tifø4tigj2tignti5ke6tikjti3ku6tiky4tikø2tile3tilg4tilm2tilu2tilø2timltim7s2timu2timy2timø2tind2tinkti5no2tinv4tiny9tiol4tiopti1orti1ovti3pa4tipr3tipsti1roti3setis5l4tisn4tiso2tisyti7tati3teti1tj3titltit4rtit3s3titt4tiub2tiut2tivoti1ø82tjel1tjen6tjep2tjert5jev2t1ji2tjubtju4e2tjun6tjur4t3k2t6kagtkly96t3l6t6leftlu4etlå7rtma3dt2mamt2mekt2most6neet8no_tn5sk7toantoa6t6toau2toav6tobsto5da3todo2toek6toeltoe4t4toggto6glto2gutoil3to3ki2tokj2tokkto3kl5tokt2toku2tolj3tolo4tolå2tomb2tomf4tomgto3mi4tomkt8omm2tomrto5na2tono2tonu2to3o4toprto1ra4tordto1reto4rø4torå4tosato2sh6tosj2tosy4totato5te6totyto1va6t3p2t4påk5trapt2rat3travtre1c4treit2rer2trest1ret4trevt6ribt4riut2riv5trix5troa3troet4roftro5gt4rokt2rolt2rostro1vt8ru_t8rua3trugtru1i2truttru5vtrø8a4trøk4trøm2trør5trøtt5sa_t5sabtsa2gts1ant5se_tse6dts2emts4ests4fæt5sirts2luts5løt5sokts2pits5s4t1st4t5stuts3tvt4suatsu4lt5sykts5ytts5øvtsåt8t3ta_t2tabt2taft4tavt3te_t2teat3tedt2teet4teft2tegt2teit2tekt4temt3tent2teott5hetti5atti3et2tift5tigt1to_t2tontto5ut5tryt1tumtt1untt1uttt5vet5ty_tty8et1tørtt3øvtt1å45tualtuba3tu6bå5tueltu1int5ukat1uke7tukt3tula1tuletum5mtum4s3tun_4tund3tune9tuns3t2urturi4tur1otur3ptur1ø1tus_tu1sa3tusb3tusftu4smtus5otus5u2tutgt5utjt5utkt1utrtva8kt2vett5vik6t7vo6twa26t5yo3tysktys3t2ty2tty8tatøf3l2t1øktørk4tør3ttø8satøt5atø3tetøtt6tøv6dtøy5atøy5rtå5kitåk6rtå3net1åpnuak3su1al_ua7laual5lual3oual3uu5anlu3ansu1ar_uar5du4arruash3u5au81uavhu4ba_ub4boub2brub4buubi6su1b4rubu8eu3da_ud2drud2dåudea9u2debu2deku2depu2desudia2udio5ud7irud7jiu7dobu6doeu2dotudse43u4dyue5a8u1e2nu7eneue5riu2ermue4seue2siues6nuet8rueul8u4fe_u6febufe6euf1f4ufi9lu6foauft3au5gagu5garugby7u2gemu5genu3geru2gevu5gisug1laug5lyug7nau4go_ug4reu4grøugs4kug7so3uhelu4i6cui3e6uil5lui3neu1ingu1ismu1ittu4jasu8je_u1k2au7karu5katu2ke_u4ked4ukemukho7ukk6aukk7nukks6uk8luu2krauk2sauk2siuk2souks5tuk2søuk6tjuku6eukys8uk3ø4uk5å4u4la_ula7du4lefu2leku2lelu2lesu2leuul4foul4fru3l4iulie8ul5kaul6lyul2løulm4uulo6iul5opul4skul8snulss8ul2stul4tou7luau3lue1uluku5lupu5lusulv3tum5auum3avum5be2umfoum9jaum3meumna8umo6gum5okum2snums3t6um7tum5ut4umveum7øyu9naru7nasu3nat2und_6unda4undsu2nedu4neeu2nelu2nev1ungdun4gou4ni_u2nidu4nimu3ninun7koun4krun2nou4no_uno7tun5utuom7suo1reuo5roup3avu5peru8pi_up3liup1p2upp5su3prau2radu2rafu4ramur7auur1avur3diure4lur3geu4ri_u3riku3rimurk5su4ro_u6roc5uroeu2ropur1orur3reur2svur5tiur4touruk6ur6uluru7vurv3su6rysur1ødur1øyus7auu2seku2semus4idu4sjiusk4lus1kou1skrus4kyu4sluus7møus1okuso5lus1oruss1lus2svu2steus5tius1tju4ståu2surusø6mus1øyu1taeu2tag4utbiutch5u2te_u2teau4teeu4teiu2tekut2enu2teo2uterut6eu6u3tiut6juu8tni1utnyuto5suto4v3utprut4påut3re5utruut4rø4uts_2utsjut3sk5utstut1trutu5e2u3tyu8ty_u5tørut7åku3tålut1ånut7åru7umau5umeuve3su6vevuvi6kuv5rauv9saux4a4u9årau7åreva3amva8an6vadjvad1rvaf6rvai5rvai5s6vakh4vakovak3r1vaktva1kuvak3vva1lu4valvval7åv4ane2vangv4ansva4nyva5po4vasava2skvat5a5vatnva1tova6trvat1s2v1av2v1b2v7devv7doiv7donve6agve2d1veds2vedø4vedå6ve4erve5ge3vegg2vegj4veglveg5n2vego6veit4veka2veki4vekj2vekl2veko2vekr3veks1vekt2vekå5vel_2velovels2vel5v2vely2velæ2veløve5mave2no2venuve1ru6veryverø64verå3ves_4vesh4vesi4vesj2vesl4vesp2vesøve1så1vet_2veta4vetj2veto2vetr1vets6vetv4vetyve8um2veva2vevi2v1g2v4ga_v4gi_v4gå_vi1anvi6blvi5devid3rvi1elvig4mvi4guvi5gø5vikb7vikgvik5n4vikt1viljvil5mvil1ovi2løvim7pvim7uv6ingvip5s4viro7viruvis5mvi1sovi4spvi4trvivi34v5jovju3t6v3k6vk4le6v1l2v6labv9ledv9legvl6elvli7vv3nadvn5alv9narvn5dyvne7bv2nedv2nemvne1sv2nevvn5t4vn5ørvo1alvo2arvo4gu4vokovoli7vo4navons62vordvo1re4voro4vosj6votr2v1p4v7rarv6ri_3vrid7vriev4robv4rofv4rokv4ropv6sa_v6se_v4segvse4nv2serv6si_vs1invs8kevs1kvv1s2nvs3nevs3nyvs3nævs5odvsom5v7sonvs1orvs2pevsøl5v8så_v4ta_vta6sv5t4iv5t4rv3t2vvty8evu2d1vud5dvuds42vung6vu6o2v1utvæ1rav3ø4dvø7li3vøre4v1øyvøy6evå5ne4vånu6våtfvåt7å5waldwal4kwal4lwash3wboy5we5rewes3swett4wich33wiczwi3niwi5rawi5tawout7wurs6wyor2xan5t5x6idxi5e4y6an_y2anayan7ky1arky7arrya5siybde3ybyg5y8ce_y2co3y6dabyd5avy4deoy2depyd6jeyd1jiyd3opyd5ovyd1rey4droyd3siyds4vyd1uny4dømydør5yd1øsyed8ly5eksy2enhye5niy2enky2enlyens4y3ernye5smye9teye5tyyfan9y4fley8ga_yg2doyg2døyge5iy2gesy4gevyg5gjygg5lyg6gryg6guy5gloyhes5y9in_yis7tykap3y3keny3keryk1kjyk4kyyk1lay1kloy5klæy2koay2kotyld1ry7lesy4levyl5k8ylke2yl3s6y6meiy4mo_ymo5eym3p2ym4seym8sly2nely6nevyn2grynko3yn5nayn5neynn4øy4no_yn2siyn2skyn4styn2suyo6nuy1o2py1o2ryo5reyout5y2pe_y4peey4pi_y1p2lyp3peyp5s8yr5avyr7dayr5døyrek4y1reny4reoy1retyr7gay4rifyr5kjy7roeyr1opyr5r8yr5skyr2spyr4svyr3teyrty8yr3økyrøy4y1rå1yråd2y2råmy4råty4råvy4sedy4seey2segy2seky2semy4seuysi8ey5sjkys4miys4nøys2peys2sjys2soys2spys4suys3tayst3rys6tyys1veys5åry2teey4tefy2tegy2teoy2tetyt9jayt8rayt1riy5tråyt3skyt5svytt4e2y3tuyt4ysy7tå8y4vaky2vedy6vevyv1år4zaesza4g5zani45za5vzebu9zeli5zen3s1zifi5zingz5int2zisyzo1f2zo4nozo5rez1za_æk1jaække7æ4le_æ4levær1d4æ2reaæ4redæ2refæ2regæ2rekæ2repæ2reværhø8æri6s4ærk2ær4nåærom5ær1skær2spæ2r1uærut5ær3å4æ8se_æ2s1kæ4te_æt4taævar5æve4s6ø1a2øa7reøbl9uød3agø4dakø2de_ø6defø4demø4deoød2scødt6rø6d5ø4ø1e2ø5eneøf3feøg5akøg5alø7garø5gasø3gerøg5gløg8gåø7g4jø2g2røgta54øg4uø5ingø5isk6ø1kaø5kavø6kehøke1sø1kjeøkk5r2øknaøk4siøk2soøku4røk7veø2lahø6lamø2levøl2keøl7opølrå4ø5lukøl7utølva6ølv5oølv7rø4me_ø9met1ømfiøm3opøm1stø2m1uøn2adø5nasø2nemønni4øn2nøø6nomøn2taøn2toøn7u8øpes4øp3liøp6pløp6s1øpsa4ø2ra_ørd4eø2reaø2refø2regø2rekø2repør6etør1euø2revør5feøri8mør4kåørn4eø1rosøro4vørri4ør4scør2siør2størs9uør2svørs1åør3toørum5ø6rutørø1vør1åpø2se_ø2semøs5joø4sluøs2meø1s2pøsto2øst1røstø4øt3akø9tarøta4sø2te_ø2teaø6tefø2teiø2telø3tenøt7riøt1saøt4tyøv5aaø4vekøve1sø5vikøv7neøv6nøøv9o8øv9saøy3aløya2nøyd8i5øyebøy2eeøye4nøy4epøy1gløyks4øyk5tøy5naøy5niøy3røøy5siøys2løy4smøy1trøy5tø5øyvååa4n5åber2å7danå9darå4dedå4dekå4demå4deoå4depå2desåd4raåd8reåd2skåd5stå2eleå7enså4ga_å4ge_åg7eiå2gesågna5åg5neågs6kåg5slåg7spågs4tågu4lå4gå_å3kanå3karåk7avå4kehå3kenåke5så6kidåk5kaåkk6låk7kråk3læåko4såk6raåk3rååk1s2åks7låk3t4å2k3åå9lasål9avå2lefå2lekå2lemå2levålgå6å6lioål3oråls7iål2spål5tiå6me_åm1omåm5øyå3narå9nasånd3rå4ne_åned4å2nelå3netå5perå1plaåpra5åp2s1åp6taår3akå9ranå2re_å5reiå6relåre7sårfi4å7rivår3k2årn5sår3onår3opårpo8års1uårs1vår5syår3unår5y4å5r8åås7auå4se_å4seeå4sekå4semå8si_ås8kiå1skjå1skrå5skuås5neås3niås7plås5saås5seås3siåss3k4å1stås3unås7utås7væås5øyå4ta_åta2lå2te_å2teaå4teeå4teoå9terå2tesåt7ovåt1reåt1ruåt5skåt4tiått3oåtts4åt4unåt5veåt1øvå4vegåve5lå2vevåv7s6",
  10
  "_fire5o6g5_gra4v3end_oppla8te__skritt9s8_sy6v5o6g5_tver6r5a6_ut3kan6t5_vil5l6a5l_vil5l6a5t_øyele8ge__åtte5o6g5amen6t7arvansport7s6augele8ge_be4g5rene_ber4g5endeb5s6e6a5m46d5en6den_dritun8ge_en6s7a6kerer9s6kararframma8ne_fremma8ne_fullen8de_funnsla8gagestri8de_her8s7kareil6l7enderkinnsi8de_kses8serie8lemetriskle8p9endenlistyr8ke_mse6t7jarengstyr8ke_nteriø7ra_5og5s6y4v33pr6in7s6e3pr6in7s6irdenta8le_9relandsk_9relandskerifiserba88s7en5trepsikk8artet5s6kjer4m33skjer5m4es6k5undervsomme6r5e6tentle8ge_ukteslø9seungele8ge_us7edvanlevi6n5o6vervnor9s8kasvve8g9ing_vve6g7ingaykjeva8ne_ylkesla8gayn8s9kjer_ytte8r9endø7reskrivi",
  8
  "_akter5e_albu5en_al5m6in_an5d4ra_arie5ne_as5kese_av7inde_ban4k3l_be4d5et_ber6ett_be6sten_ble5k4e_bor8ti8_de4l5ei_de4r5et_de6r3i4_de4r5om_dings7a_ein5og5_ek5s4ta_en6t5ra_fan3t4o_fes3t6e_fla4t5o_for5en__for7s6o_gang5s4_grunn5s_ha6v5ak_he6r5i6_he6r5o6_he9r6oe_he7r6oi_he7r6ol_he9r8os_het7s6e_hus6val_hvi3t4e_i8lande_ilbo8da_imø5te__isla8ga_jern5s4_kje3de5_kne4p3r_kring5s_kva4r1a_lega5ta_lei5er__let6tan_li4v5en_liv4s5v_løye5ne_mat5t8o_me6d5ei_me6d7in_mei5er__mel3l6o_me2t6a3_min5k4e_mi6s3t4_mor5d6e_ni5o6g5_over3i4_over5k8_pa6n7eu_plen5g6_plus6s5_ran7s6a_rap5s4e_rei5er__re8klar_ro4tek4_san7d8e_san7d8i_ser7vel_sha9ke__sik5k6e_sinn6s5_skinns6_sko7de__slotts5_slu5ke__spri5s6_stev9na_stål5l6_sund5s6_sva5ra__sær3e4g_tak9s8p_to5o6g5_tor4s5v_tre5s6t_u6lende_unde6ri_urte5m8_vann5s4_va6reta_ve5l4ar_ve5l4os_ve4l5ov_ver5ste_vi4d5å4_vi6seri_vok5s6e_ære4s5a_øve4r6saarie9nea5de4serad4s5amtad5s4letad5s6tekafore5neaf4t5e4lagang7s8age5riskag5s6ingagsmå6laakk5erstak4s5andakse3l4oak4s5elvakst7renakta6le_akt5s4laa5lande_albu7er_ale6s5kralla6ge_alle6ge_all5erstal6list_al7skarealta8le_5alternaal4t5etaal4t5etea2l5y4teamen8de_am8periaam6perieam5p4letanak8te_an4da5m6anderle7and8sendand7sleta5netikean5e4tisanfø5re_an4g5enhang5ermean8gesteangs6troang4t5reang5t6veann6s7kåan9s6und5ansundaan5t6andapo5s4tiarau9kenarba8ne_ardfø5rearen5tesa4r5erfaarev6ne_ar4k5løfar6s5ersarta6le_arvi8se_a4s5kopia5s6kulaa6standeas4t5enhastu8ve_ateke7taa6t5ektea6t5opprat7s6katattfø7reatvi5er_atyr8ke_auba6ne_au5e6te_au6s8tasaus8tett3a4van5savar6ta_av5isingavspe9g4ba4k5endbak6kersbak5s6tibari6e7nbebo5er_be4g5re_belle5sabel4te5sbes6s7a6bes7tensbe5stes_bevi5se_billa8gabjek4t5oblings6iboksi8dabo4l5o4rbor6t7efbor6t7etbose8te_bus6sentbørs8ta_ca5s4tilce4ne5s4cen4ti9mdalbu8er6d5ameridata6le_del5ei4d6d3e4levdel6lerfdel4s5atdel6taladelø6pa_den4s3t8den6t5u65de7rastde4r5edd8derest_6derestedero8se_de8s9hopdesi4s5t6de5s6prdeta8ka_deva8ne_devi9er_dheim2s5di8g9anddi3ge4s56d5i6meldisie5ned6jingand6jingardland7asdlei7er_dog4me5sdoli8ne_dom8s5e66d7on6kldor6gestdrei5er_drei7ernds3a6deldsak6se_dsel4s5ad6s7endadsen8de_d4s5e4skds5identd6s5kjøtd9slott_dste6ma_d6s5tempd5stillidsva8ne_dsvi6ka_eate6renebe4d3e6ebei7er_eben6s5kebo5ers_ebu4e5reedi6a5needle6ge_edok8se_edyr6ke_efisken8efle6ge_3e4genskei4m5a6le4k5ret_ek7s6telek6t7armektori6ae4k5ve4delak8se_e4li5g4reli6v7enelli7ga_el3se6s37elskandels5kareel5s6åpeelta8le_el4t5ettelun6ge_elvæ6re_emini6stemse8te_enat6s5pen4d5andenge6r5uenne4s5vensi8de_ensi5erten7s6opten6s7talen7timenen4t5rolentropi5e5rande_er5a4pine5rasaneerau9kenerbo8de_er5e4gene6r5ektee4r3e4leer5endene4r3e4vae4r5e4veerev6ne_erhø6re_e7ri6ma_6eringarering6sieri5stilerkeri6eer6k5etterle6ge_erle7s8termo8de_ermå6la_5ero4b7rers5tenser4te3s4ertå7renervæ6re_e6r5ør6se4r5øy7ee4r5øys_esei8ge_eskinns5e7s4mettes6sendies4s5enkess5e4vaess5tilte8s7ter_e5s6terkesterne8est5reneestå5renetall5s6etnings7etsla8gaetta6le_etter5atet5t6erfettvi5see5t6vange4v5antafal6lersfan7teskfa6t7ersfentleg5fers9karfikalie6fil6lerifil7letifil8m7atfil7tresfin6slegfin6te5sfisk5a6dfisk5andfis6kartfiti6me_fjæ4res8fol5lesefolke5s6for9drevforlø9paforlø9seforsi9dafortei9eforti5daforva9refosfo5refred8selfres7ko_fres5koefri5a6refsle6ge_ften5s6vfte4r5a4ftsla6gaft5s4lanft6s5topft5s6trifug6l7egfy4r5a4bgamme6l5gan5g6en4g5antregass5ettgas7t6ragdevi8sageak6te_7gedommegeen8de_gehø8ve_gelei5er3gem4s5tgene5ve_ge4r5antg9er8ma_ger4s5afgerø6re_ge4r3ø4vges6tekkgest5ridges5vik_geta6le_gg5s4par6gingenigiste6rugje8v9akgle6deroglei7er_glori6anglun8ge_go4n5and3g6or4a5grand3s4gra4v3akgrei6enegres6sakgri5setegs5akersgsel4s5ags6ende_gsen6ke_gsle6ge_g9s6mertg6s5porsg9s8tandgste6ma_g5s4terfg5s4terkg5s4terng5s4tersg5s4tervg5stredeg5strekeg5s4trofgstyr8kagtråd5s6ham6nesthams4t7rhand7skrhan5n4o5heder6s5he4l5ei4hel6lesuhenfø5reherle9geherli9gaher6resiher6ska_heste5rihet4s3a4he6v7armhof4f3a4hof4f3e4hof5f6erhog7strahudså9rehu5s6a6rhu6s7arrhusa7r8ehust9ranhånd5skria4l5ettia5r6e8l5identif5identiti9de5re_iderle7gidsla6gaien6delaie4r5engi5e4tabli6gedommigedoms5igli6se_ik6k7entiksmå8laillan8daillæ9re_il4m5estilset8jeilsle7geilsva9railsva5reilt5rettina4t5ak5industrines8ke_ine5s4tiin4g5aldin5n6ovain9s8kasins5kjøtins8legain8s5te_ins5ten_ins9tens3in3s4ti4in3s6toinst5relin8t7egein5te4t5iorla8gaiota6le_i4p5ingsippel7s6ippsy8naipru8te_irti6g5ri2s2e3g4isk9art_isk5arteiskla8gais6k5rinis5pane_iste6ma_i8s8tre_i4st5reni6strer_itan7s6vit7jaranitma6le_itostra6itsla8gaitte4l5oium4f5ari4um5s4tivle6ge_ivyr8ke_jak7kelejar5tet_jek6kerujek4t5injelei7erjell5angje4r5antjer6n5asjet4t5anjet6termkaf5ferekal6lero5k6ande_kat6term5kegladhkel5eierkels7karkelø8pa_5kenattskenne4l3ke6r5engke4r5ert6keringi6keringj8kerist_8kerista6keristekero6se_keru6se_kerø6re_8ker8øya6ker6øye7kesdalek9es8ka_4ke5sted4ke5stei4ke5struketa6le_ketøy6s5keva8ne_kevi6sa_king5andki4v5enhkjel7legk6kandenkkar6ta_kk5e4levk6kerentk6kestadk4k5jernklon7a8lklyse7tekna5t4reko4g5engkoi4e5nekone5l6åkord5s4ø4ko7rei97k8ra4sjkrin6s7t7krisenekses6selksla8ga_kslø8ve_ks4t5rekk9s8vakeksva8ne_k7s6vertk6t5elskkt5e4litkterie5nktes6ke_k4t5e4taktev6ne_k6togramktori9e8kt4s5ambktyr8ke_kund5s6lkuru9kenkuru7kerkyrie5nekyse8te_køy4e5nelan6germlang4s5elan6g5ø6la6r7etalari6e7nlat4t5isl6derklælderle9gldsla8gale6bostalefa6ne_le9geranle9geraslei5endelei4e5nelei7ger_lekt5ordlekt4s5tlen4s5aklen8t9rale2r3amb4le9r8eileru8se_leta8le_lge4r5anlg5s4kreli4g5enhlig5s4tilil5lebe6l5inntrlis6terk4lis6tillis4t3u4lit6telelit6terklit6terml6je5t6rlkali9e8l5kestadl6l5ekstllen6da_ll5endenllmue9nellmu7ensllsa6me_llun6ge_lmyr8ke_lob9byanlo6g5e8vlole6ge_lo3ve7d66l5overs6l5overtlsan6ke_lse8s5trl2s3kildlskinns5lsle6ge_lson6de_lsve8en_l4t5erstltle8ge_l5t4restltsa8me_ltu5r6enltu5r6erlub6bandluk6keri3lu5t6helut4t5atlvin5g6rlvly8se_lyk6kerily4s5a4klyse6te_mali9e8nmal4t5ekma4t5rasma6t7romm8at7t8rme5l4aks6m5e6lemme4l5engmello6m34me5l4å5me4r5antme6rensem5fru5s6mi4n5ersmisha9gem8jinganm8jingarmlei5er_m6le5s8vmman6dolmme5t6remnes9tiemofo6bi_4m3o4riemorla8ga6motsagdm4p5antam6peressm4p5erfampun6ge_m5s6toppm8strandm5stranemutsa8lamålø6pe_må4ne5s6na4l5ettnari4e5n7nariksknditori5ndit4t5and4om4s3nd5resennd4s5ambnds5endendsla6gands6lettnds5trekndta6ka_ndun6ge_6n5eddik5ne4e4r5neg5lesp7neleggjnelei5er6n3en5trnere6de_nerla8ganers8ten4ne5skar5neskinsnes9tas_neta6le_netå5ker6ne8ventnfor9en_n8gan8dan5g6ros5ngst5ridnian5depnings5ten4k5erfan5k6langnland6senlei7er_nmusik7kn6n7antan5nes4lannhø8re_nni4s3t6nnle6ge_nnlø6pe_n4n3o4venn4s5ambnn6s5enknnse6te_nn4s5i6snn6s5jaknn5s4klinn6s5tabnns5teltnn6s5trennte6se_nodi4e5nnors6ka_nose8te_nsak6se_n5saren_nseri7e6n4se3s4vn6s5jordn6s5kaukn6skjelen7slararnsle6ge_n3s4lektnsmå6la_nson6de_nste6ma_n4s5tilsns4t3i4sn5s4villn6t5arvin6terestnte6riskn4ti5stintrol6linæ8rast_oak6kanaoar4d5inoa4r5e4goa4r5enhobers5taobers5teod5s4tolo6gi7strogs5t6raoka4n5i6ok6serinokto4r5iolbo7ge_oldo7ve7old3s4kroll5overo6l7o6seolun8ge_omsku9laomvæ8re_omyr8ke_o4ne3s8tonsla6gaonst5rumo4p5landop4p5artord7e6plor4d5iseore6o5g6orfa6re_orfø9re_ori4e5neorko6se_orse7te_orsk5ei4orsmå8laorsva9reorta8la_or4t5andorte5i6gor6t5erfor4t5ermosi6e7neossis5teote6k7laotel6lanotel6leko4t5endeoten8de_otes6terotno7te_o6togramove8r5es5oversikovta6le_pakk7eslpekt7rospe5l4akspensa8laperie8nspero6se_per6regjper4t5råpeva8ne_pike5r6opillega6pille6rapio6n5anpita7la_platina5p6le5n4upol6s4kapor4t5ropp7e6senpp5e4tasppir8re_ppropri6ppse6te_prei7er_pres6sakp6restasprø5velspslø6ve_psmå8la_psøy9enepunk5t6erali5e6nramperi8r4an9de_rand5s6aran4n5inrans7kar8rarinna6rarinneraska8rara5s4tilra5t6røyrav8l9utravlø8par4d5erstrdi6gresrdon8na_rdvi8ka_rein6skjreis6ledre5k6lirrele8ge_rel6landremi6eneremti9da6r7entit4r3en5tr6re9rangrero6se_resi7ereres6sortres9tanerett6set5retøya_reva5re_re6v7enhre4v5innrhånd6s9rien5t4rril6lestring4sa4rings5akring8spa4ri5stedritt8s7trko6seler4k5ve6dr4l5e4rirling3s4r4m5altermin5skir6m5instrn5e4tabrnsle7gern6s3ovn5robølgjrok6keri3ro5m8an6ronista8roniste6ronistirot5ekters5e4rikrsk7innsrs5kjensrso7n6alr4s5tabbrstev9nar4s5tilfr4s5tilhr4s5tilsr4s5tilvrsvar4s5rt5e4litrten4s5krtentle8r4ti5strrtma6le_r4t5rekort4s5tøyrts5unde6r3underr5unders6r7u6sikru4s4t3rruta8la_ru9tene_rveis7e6rville9d8r3æ4renrønn5s4a6røy4s3kråta8ka_4s5alarmsan7d8al5s6ande_4s3a6nek5s4ansen4s5ans8l4s3atmos6s5atten4s2e7g8rsek2t3ansekte9ra4s3e4lev4s3e4lit8s5elskese6l7u6rsel4v5akselø8pa_sen6delasene8se_4s5ensemseperso5ses4s5ins5ettersseure9neseva6ne_sfisken8sik4k5elsit6termsjek4t5os6j3t6sj5s4kal8a9s8kapa_5skapen_skei5er_s3ke4t3j6skjemas4s5kjærlskjø5res6s5kulis7slegare5s6legasslei5er_s6len6t37slottetslum5p6eslæ6rari5s4makensolei5ersommar5a5s6paser8s9plantsport6s58sprinsi5s6prosssrå6dersssar8ve_ssau6se_ssel5v6åss5endenssen6ke_s5s6jargsstel6li6stande_stang5s6s6t5antr5stegspl5s4tenen4ste5nesstep7pers6terests6teri6vstga6ve_stgå8ve_stile9ge5s4tilt_6s5tiltas6t5jent6s8t5ord5s6tore_stra8na_st7rast_5s4traum7s6treik3s4t6rip6s4t5romst7ro6pastsa6me_stta6le_8s5under4s3u4reisverd5s44s5viktis6vindelsving5s4ll6svint8s3æ4ren7s6æ5te4søk6s3e6sø4r5endsår9ast_ta6d3e4ttal8ligntall6s9at5altern5t6ande_t7andel_t5andeletandør5e4t5anstr6t7antre4t9arenatart7estta6r5å8kta4si5s4tate8se_tbe6t8ratedo6en_tedo8et_t7ei6ge_5te4l5artel8ligntelø8pa_tempe8l7ten4t5intep6perete4r5engteren6gater5estiterla6gaterle7ge5tersjøoter7s6kotervi6set9es6ka_5tes7te_4te5steite5s6tivteta6le_tifa8ne_6tikular5timedie4tim6o8rtin5ge4stise8ra_ti4v5andti4v5arttlei5er_tokk5endto4l5armtoli8ne_tol6lettto5mene_tomlø8pa6t5opple4t5opplæto4r5ant6t9rabattran7ske4t3rekor3t6re7nat5represt5rettedtsak6se_tsen6ke_t5s6ers_5t6sjov_t4s5kjedtsmå6la_t2s3piket2s3tabbt4s5trenttem6ne_t4t5ensettes6ke_ttle6de_ttsla6gatt5stillttun6ge_tun5gesvtut6tenkt8viklast4vi5l4itørs7ta_tørs7tertørs5tinudle6ge_u5e6rastuf4f5ermuft5s4laugrei9erug5s4va7uinnsmi8ukt5e4skuk4t5oriuktue5reu5leste_ulleg8gaul4le3s4ulling7sul4l3o6sul8s3t6rulyk5kesumau7kenumen4t5i5underskun4n5ersun4n5ervunnta8launst5e6lurau9kenuregist5uri6a7neuri4e5neurle6ge_urle8se_u6s5endiusle6ge_u6standeust9etteu7s6valtusvi8ka_u6t5a6sau6t5a6seutda7ta_u5t4radiut5toreautun8ge_uærle9gevann6stivan5s6kivar4s5tivarta9lava6t7e8lvding5s4ve5g6lødveg5rettveks4t5rvek4t5anve6r7engverfø5rever8ska_ve6s3pervest5o4v5vesyndsve5te6s79vetoks_vgjer6s7vil4l5anvil6tretvin5gom_vi4t5øy4v4s5e4livsre6de_vste6ma_vven7n6ivvi8s9anvøy7ene_vøy9enesvå9kene_war6d7erwestern7y4d4r5auyk4k5enhyk8k5vi6ym4fe5d6yns9ket_yn4s5very5reste_yres6tenyri6ene_yrs7teneyrs5tensyrul8la_yrå6dersyseri7e6y4se5s6lyter5skeyt8tien_æri6e7neærle6ge_øffe8l7aø6keradaølge5s6vønhø8re_ønns5kjeønns5kreøpsla8gaørele8seør8k9lagørsa6me_ørs5tensør8tien_øs5terseøttså7reåkva8la_årsla8gaåseri7e6åtri6pa_åtri8pe_"},
 :exceptions
 "atten-de, aust-røn, aviser, betre, bortan-for, bortre, Dansk-øya, der-etter, dess-uak-tet, dit-over, fram-ifrå, før-enn, her-etter, her-etter-dags, hvor-etter, hvor-over, høyt-ærede, gi-vet-vis, lands-øl, lands-ølet, lands-ølets, langt-ifra, ned-imot, noens, Not-odden, Not-oddens, nøye-reg-nen-de, opp-imot, oven-ikjøpet, promp-te, spleen, sel-ves-te, smal-enden, sørpe-is, sørpe-isen, skrov-is, skrov-isen, Steins-land, syd-enden, tvert-om, velan, velet, welt-schmerz",
 :patternChars "_abcdefghijklmnopqrstuvwxyzåæèéêòóôø"}
)

(def rules
  (-> rules'
      (assoc :trie (pat/build-trie rules'))
      (dissoc :patterns)))
