(ns deraen.boot-from-jars
  {:boot/export-tasks true}
  (:require
    [boot.core :refer :all]
    [boot.pod :as pod]
    [clojure.string :a s]
    [clojure.java.io :as io]))

(def ^:private webjar-deps '[[org.webjars/webjars-locator "0.19"]
                             [org.slf4j/slf4j-nop "1.7.7"]])

(defn- copy-file [tmp path target]
  (let [f (io/resource path)]
    (if f
      (pod/copy-url f (io/file tmp target))
      (throw (str "File " path " not found!")))))

(deftask from-jars
  "Add non-boot ready js files to the fileset"
  [p path PATH str "The path of file in classpath"
   t target TARGET str "Target path"
   x package bool "Don't include files in result"]
  (let [tmp (temp-dir!)
        state (atom nil)]
    (with-pre-wrap
      fileset
      (when-not @state (copy-file tmp path target))
      (-> fileset ((if package add-source add-resource) tmp) commit!))))

(def ^:private webjar-pod (delay (pod/make-pod (update-in (get-env) [:dependencies] concat webjar-deps))))

(deftask from-webjars
  "Add file from webjars to fileset"
  [n name NAME str "webjar / asset path"
   t target TARGET str "Target path"
   x package bool "Don't include files in result"]
  (let [tmp (temp-dir!)
        state (atom nil)
        assets (pod/with-call-in @webjar-pod (deraen.boot-from-jars.impl/asset-map))]
    (with-pre-wrap
      fileset
      (when-not @state
        (copy-file tmp (get assets name) target))
      (-> fileset ((if package add-source add-resource) tmp) commit!))))
