(ns deraen.boot-cljx.impl
  (:require
    [clojure.java.io :as io]
    [clojure.string  :as s]
    [cljx.core       :as cljx]
    [cljx.rules      :as rules]))

; Taken from cljx.core
(def ^:private warning-str ";;;;;;;;;;;; This file autogenerated from ")

(defn- change-file-ext [path new-ext]
  (s/replace path #"\.[^\.]+$" (str "." new-ext)))

(def ^:private rules {:clj  rules/clj-rules
                      :cljs rules/cljs-rules})

(defn cljx-compile [r path target-dir relative-path]
  (let [rule   (get rules r)
        result (cljx/transform (slurp path) rule)
        output (change-file-ext relative-path (:filetype rule))]
    (doto (io/file target-dir output)
      io/make-parents
      (spit (with-out-str
              (println result)
              (print warning-str)
              (println relative-path))))))
