(ns turbovote-admin-specs.export
  (:require
   [clojure.spec.alpha :as s]
   [turbovote-admin-specs.request :as request]))

(s/def ::hostnames
  (s/or :set-of-str (s/coll-of string? :into #{})
        :all-kw #(= :all %)))

;;; Stolen from `user-works.entities.address`
(def division-regex #"(?U)\Aocd\-division\/country\:[a-z]{2}(?:\/[-\w]+\:[-\w.~]+)*\z")

(s/def ::ocd-division-identifier
  (s/and string?
         #(re-matches division-regex %)))

(s/def ::ocd-ids
  (s/coll-of ::ocd-division-identifier
             :into #{}))

(s/def ::page-size int?)
(s/def ::dob-format string?) ; can/should we specify this further?
(s/def ::start-date inst?)
(s/def ::end-date inst?)
(s/def ::user-ids (s/coll-of uuid?))

(s/def ::base-export-spec
  (s/keys :req [::request/request-id ::request/request-type ::page-size]
          :opt [::dob-format]))

(s/def ::export-spec
  (s/or :hostname-export
        (s/merge ::base-export-spec
                 (s/keys :req [::hostnames]
                         :opt [::start-date ::end-date ::ocd-ids]))

        :id-export
        (s/merge ::base-export-spec
                 (s/keys :req [::user-ids]))))

(s/def ::export-url string?) ; can/should we specify this further?

(s/def ::response
  (s/keys
   :req [::request/request-id ::request/request-type ::export-url]))
