(ns turbovote-admin-specs.export
  (:require
    [clojure.spec.alpha :as s]
    [turbovote-admin-specs.request :as request]))

(s/def ::hostnames
  (s/or :set-of-str (s/coll-of string? :into #{})
        :all-kw #(= :all %)))
(s/def ::page-size int?)
(s/def ::dob-format string?) ; can/should we specify this further?
(s/def ::start-date inst?)
(s/def ::end-date inst?)

(s/def ::export-spec
  (s/keys
   :req [::request/request-id ::request/request-type ::hostnames ::page-size]
   :opt [::dob-format ::start-date ::end-date]))

(s/def ::export-url string?) ; can/should we specify this further?

(s/def ::response
  (s/keys
   :req [::request/request-id ::request/request-type ::export-url]))
