(ns turbovote-admin-specs.export
  (:require
    [clojure.spec :as s]
    [turbovote-admin-specs.request :as request]))

(s/def ::hostnames
  (s/or :set-of-str (s/coll-of string? :into #{})
        :all-kw #(= :all %)))
(s/def ::page-size int?)
(s/def ::dob-format string?) ; can/should we specify this further?

(s/def ::export-spec
  (s/keys
   :req [::request/request-id ::request/request-type ::hostnames ::page-size]
   :opt [::dob-format]))

(s/def ::export-url string?) ; can/should we specify this further?

(s/def ::response
  (s/keys
   :req [::request/request-id ::request/request-type ::export-url]))
