(ns turbovote-admin-specs.reporting
  (:require
    [clojure.spec :as s]
    [turbovote-admin-specs.request :as request]
    [turbovote-admin-specs.utils :as utils]))

(defn pull-spec
  [pull-properties]
  (s/coll-of
   pull-properties :distinct true :into [] :kind utils/list-vector-or-set?))

(s/def ::pull (pull-spec keyword?))

(s/def ::query-spec
  (s/map-of keyword? (s/map-of keyword? any?)))

(s/def ::group-by (s/coll-of keyword?))

(s/def ::query-results
  (s/map-of keyword? (s/coll-of map? :into [])))

(s/def ::query-context
  (s/keys
   :req [::request/request-id ::request/request-type ::query-spec]
   :opt [::query-results ::group-by]))

(s/def ::counts
  ;; Thanks to hiredman on Clojurians slack for
  ;; help with this recursive map solution
  (s/map-of
   (s/or :str-key string? :bool-key boolean?)
   (s/or :value number? :rec ::counts)))

(s/def ::result-message
  (s/keys :req [::request/request-id ::request/request-type ::counts]))
