(ns turbovote-admin-specs.reporting.user
  (:require
    [clojure.spec :as s]
    [turbovote-admin-specs.reporting :as reporting]))

(s/def ::hostname string?)
(s/def ::uid uuid?)

(s/def ::hostnames (s/or ::all (s/and keyword? #(= ::all %))
                         ::specific-hostnames (s/coll-of string?
                                                         :distinct true
                                                         :into #{})))
(s/def ::states (s/coll-of #{"AL" "AK" "AZ" "AR" "CA" "CO" "CT" "DE" "DC" "FL" "GA" "HI"
                             "ID" "IL" "IN" "IA" "KA" "KY" "LA" "ME" "MD" "MA" "MI" "MN"
                             "MS" "MO" "MT" "NE" "NV" "NH" "NJ" "NM" "NY" "NC" "ND" "OH"
                             "OK" "OR" "PA" "RI" "SC" "SD" "TN" "TX" "UT" "VT" "VA" "WA"
                             "WV" "WI" "WY"}
                           :into #{}))

(s/def ::filter (s/keys :req [::hostnames] :opt [::states ::registered?]))

(def pull-properties
  #{::hostname ::zip ::state ::email})
(s/def ::pull (reporting/pull-spec pull-properties))

(def group-by-properties
  #{::hostname})
(s/def ::group-by (s/coll-of group-by-properties :kind vector? :distinct true))

(s/def ::report-request (s/keys :req [::filter ::pull] :opt [::group-by]))

(s/def ::user (s/keys :req [::pull ::filter]))

(s/def ::reporting/query-spec (s/keys :opt [::user]))
