(ns turbovote-admin-specs.reporting
  (:require
    [clojure.spec :as s]))

(s/def ::session-id uuid?)
(s/def ::request-id uuid?)
(s/def ::request-type keyword?)

(defn list-vector-or-set?
  [c]
  (or (list? c) (set? c) (vector? c)))

(defn pull-spec
  [pull-properties]
  (s/coll-of
   pull-properties :distinct true :into [] :kind list-vector-or-set?))

(s/def ::pull (pull-spec keyword?))

(s/def ::query-spec
  (s/map-of keyword? (s/map-of keyword? any?)))

(s/def ::query-result
  (s/map-of keyword? (s/coll-of map? :into [])))

(s/def ::group-by (s/coll-of keyword?))

(s/def ::query-results (s/coll-of map? :into []))

(s/def ::query-context
  (s/keys :req [::session-id ::request-id ::request-type ::query-spec]
          :opt [::query-results ::group-by]))

(s/def ::counts
  (s/map-of string? number?))

(s/def ::result-message
  (s/keys :req [::session-id ::request-id ::request-type ::counts]))
