(ns turbovote-admin-specs.utils
  (:require
    [clojure.spec :as s]))

(defn conform-or-throw
  ([spec value]
   (conform-or-throw spec value ""))
  ([spec value extra-msg]
   (let [value' (s/conform spec value)]
     (if (= ::s/invalid value')
       (->> (s/explain-data spec value)
            (ex-info (str extra-msg "Value doesn't match spec: " ))
            throw)
       value'))))
