(ns gov-notifications-specs.predicate
  "Spec predicates that are not specific to an entity."
  (:import
   (java.time Period)
   (java.time.format DateTimeParseException)))

(defn iso-8601-period?
  "Is `s` a string representation of an ISO-8601 period?

  Example: \"P2Y\""
  [^CharSequence s]
  (try
    (Period/parse s)
    true
    (catch DateTimeParseException _
      false)))
