(ns gov-notifications-specs.entity.partner
  "Specifies partner-related entities."
  (:require
   [clojure.spec.alpha :as spec]
   [clojure.spec.gen.alpha :as gen]
   [gov-notifications-specs.entity.notification-schedule]))

(spec/def :gn.partner.notification/id keyword?)
(spec/def :gn.partner.notification/schedule
  (spec/keys :req [:gn.notification-schedule/offset-period
                   :gn.notification-schedule/offset-from]))

(spec/def :gn.partner/id uuid?)
(spec/def :gn.partner/name string?)
(spec/def :gn.partner/active? boolean?)
(spec/def :gn.partner/cognito-forms-id
  (spec/with-gen string?
    #(gen/fmap (fn [n]
                 (str (inc (Math/abs n))))
               (gen/int))))
(spec/def :gn.partner/notifications
  (spec/coll-of
   (spec/keys :req [:gn.partner.notification/id]
              :opt [:gn.partner.notification/schedule])
   :kind #(or (sequential? %) (set? %))
   :into #{}))

(spec/def :gn/partner
  (spec/keys :req [:gn.partner/id :gn.partner/name :gn.partner/active?]
             :opt [:gn.partner/cognito-forms-id :gn.partner/notifications]))
