(ns gov-notifications-specs.entity.notification-schedule
  "Specifies notification-schedule-related entities."
  (:require
   [clojure.spec.alpha :as spec]
   [clojure.spec.gen.alpha :as gen]
   [gov-notifications-specs.predicate :as predicate]))

(spec/def :gn.notification-schedule/offset-period
  (spec/with-gen predicate/iso-8601-period?
    #(gen/fmap (fn [[neg d]]
                 (str neg "P" d "D"))
               (gen/tuple (gen/elements ["" "-"])
                          (gen/elements (map inc (range 30)))))))
(spec/def :gn.notification-schedule/offset-from
  #{:gn.offset-type/election-date
    :gn.offset-type/registration-by-mail})
