(ns gov-notifications-specs.entity.datomic
  "Specifies datomic-related entities."
  (:require
   [clojure.spec.alpha :as spec]
   [clojure.spec.gen.alpha :as gen]))

(defn datomic-unique-id?
  "A best-effort specification of a Datomic unique identifier.

  http://docs.datomic.com/identity.html#lookup-refs"
  [uid]
  (or (integer? uid)
      (and (coll? uid)
           (= 2 (count uid))
           (keyword? (first uid)))))

(spec/def :db/id
  (spec/with-gen datomic-unique-id?
    #(gen/one-of [(gen/int)
                  (gen/tuple (gen/keyword) (gen/uuid))])))
