(ns election-reminders-specs.entity
  "Election Reminders \"entity\" specifications: specifications that assume
  some collection of attributes."
  (:require
   [clojure.spec.alpha :as s]
   [election-reminders.user :as user]
   [election-reminders.partner :as partner]))

(defn valid-user-subscriptions?
  "Tests if all subscriptions have associated contact information."
  [m]
  (if-let [subscriptions (not-empty (get m ::user/notification-media))]
    (let [has-contact-for? {:email (contains? m ::user/email-address)
                            :sms (contains? m ::user/phone-number)}]
      (every? has-contact-for? subscriptions))
    true))

(s/def ::valid-user-subscriptions valid-user-subscriptions?)

(defn one-partner-id?
  "Tests if only one type of partner ID is present in the entity."
  [m]
  (let [get-ids (juxt ::partner/id ::partner/cognito-forms-id)]
    (= 1 (count (filter some? (get-ids m))))))

(s/def ::one-partner-id one-partner-id?)
