(ns election-reminders.user
  "Specifies user-related attributes."
  (:require
   [clojure.spec.alpha :as s]
   [election-reminders.address :as address]
   [election-reminders.election :as election]
   [election-reminders.partner :as partner]
   [election-reminders-specs.common :as common]))

(s/def ::id uuid?)
(s/def ::partner
  (s/keys :req [::partner/id]))
(s/def ::elections
  (s/coll-of (s/keys :req [::election/id])
             :kind set?
             :min-count 1))
(s/def ::first-name string?)
(s/def ::last-name string?)
(s/def ::registered-address
  (s/keys :req [::address/delivery-line-1
                ::address/city
                ::address/state
                ::address/zip-code]
          :opt [::address/delivery-line-2
                ::address/ocd-division-ids
                ::address/standardized-at]))
(s/def ::email-address string?)
(s/def ::phone-number ::common/phone-number)
(s/def ::notification-language keyword?)
(s/def ::notification-medium
  #{:email :sms})
(s/def ::notification-media
  (s/coll-of ::notification-medium
             :kind set?
             :min-count 1))
(s/def ::time-zone-id ::common/time-zone-id)
(s/def ::created-at inst?)
