(ns election-reminders.notification
  "Specifies notification-related attributes."
  (:require
   [clojure.spec.alpha :as s]
   [election-reminders-specs.common :as common]))

(defmulti notification-type ::type)

;; A notification sent at some offset relative to a date given in the database.
(defmethod notification-type :offset
  [_]
  (s/keys :req [::offset-from
                ::send-after-offset]
          :opt [::send-before-offset]))

;; A notification sent on a specific date.
(defmethod notification-type :date
  [_]
  (s/keys :req [::send-after-date]
          :opt [::send-before-date]))

;; A notification sent immediately.
(defmethod notification-type :immediate
  [_]
  true)

(s/def ::id uuid?)
(s/def ::notification-id keyword?)
(s/def ::type keyword?)
(s/def ::offset-from keyword?)
(s/def ::send-after-date ::common/iso-8601-date)
(s/def ::send-before-date ::common/iso-8601-date)
(s/def ::send-after-offset ::common/iso-8601-period)
(s/def ::send-before-offset ::common/iso-8601-period)
