# cognitect-aws-retry

A Clojure library designed to be an extension to Cognitect's AWS API library that gives a 
little more flexibility with retries based on what http-response error code we get back.

## Usage

```clojure
(ns my.service
  (:require [cognitect.aws.client.api :as aws]
            [democracyworks.cognitect.aws.credentials :as credentials]
            [democracyworks.cognitect.aws.retry :as retry]))

 (def ^:private s3-client
   "A delay yielding an S3 client."
   (delay
     (aws/client
      {:api :s3
       :retriable? retry/retriable?
       :credentials-provider (credentials/default-credentials-provider)})))
       
;; Use the library normally.
```

## Legal

Copyright © 2020 Democracy Works, Inc.
