(ns democracyworks.cognitect.aws.retry
  (:require [cognitect.aws.retry :as retry]))

(defn retriable?
  "Tests `http-response` for S3-specific error codes, delegating to
  [[retry/default-retriable?]] otherwise."
  [http-response]
  (let [throwable-error (:cognitect.http-client/throwable http-response)
        status (get-in (meta http-response) [:http-response :status])]
    (or (>= status 500)
        (instance? java.io.IOException throwable-error)
        (retry/default-retriable? http-response))))
