(ns ballot-scout-specs.predicate
  "Spec predicates that are not specific to an entity."
  (:import
   (java.time.format
    DateTimeFormatter
    DateTimeParseException)))

(def ^:private iso-zoned-date-time-formatter
  (DateTimeFormatter/ISO_ZONED_DATE_TIME))

(defn iso-zoned-date-time?
  "Test if `s` a string representation of a timestamp with time zone offset and
  time zone identifier.

  More information about the format:
  https://docs.oracle.com/javase/8/docs/api/java/time/format/DateTimeFormatter.html#ISO_ZONED_DATE_TIME"
  [^CharSequence s]
  (try
    (.parse iso-zoned-date-time-formatter s)
    true
    (catch DateTimeParseException _
      false)))
