(ns ballot-scout-specs.entity.policy-violation
  "A possible shape of a Content-Security-Policy report, as described "
  (:require [clojure.spec.alpha :as s]
            [clojure.spec.gen.alpha :as gen]
            [io.pedestal.log :as log]))

(s/def ::nonempty-string (s/and string? not-empty))

(s/def ::blocked-uri ::nonempty-string)
(s/def ::disposition ::nonempty-string)
(s/def ::document-uri ::nonempty-string)
(s/def ::original-policy ::nonempty-string)
(s/def ::violated-directive ::nonempty-string)

;;; No guarantees about a referrer if we're iframed
(s/def ::referrer string?)

(s/def ::csp-report
  (s/keys :req-un [::blocked-uri ::disposition ::document-uri
                   ::original-policy ::referrer ::violated-directive]))

(s/def ::policy-violation
  (s/keys :req-un [::csp-report]))
