(ns ballot-scout-specs.entity.brickftp-event
  "Specs describing the shape of a JSON webhook from files.com"
  (:require [clojure.spec.alpha :as s]
            [clojure.spec.gen.alpha :as gen]
            [io.pedestal.log :as log]))

;;; See also: https://brickftp.com/docs/webhook-api/
(s/def ::nonempty-string (s/and string? not-empty))

(s/def ::action
  (s/with-gen ::nonempty-string
    #(s/gen
      #{"create" "read" "update"
        "destroy" "move" "copy"})))

(s/def ::path        ::nonempty-string)
(s/def ::at          ::nonempty-string)
(s/def ::destination ::nonempty-string)

(s/def ::interface
  (s/with-gen ::nonempty-string
    #(s/gen
      #{"web" "ftp" "robot" "jsapi"
        "restapi" "sftp" "dav"})))

(s/def ::type
  (s/with-gen ::nonempty-string
    #(s/gen #{"file" "directory"})))

(s/def ::username    ::nonempty-string)

(s/def ::file-event
  (s/keys :req-un [::action ::path]
          :opt-un [::at ::destination ::interface ::type ::username]))
