(ns ballot-scout-specs.entity.disposition-event
  "Specifies a ballot disposition event."
  (:require
   [ballot-scout-specs.predicate :as predicate]
   [clojure.spec.alpha :as s]
   [clojure.spec.gen.alpha :as gen])
  (:import
   (java.time
    Instant
    ZonedDateTime
    ZoneId)))

(s/def :bs.disposition-event/partner-id uuid?)
(s/def :bs.disposition-event/external-id string?)
(s/def :bs.disposition-event/status keyword?)
(s/def :bs.disposition-event/timestamp
 (s/with-gen
  (s/and string? predicate/iso-zoned-date-time?)
  (fn []
    (gen/fmap
     (fn [[inst zone]]
       (str (ZonedDateTime/ofInstant inst zone)))
     (gen/tuple
      (gen/fmap #(Instant/ofEpochSecond %)
                (gen/int))
      (gen/elements #{(ZoneId/of "America/Los_Angeles")
                      (ZoneId/of "America/New_York")}))))))

(s/def :bs/disposition-event
  (s/keys :req [:bs.disposition-event/partner-id
                :bs.disposition-event/external-id
                :bs.disposition-event/status
                :bs.disposition-event/timestamp]))
