(ns uikit-hl.offcanvas
  (:require [hoplon.core :as h]
            [uikit-hl.core :as uk]))

(def ^:dynamic *uk-offcanvas* "")

(defmethod h/do! :uk-offcanvas
  [elem _ v]
  (.offcanvas uk/uikit elem (clj->js v)))

(h/defelem content [attr kids]
  (h/div
    (core/assoc-class attr {:uk-offcanvas-content true})
    kids))

(h/defelem offcanvas [attr kids]
  (let [offcanvas (:uk-offcanvas attr *uk-offcanvas*)
        attr (assoc attr :uk-offcanvas offcanvas)]
    (h/div attr kids)))

(h/defelem bar [attr kids]
  (h/div
    (core/assoc-class attr {:uk-offcanvas-bar true})
    kids))
