(ns uikit-hl.search
  (:require [hoplon.core :as hl]
            [uikit-hl.core :as core]))

(defmulti uk-search! h/kw-dispatcher :default ::default)

(defn format-search [search]
  (str "uk-search-" search))

(defmethod h/do! ::default
  [elem key val]
  (uk-search! elem key val))

(defmethod uk-search! ::default
  [elem key val]
  (elem :class {(format-search (name key)) val}))

(defmethod uk-search! ::search
  [elem _ v]
  (.search uk/uikit elem (clj->js v)))

(hl/defelem search [attr kids]
  (let [large (:large attr)]
    (hl/form attr :uk-search true :uk-search-large large kids)))

(hl/defelem input [attr kids]
  (hl/input attr :uk-search-input true :type "search" kids))
