(ns uikit-hl.table
  (:require [hoplon.core :as hl]
            [javelin.core :as j]
            [uikit-hl.core :as core]))

(defmulti uk-table! h/kw-dispatcher :default ::default)

(defn format-table [grid]
  (str "uk-table-" grid))

(defmethod h/do! ::default
  [elem key val]
  (uk-table! elem key val))

(defmethod uk-table! ::default
  [elem key val]
  (h/do! elem :class {(format-table (name key)) val}))

(defmethod uk-table! ::table
  [elem _ v]
  (h/do! elem :class {:uk-table val}))

(hl/defelem table [attr kids]
  (let [caption (:caption attr *caption*)
        headers (:headers attr *headers*)
        body    (:data    attr (or *data* kids))
        footers (:footers attr *footers*)
        divider (:divider attr *divider*)
        striped (:striped attr *striped*)
        hover   (:hover   attr *hover*)
        small   (:small   attr *small*)
        justify (:justify attr *justify*)
        middle  (:middle  attr *middle*)
        responsive (:responsive attr *responsive*)
        attr (dissoc attr :caption :divider :striped :hover :small :justify :middle :responsive)]
    (hl/table
      attr
      ::table      true
      ::divider    divider
      ::striped    striped
      ::hover      hover
      ::small      small
      ::justify    justify
      ::middle     middle
      ::responsive responsive
      kids)))

(def thead h/thead)
(def tbody h/tbody)
(def tfoot h/tfoot)
(def tr    h/tr)
(def th    h/th)
(def td    h/td)
(def caption h/caption)
