(ns uikit-hl.notification
  (:require [hoplon.core :as hl]
            [uikit-hl.core :as core]))

(defmethod hl/do! :uk-notification
  [elem _ v]
  (let [notify #(.notification js/UIkit (clj->js v))]
    (hl/do! elem :click/uikit (notify))))

(defmethod hl/do! :uk-search-large
  [elem _ v]
  (hl/do! elem :class/uikit {:uk-search-large v}))

(defmethod hl/do! :uk-search-input
  [elem _ v]
  (hl/do! elem :class/uikit {:uk-search-input v}))
