(ns uikit-hl.heading
  (:require [hoplon.core :as hl]
            [uikit-hl.core :as core]))

(defmethod hl/do! :uk-heading-primary
  [elem _ v]
  (hl/do! elem :class/uikit {:uk-heading-primary v}))

(defmethod hl/do! :uk-heading-hero
  [elem _ v]
  (hl/do! elem :class/uikit {:uk-heading-hero v}))

(defmethod hl/do! :uk-heading-divider
  [elem _ v]
  (hl/do! elem :class/uikit {:uk-heading-divider v}))

(defmethod hl/do! :uk-heading-bullet
  [elem _ v]
  (hl/do! elem :class/uikit {:uk-heading-bullet v}))

(defmethod hl/do! :uk-heading-line
  [elem _ v]
  (hl/do! elem :class/uikit {:uk-heading-line v}))

(hl/defelem heading [attr kids]
  (let [heading (:uk-heading attr *uk-heading*)
        attr      (assoc attr :uk-heading heading)]
    (hl/ul attr kids)))

(hl/defelem item [attr kids]
  (let [title (:title attr *title*)
        attr  (dissoc attr :title)]
    (hl/li attr
      (hl/h3  :class [:uk-heading-title] (hl/text "~{title}"))
      (hl/div :class [:uk-heading-content] kids))))
