(ns uikit-hl.label
  (:require [hoplon.core :as hl]
            [uikit-hl.core :as core]))

(defmethod hl/do! :uk-label
  [elem _ v]
  (hl/do! :class/uikit {:uk-label v}))

(hl/defelem label [attr kids]
  (let [success (:success attr)
        warning (:warning attr)
        danger  (:danger attr)]
    (hl/span
      attr
      :uk-label true
      :uk-label-success success
      :uk-label-warning warning
      :uk-label-danger  danger 
      kids)))
