(ns uikit-hl.form
  (:require [hoplon.core :as hl]
            [uikit-hl.core :as core]))

(hl/defelem form [attr kids]
  (let [stacked    (:stacked    attr)
        horizontal (:horizontal attr)]
    (hl/form
      attr
      :uk-form-stacked stacked
      :uk-form-horizontal horizontal
      kids)))

(hl/defelem icon [attr kids]
  (let [flip (:flip attr *flip*)]
    (hl/span :class/uikit {:uk-form-icon true
                           :uk-form-icon-flip flip} kids)))

(hl/defelem input [attr kids]
  (hl/input attr :class/uikit {:uk-input true} kids))

(hl/defelem fieldset [attr kids]
  (hl/fieldset :class/uikit {:uk-fieldset true} kids))

(hl/defelem legend [attr kids]
  (hl/legend :class/uikit {:uk-legend true} kids))

(hl/defelem checkbox [attr kids]
  (hl/label [(hl/input :class/uikit {:uk-checkbox true}) " " kids]))

(hl/defelem radio [attr kids]
  (hl/label [(hl/input attr :class/uikit {:uk-radio true}) " " kids]))

(defmethod h/do! :uk-form-danger
  [elem _ v]
  (h/do! elem :class/uikit {:uk-form-danger v}))

(defmethod h/do! :uk-form-success
  [elem _ v]
  (h/do! elem :class/uikit {:uk-form-success v}))

(defmethod h/do! :uk-form-small
  [elem _ v]
  (h/do! elem :class/uikit {:uk-form-small v}))

(defmethod h/do! :uk-form-large
  [elem _ v]
  (h/do! elem :class/uikit {:uk-form-large v}))

(defmethod h/do! :uk-form-width-xsmall
  [elem _ v]
  (h/do! elem :class/uikit {:uk-form-width-xsmall v}))

(defmethod h/do! :uk-form-width-small
  [elem _ v]
  (h/do! elem :class/uikit {:uk-form-width-small v}))

(defmethod h/do! :uk-form-width-medium
  [elem _ v]
  (h/do! elem :class/uikit {:uk-form-width-medium v}))

(defmethod h/do! :uk-form-width-large
  [elem _ v]
  (h/do! elem :class/uikit {:uk-form-width-large v}))

(defmethod h/do! :uk-form-blank
  [elem _ v]
  (h/do! elem :class/uikit {:uk-form-blank v}))

(defmethod h/do! :uk-form-stacked
  [elem _ v]
  (h/do! elem :class/uikit {:uk-form-stacked v}))

(defmethod h/do! :uk-form-horizontal
  [elem _ v]
  (h/do! elem :class/uikit {:uk-form-horizontal v}))

(defmethod h/do! :uk-form-label
  [elem _ v]
  (h/do! elem :class/uikit {:uk-form-horizontal v}))

(defmethod h/do! :uk-form-controls
  [elem _ v]
  (h/do! elem :class/uikit {:uk-form-controls v}))

(defmethod h/do! :uk-form-icon
  [elem _ v]
  (h/do! elem :class/uikit {:uk-form-icon v}))

(defmethod h/do! :uk-form-icon-flip
  [elem _ v]
  (h/do! elem :class/uikit {:uk-form-icon-flip v}))

(defmethod h/do! :uk-form-custom
  [elem _ v]
  (.formCustom js/UIKit elem (clj->js v)))
