(ns uikit-hl.form
  (:require [hoplon.core :as hl]
            [uikit-hl.core :as core]))

(hl/defelem form [attr kids]
  (let [stacked    (:stacked    attr)
        horizontal (:horizontal attr)]
    (hl/form (core/assoc-class attr {:uk-form-stacked    stacked
                                     :uk-form-horizontal horizontal}) kids)))

(hl/defelem icon [attr kids]
  (let [flip (:flip attr *flip*)]
    (hl/span (core/assoc-class attr {:uk-form-icon true
                                     :uk-form-icon-flip flip}) kids)))

(hl/defelem input [attr kids]
  (hl/input attr :class/uikit {:uk-input true} kids))

(hl/defelem fieldset [attr kids]
  (hl/fieldset :class/uikit {:uk-fieldset true} kids))

(hl/defelem legend [attr kids]
  (hl/legend :class/uikit {:uk-legend true} kids))

(hl/defelem checkbox [attr kids]
  (hl/label [(hl/input :class/uikit {:uk-checkbox true}) " " kids]))

(hl/defelem radio [attr kids]
  (hl/label [(hl/input attr :class/uikit {:uk-radio true}) " " kids]))
