(ns uikit-hl.form
  (:require [hoplon.core :as hl]
            [uikit-hl.core :as core]))

(def ^:dynamic *danger*  nil)
(def ^:dynamic *success* nil)

(def ^:dynamic *small*  nil)
(def ^:dynamic *large*  nil)

(def ^:dynamic *width-large*  nil)
(def ^:dynamic *width-medium* nil)
(def ^:dynamic *width-small*  nil)
(def ^:dynamic *width-xsmall* nil)

(def ^:dynamic *blank* nil)

(def ^:dynamic *stacked* nil)
(def ^:dynamic *horizontal* nil)

(def ^:dynamic *flip* nil)

(hl/defelem form [attr kids]
  (let [stacked    (:stacked    attr *stacked*)
        horizontal (:horizontal attr *horizontal*)]
    (hl/form (core/assoc-class attr {:uk-form-stacked    stacked
                                     :uk-form-horizontal horizontal}) kids)))

(hl/defelem icon [attr kids]
  (let [flip (:flip attr *flip*)]
    (hl/span (core/assoc-class attr {:uk-form-icon true
                                     :uk-form-icon-flip flip}) kids)))

(hl/defelem input [attr kids]
  (hl/input attr :class/uikit {:uk-input true} kids))

(hl/defelem fieldset [attr kids]
  (hl/fieldset (core/assoc-class attr {:uk-fieldset true}) kids))

(hl/defelem legend [attr kids]
  (hl/legend (core/assoc-class attr {:uk-legend true}) kids))

(hl/defelem checkbox [attr kids]
  (hl/label [(hl/input (core/assoc-class attr {:uk-checkbox true})) " " kids]))

(hl/defelem radio [attr kids]
  (hl/label [(hl/input attr :class {:uk-radio true}) " " kids]))
