(ns uikit-hl.spinner
  (:require [hoplon.core :as hl]
            [uikit-hl.core :as core]))

(def ^:dynamic *uk-spinner* "")
(def ^:dynamic *title* "")

(defmethod hl/do! :uk-spinner
  [elem _ v]
  (.spinner js/UIkit elem (clj->js v)))

(hl/defelem spinner [attr kids]
  (let [spinner (:uk-spinner attr *uk-spinner*)
        attr      (assoc attr :uk-spinner spinner)]
    (hl/ul attr kids)))

(hl/defelem item [attr kids]
  (let [title (:title attr *title*)
        attr  (dissoc attr :title)]
    (hl/li attr
      (hl/h3  :class [:uk-spinner-title] (hl/text "~{title}"))
      (hl/div :class [:uk-spinner-content] kids))))
