(ns uikit-hl.visibility
  (:require [hoplon.core :as hl]
            [javelin.core :as j]
            [uikit-hl.core :as core]))

(def ^:dynamic *uk-invisible* nil)

(def ^:dynamic *uk-hidden-s*  nil)
(def ^:dynamic *uk-hidden-m*  nil)
(def ^:dynamic *uk-hidden-l*  nil)

(defmethod hl/do! :uk-invisible
  [elem _ v]
  (hl/do! elem :class/uikit {:uk-invisible v}))

(hl/defelem invisible [attr kids]
  (let [invisible (:uk-invisible attr *uk-invisible*)]
    (hl/div attr :class/uikit {:uk-invisible invisible} kids)))

(defmethod hl/do! :uk-hidden-s
  [elem _ v]
  (hl/do! elem :class/uikit {(keyword "uk-hidden@s") v}))

(defmethod hl/do! :uk-hidden-m
  [elem _ v]
  (hl/do! elem :class/uikit {(keyword "uk-hidden@s") v}))

(defmethod hl/do! :uk-hidden-l
  [elem _ v]
  (hl/do! elem :class/uikit {(keyword "uk-hidden@s") v}))

(hl/defelem hidden [attr kids]
  (let [hidden-s (:small attr *uk-hidden-s*)]
    (hl/div attr :uk-hidden-s hidden-s kids)))
