(ns uikit-hl.visibility
  (:require [hoplon.core :as hl]
            [javelin.core :as j]
            [uikit-hl.core :as core]))

(def ^:dynamic *uk-invisible* nil)

(defmethod hl/do! :uk-invisible
  [elem _ v]
  (hl/do! elem :class/uikit {:uk-invisible v}))

(defmethod hl/do! :uk-hidden-s
  [elem _ v]
  (hl/do! elem :class/uikit {(keyword "uk-hidden@s") v}))

(hl/defelem invisible [attr kids]
  (let [invisible (:uk-invisible attr *uk-invisible*)]
    (hl/div attr :class/uikit {:uk-invisible invisible} kids)))
