(ns uikit-hl.description-list
  (:require [hoplon.core :as hl]
            [uikit-hl.core :as core]))

(def ^:dynamic *title* nil)
(def ^:dynamic *meta* nil)

(hl/defelem description-list [attr kids]
  (let [title (:title attr *title*)
        meta  (:meta attr *meta*)
        attr  (-> attr (dissoc :title :meta) (assoc :class [:uk-description-list]))]
    (hl/description-list attr
      (hl/h1 :class [:uk-description-list-title] title)
      (hl/p :class [:uk-description-list-meta] meta)
      (hl/p kids))))
