(ns uikit-hl.flex
  (:require [hoplon.core :as hl]
            [uikit-hl.core :as core]))

(def ^:dynamic *uk-flex*        true)
(def ^:dynamic *uk-flex-inline* nil)

(def ^:dynamic *uk-flex-first*    nil)
(def ^:dynamic *uk-flex-first-s*  nil)
(def ^:dynamic *uk-flex-first-m*  nil)
(def ^:dynamic *uk-flex-first-l*  nil)
(def ^:dynamic *uk-flex-first-xl* nil)

(def ^:dynamic *uk-flex-center*    nil)
(def ^:dynamic *uk-flex-center-s*  nil)
(def ^:dynamic *uk-flex-center-m*  nil)
(def ^:dynamic *uk-flex-center-l*  nil)
(def ^:dynamic *uk-flex-center-xl* nil)

(def ^:dynamic *uk-flex-right*    nil)
(def ^:dynamic *uk-flex-right-s*  nil)
(def ^:dynamic *uk-flex-right-m*  nil)
(def ^:dynamic *uk-flex-right-l*  nil)
(def ^:dynamic *uk-flex-right-xl* nil)

(def ^:dynamic *uk-flex-between*    nil)
(def ^:dynamic *uk-flex-between-s*  nil)
(def ^:dynamic *uk-flex-between-m*  nil)
(def ^:dynamic *uk-flex-between-l*  nil)
(def ^:dynamic *uk-flex-between-xl* nil)

(def ^:dynamic *uk-flex-around*    nil)
(def ^:dynamic *uk-flex-around-s*  nil)
(def ^:dynamic *uk-flex-around-m*  nil)
(def ^:dynamic *uk-flex-around-l*  nil)
(def ^:dynamic *uk-flex-around-xl* nil)

(def ^:dynamic *uk-flex-stretch* nil)
(def ^:dynamic *uk-flex-top*     nil)
(def ^:dynamic *uk-flex-middle*  nil)
(def ^:dynamic *uk-flex-bottom*  nil)

(def ^:dynamic *uk-flex-row*            nil)
(def ^:dynamic *uk-flex-row-reverse*    nil)
(def ^:dynamic *uk-flex-column*         nil)
(def ^:dynamic *uk-flex-column-reverse* nil)

(def ^:dynamic *uk-flex-wrap*            nil)
(def ^:dynamic *uk-flex-wrap-reverse*    nil)
(def ^:dynamic *uk-flex-nowrap*          nil)

(def ^:dynamic *uk-flex-wrap-stretch* nil)
(def ^:dynamic *uk-flex-wrap-between* nil)
(def ^:dynamic *uk-flex-wrap-around*  nil)
(def ^:dynamic *uk-flex-wrap-top*     nil)
(def ^:dynamic *uk-flex-wrap-middle*  nil)
(def ^:dynamic *uk-flex-wrap-bottom*  nil)

(def ^:dynamic *uk-flex-first*    nil)
(def ^:dynamic *uk-flex-first-s*  nil)
(def ^:dynamic *uk-flex-first-m*  nil)
(def ^:dynamic *uk-flex-first-l*  nil)
(def ^:dynamic *uk-flex-first-xl* nil)

(def ^:dynamic *uk-flex-last*    nil)
(def ^:dynamic *uk-flex-last-s*  nil)
(def ^:dynamic *uk-flex-last-m*  nil)
(def ^:dynamic *uk-flex-last-l*  nil)
(def ^:dynamic *uk-flex-last-xl* nil)

(defmethod hl/do! :uk-flex
  [elem _ v]
  (->> v
    (merge {:uk-flex        *uk-flex*
            :uk-flex-inline *uk-flex-inline*

            :uk-flex-first               *uk-flex-first*
            (keyword "uk-flex-first@s")  *uk-flex-first-s*
            (keyword "uk-flex-first@m")  *uk-flex-first-m*
            (keyword "uk-flex-first@l")  *uk-flex-first-l*
            (keyword "uk-flex-first@xl") *uk-flex-first-xl*

            :uk-flex-center               *uk-flex-center*
            (keyword "uk-flex-center@s")  *uk-flex-center-s*
            (keyword "uk-flex-center@m")  *uk-flex-center-m*
            (keyword "uk-flex-center@l")  *uk-flex-center-l*
            (keyword "uk-flex-center@xl") *uk-flex-center-xl*

            :uk-flex-right               *uk-flex-right*
            (keyword "uk-flex-right@s")  *uk-flex-right-s*
            (keyword "uk-flex-right@m")  *uk-flex-right-m*
            (keyword "uk-flex-right@l")  *uk-flex-right-l*
            (keyword "uk-flex-right@xl") *uk-flex-right-xl*

            :uk-flex-between               *uk-flex-between*
            (keyword "uk-flex-between@s")  *uk-flex-between-s*
            (keyword "uk-flex-between@m")  *uk-flex-between-m*
            (keyword "uk-flex-between@l")  *uk-flex-between-l*
            (keyword "uk-flex-between@xl") *uk-flex-between-xl*

            :uk-flex-around               *uk-flex-around*
            (keyword "uk-flex-around@s")  *uk-flex-around-s*
            (keyword "uk-flex-around@m")  *uk-flex-around-m*
            (keyword "uk-flex-around@l")  *uk-flex-around-l*
            (keyword "uk-flex-around@xl") *uk-flex-around-xl*

            :uk-flex-stretch *uk-flex-stretch*
            :uk-flex-top     *uk-flex-top*
            :uk-flex-middle  *uk-flex-middle*
            :uk-flex-bottom  *uk-flex-bottom*

            :uk-flex-row            *uk-flex-row*
            :uk-flex-row-reverse    *uk-flex-row-reverse*
            :uk-flex-column         *uk-flex-column*
            :uk-flex-column-reverse *uk-flex-column-reverse*

            :uk-flex-wrap         *uk-flex-wrap*
            :uk-flex-wrap-reverse *uk-flex-wrap-reverse*
            :uk-flex-nowrap       *uk-flex-nowrap*

            :uk-flex-wrap         *uk-flex-wrap*
            :uk-flex-wrap-stretch *uk-flex-stretch*
            :uk-flex-wrap-between *uk-flex-between*
            :uk-flex-wrap-around  *uk-flex-around*
            :uk-flex-wrap-top     *uk-flex-top*
            :uk-flex-wrap-middle  *uk-flex-middle*
            :uk-flex-wrap-bottom  *uk-flex-bottom*


})
    (hl/do! elem :class )))
